<?php
/**
 * The template for displaying 404 pages (Not Found)
 */
 $acens_redux_demo = get_option('redux_demo');
get_header(); ?> 
<?php if(isset($acens_redux_demo['image_error']['url']) && $acens_redux_demo['image_error']['url'] != ''){?>
<section class="banner-header section-padding bg-img bg-fixed" data-overlay-dark="5" data-background="<?php echo esc_url($acens_redux_demo['image_error']['url']); ?>">
<?php }else{ ?>
<section class="banner-header section-padding bg-img bg-fixed" data-overlay-dark="10">
<?php } ?>
    <div class="v-middle">
        <div class="container">
            <div class="row">
                <div class="col-md-12 text-center mt-60">
                    <h1><?php if(isset($acens_redux_demo['error'])){?>
                            <?php echo esc_attr($acens_redux_demo['error']);?>
                            <?php }else{?>
                            <?php echo esc_html__( '404 Not Found', 'acens' ); } ?></h1>
                    <ul class="breadcrumbs">
                        <li><a href="<?php echo esc_url(home_url('/')); ?>">Home</a></li>
                        <li><?php if(isset($acens_redux_demo['error_subtitle'])){?>
                            <?php echo esc_attr($acens_redux_demo['error_subtitle']);?>
                            <?php }else{?>
                            <?php echo esc_html__( 'Not Found', 'acens' ); } ?></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- divider line -->
<div class="line-vr-section"></div>
<!-- 404 Page -->
<section class="not-found section-padding">
    <div class="container">
        <div class="row mb-45">
            <div class="col-md-12 text-center">
                <h2><?php if(isset($acens_redux_demo['404'])){?>
                            <?php echo esc_attr($acens_redux_demo['404']);?>
                            <?php }else{?>
                            <?php echo esc_html__( '404', 'acens' ); } ?></h2>
                <h1 class="wow" data-splitting><?php if(isset($acens_redux_demo['page_not_found'])){?>
                            <?php echo esc_attr($acens_redux_demo['page_not_found']);?>
                            <?php }else{?>
                            <?php echo esc_html__( 'Page Not Found', 'acens' ); } ?></h1>
                <p class="wow" data-splitting><?php if(isset($acens_redux_demo['text'])){?>
                            <?php echo esc_attr($acens_redux_demo['text']);?>
                            <?php }else{?>
                            <?php echo esc_html__( 'The page you are looking for was moved, removed, renamed or never existed.', 'acens' ); } ?></p>
            </div>
        </div>
    </div>
</section>
<?php
get_footer(); ?> 
