<?php
$acens_redux_demo = get_option('redux_demo');

//Custom fields:
require_once get_template_directory() . '/framework/wp_bootstrap_navwalker.php';
require_once get_template_directory() . '/framework/class-ocdi-importer.php';
//Theme Set up:
function acens_theme_setup() {
    /*
     * This theme uses a custom image size for featured images, displayed on
     * "standard" posts and pages.
     */
  	add_theme_support( 'custom-header' ); 
  	add_theme_support( 'custom-background' );
  	$lang = get_template_directory_uri() . '/languages';
    load_theme_textdomain( 'acens', $lang );
    add_theme_support( 'post-thumbnails' );
    // Adds RSS feed links to <head> for posts and comments.
    add_theme_support( 'automatic-feed-links' );
    // Switches default core markup for search form, comment form, and comments
    // to output valid HTML5.
    add_theme_support( 'title-tag' );
    add_theme_support( 'html5', array( 'search-form', 'comment-form', 'comment-list' ) );
    // This theme uses wp_nav_menu() in one location.
  	register_nav_menus( array(
      'primary' =>  esc_html__( 'Primary Menu: Chosen menu in home Light', 'acens' ),
      'primary_dark' =>  esc_html__( 'Primary Menu: Chosen menu in Home Dark', 'acens' ),
      'services' =>  esc_html__( 'Services Menu: Chosen menu Sidebar Services', 'acens' ),
      'services_dark' =>  esc_html__( 'Services Menu Dark: Chosen menu Sidebar Services Dark', 'acens' ),
      'onepage' =>  esc_html__( 'Onepage Menu: Chosen menu Home Onepage', 'acens' ),
  	) );
      // This theme uses its own gallery styles.
}
add_action( 'after_setup_theme', 'acens_theme_setup' );
if ( ! isset( $content_width ) ) $content_width = 900;
function acens_theme_scripts_styles() {
  	$acens_redux_demo = get_option('redux_demo');
  	$protocol = is_ssl() ? 'https' : 'http';
    wp_enqueue_style('bootstrap', get_template_directory_uri().'/css/plugins/bootstrap.min.css');
    wp_enqueue_style('owl-carousel', get_template_directory_uri().'/css/plugins/owl.carousel.min.css');
    wp_enqueue_style('owl-theme-default', get_template_directory_uri().'/css/plugins/owl.theme.default.min.css');
    wp_enqueue_style('animate', get_template_directory_uri().'/css/plugins/animate.min.css');
    wp_enqueue_style('font-awesome-pro', get_template_directory_uri().'/css/plugins/font-awesome-pro.css');
    wp_enqueue_style('et-lineicons', get_template_directory_uri().'/css/plugins/et-lineicons.css');
    wp_enqueue_style('magnific-popup', get_template_directory_uri().'/css/plugins/magnific-popup.css');
    wp_enqueue_style('youtubepopup', get_template_directory_uri().'/css/plugins/YouTubePopUp.css');
    wp_enqueue_style('vegas-slider', get_template_directory_uri().'/css/plugins/vegas.slider.min.css');
    wp_enqueue_style('acens-style-dark', get_template_directory_uri().'/css/style-dark.css');
    wp_enqueue_style('acens-style', get_template_directory_uri().'/css/style.css');
    wp_enqueue_style('acens-css', get_stylesheet_uri(), array(), '2024-02-18' );
    if(isset($acens_redux_demo['chosen-color']) && $acens_redux_demo['chosen-color']==1){
    wp_enqueue_style( 'color', get_template_directory_uri().'/framework/color.php');
    }

  	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) )
    wp_enqueue_script( 'comment-reply' );
    //Javascript
    wp_enqueue_script('modernizr', get_template_directory_uri().'/js/modernizr-2.6.2.min.js',array(),false,true);
    wp_enqueue_script('imagesloaded-pkgd', get_template_directory_uri().'/js/imagesloaded.pkgd.min.js',array(),false,true);
    wp_enqueue_script('jquery-isotope', get_template_directory_uri().'/js/jquery.isotope.v3.0.2.js',array(),false,true);
    wp_enqueue_script('popper', get_template_directory_uri().'/js/popper.min.js',array(),false,true);
    wp_enqueue_script('bootstrap', get_template_directory_uri().'/js/bootstrap.min.js',array(),false,true);
    wp_enqueue_script('scrollit', get_template_directory_uri().'/js/scrollIt.min.js',array(),false,true);
    wp_enqueue_script('jquery-waypoints', get_template_directory_uri().'/js/jquery.waypoints.min.js',array(),false,true);
    wp_enqueue_script('owl-carousel', get_template_directory_uri().'/js/owl.carousel.min.js',array(),false,true);
    wp_enqueue_script('jquery-stellar', get_template_directory_uri().'/js/jquery.stellar.min.js',array(),false,true);
    wp_enqueue_script('jquery-magnific-popup', get_template_directory_uri().'/js/jquery.magnific-popup.js',array(),false,true);
    wp_enqueue_script('youtubepopup', get_template_directory_uri().'/js/YouTubePopUp.js',array(),false,true);
    wp_enqueue_script('jquery-easing', get_template_directory_uri().'/js/jquery.easing.1.3.js',array(),false,true);
    wp_enqueue_script('smooth-scroll', get_template_directory_uri().'/js/smooth-scroll.min.js',array(),false,true);
    wp_enqueue_script('wow', get_template_directory_uri().'/js/wow.js',array(),false,true);
    wp_enqueue_script('vegas-slider', get_template_directory_uri().'/js/vegas.slider.min.js',array(),false,true);
    wp_enqueue_script('acens-custom', get_template_directory_uri().'/js/custom.js',array(),false,true);
}
add_action( 'wp_enqueue_scripts', 'acens_theme_scripts_styles' );
    function acens_move_comment_field_to_bottom( $fields ) {
    $comment_field = $fields['comment'];
    unset( $fields['comment'] );
    $fields['comment'] = $comment_field;
    return $fields;
}
add_filter( 'comment_form_fields', 'acens_move_comment_field_to_bottom' );
//Custom Excerpt Function
function acens_do_shortcode($content) {
    global $shortcode_tags;
    if (empty($shortcode_tags) || !is_array($shortcode_tags))
        return $content;
    $pattern = get_shortcode_regex();
    return preg_replace_callback( "/$pattern/s", 'do_shortcode_tag', $content );
} 
// Widget Sidebar
function acens_widgets_init() {
  	register_sidebar( array(
      'name'          => esc_html__( 'Primary Sidebar', 'acens' ),
      'id'            => 'sidebar-1',        
  		'description'   => esc_html__( 'Appears in the sidebar section of the site.', 'acens' ),        
  		'before_widget' => '<div class="col-md-12"><div class="widget item %2$s " id="%1$s">',        
  		'after_widget'  => '</div></div>',        
  		'before_title'  => '<div class="text"> <h5>',        
  		'after_title'   => '</h5></div>'
    ) );
    register_sidebar( array(
      'name'          => esc_html__( 'Footer One Widget light', 'acens' ),
      'id'            => 'footer-area-1',
      'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'acens' ),
      'before_widget' => '',
      'after_widget'  => '',
      'before_title'  => ' ',
      'after_title'   => ' ',
    ) );
    register_sidebar( array(
      'name'          => esc_html__( 'Footer Two Widget light', 'acens' ),
      'id'            => 'footer-area-2',
      'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'acens' ),
      'before_widget' => '<div id="%1$s">',
      'after_widget'  => '</div>',
      'before_title'  => ' ',
      'after_title'   => ' ',
    ) );
    register_sidebar( array(
      'name'          => esc_html__( 'Footer Three Widget light', 'acens' ),
      'id'            => 'footer-area-3',
      'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'acens' ),
      'before_widget' => '<div id="%1$s">',
      'after_widget'  => '</div>',
      'before_title'  => ' ',
      'after_title'   => ' ',
    ) );
    register_sidebar( array(
      'name'          => esc_html__( 'Footer Four Widget light', 'acens' ),
      'id'            => 'footer-area-4',
      'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'acens' ),
      'before_widget' => '<div id="%1$s">',
      'after_widget'  => '</div>',
      'before_title'  => ' ',
      'after_title'   => ' ',
    ) );
    register_sidebar( array(
      'name'          => esc_html__( 'Footer Five Widget light', 'acens' ),
      'id'            => 'footer-area-5',
      'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'acens' ),
      'before_widget' => '<div id="%1$s">',
      'after_widget'  => '</div>',
      'before_title'  => ' ',
      'after_title'   => ' ',
    ) );
    register_sidebar( array(
      'name'          => esc_html__( 'Footer One Widget Dark', 'acens' ),
      'id'            => 'footer-area-1-dark',
      'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'acens' ),
      'before_widget' => '',
      'after_widget'  => '',
      'before_title'  => ' ',
      'after_title'   => ' ',
    ) );
    register_sidebar( array(
      'name'          => esc_html__( 'Footer Two Widget Dark', 'acens' ),
      'id'            => 'footer-area-2-dark',
      'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'acens' ),
      'before_widget' => '<div id="%1$s">',
      'after_widget'  => '</div>',
      'before_title'  => ' ',
      'after_title'   => ' ',
    ) );
    register_sidebar( array(
      'name'          => esc_html__( 'Footer Three Widget Dark', 'acens' ),
      'id'            => 'footer-area-3-dark',
      'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'acens' ),
      'before_widget' => '<div id="%1$s">',
      'after_widget'  => '</div>',
      'before_title'  => ' ',
      'after_title'   => ' ',
    ) );
    register_sidebar( array(
      'name'          => esc_html__( 'Footer Four Widget Dark', 'acens' ),
      'id'            => 'footer-area-4-dark',
      'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'acens' ),
      'before_widget' => '<div id="%1$s">',
      'after_widget'  => '</div>',
      'before_title'  => ' ',
      'after_title'   => ' ',
    ) );
    register_sidebar( array(
      'name'          => esc_html__( 'Footer Five Widget Dark', 'acens' ),
      'id'            => 'footer-area-5-dark',
      'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'acens' ),
      'before_widget' => '<div id="%1$s">',
      'after_widget'  => '</div>',
      'before_title'  => ' ',
      'after_title'   => ' ',
    ) );
}
add_action( 'widgets_init', 'acens_widgets_init' );

function acens_override_mce_options($initArray) {
    $opts = '*[*]';
    $initArray['valid_elements'] = $opts;
    $initArray['extended_valid_elements'] = $opts;
    return $initArray;
} 
add_filter('tiny_mce_before_init', 'acens_override_mce_options');
//function tag widgets
function acens_tag_cloud_widget($args) {
  	$args['number'] = 0; //adding a 0 will display all tags
  	$args['largest'] = 18; //largest tag
  	$args['smallest'] = 11; //smallest tag
  	$args['unit'] = 'px'; //tag font unit
  	$args['format'] = 'list'; //ul with a class of wp-tag-cloud
  	$args['exclude'] = array(20, 80, 92); //exclude tags by ID
  	return $args;
}
add_filter( 'widget_tag_cloud_args', 'acens_tag_cloud_widget' );
function acens_excerpt() {
  $acens_redux_demo = get_option('redux_demo');
  if(isset($acens_redux_demo['blog_excerpt'])){
    $limit = $acens_redux_demo['blog_excerpt'];
  }else{
    $limit = 50;
  }
  $excerpt = explode(' ', get_the_excerpt(), $limit);
  if (count($excerpt)>=$limit) {
    array_pop($excerpt);
    $excerpt = implode(" ",$excerpt).'...';
  } else {
    $excerpt = implode(" ",$excerpt);
  }
  $excerpt = preg_replace('`[[^]]*]`','',$excerpt);
  return $excerpt;
}
function acens_excerpt2() {
  $acens_redux_demo = get_option('redux_demo');
  if(isset($acens_redux_demo['services_excerpt'])){
    $limit = $acens_redux_demo['services_excerpt'];
  }else{
    $limit = 18;
  }
  $excerpt = explode(' ', get_the_excerpt(), $limit);
  if (count($excerpt)>=$limit) {
    array_pop($excerpt);
    $excerpt = implode(" ",$excerpt).'...';
  } else {
    $excerpt = implode(" ",$excerpt);
  }
  $excerpt = preg_replace('`[[^]]*]`','',$excerpt);
  return $excerpt;
}
function acens_search_form( $form ) {
    $form = '
        <form action="' . esc_url(home_url('/')) . '">
            <input type="text" class="s-input-home" name="s" required value="' . get_search_query() . '" placeholder="'.esc_attr__('Search…', 'acens').'">
            <button type="submit"><i class="fa-regular fa-magnifying-glass" aria-hidden="true"></i></button>
        </form>
	';
    return $form;
}
add_filter( 'get_search_form', 'acens_search_form' );

function acens_theme_comment($comment, $args, $depth) {
    //echo 's';
   $GLOBALS['comment'] = $comment; ?>
    <?php if(get_avatar($comment,$size='100' )!=''){?>
          <div class="wrap comment_demo">
              <div class="img img-grayscale"> <?php echo get_avatar($comment,$size='72' ); ?> </div>
              <div class="text">
                  <h5><?php printf( get_comment_author_link()) ?><span><?php comment_time(get_option( 'date_format' ));?></span></h5>
                  <?php comment_text() ?> 
                  <?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
              </div>
          </div>
  <?php }else{?>
          <div class="wrap comment_demo no-avatar">
              <div class="text">
                  <h5><?php printf( get_comment_author_link()) ?><span><?php comment_time(get_option( 'date_format' ));?></span></h5>
                  <?php comment_text() ?> 
                  <?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
              </div>
          </div>
<?php }?>

<?php
}

function acens_theme_comment2($comment, $args, $depth) {
    //echo 's';
   $GLOBALS['comment'] = $comment; ?>
    <?php if(get_avatar($comment,$size='100' )!=''){?>
          <div class="wrap">
              <div class="img img-grayscale"><?php echo get_avatar($comment,$size='72' ); ?></div>
              <div class="text">
                  <h5><?php printf( get_comment_author_link()) ?><span><?php comment_time(get_option( 'date_format' ));?></span></h5>
                  <?php comment_text() ?> 
                  <?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
              </div>
          </div>
  <?php }else{?>
          <div class="wrap no-avatar">
              <div class="text">
                  <h5><?php printf( get_comment_author_link()) ?><span><?php comment_time(get_option( 'date_format' ));?></span></h5>
                  <?php comment_text() ?> 
                  <?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
              </div>
          </div>
<?php }?>

<?php
}

/**
 * This file represents an example of the code that themes would use to register
 * the required plugins.
 *
 * It is expected that theme authors would copy and paste this code into their
 * functions.php file, and amend to suit.
 *
 * @package    TGM-Plugin-Activation
 * @subpackage Example
 * @version    2.6.1
 * @author     Thomas Griffin <thomasgriffinmedia.com>
 * @author     Gary Jones <gamajo.com>
 * @copyright  Copyright (c) 2014, Thomas Griffin
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       https://github.com/thomasgriffin/TGM-Plugin-Activation
 */
/**
 * Include the TGM_Plugin_Activation class.
 */
require_once get_template_directory() . '/framework/class-tgm-plugin-activation.php';
add_action( 'tgmpa_register', 'acens_theme_register_required_plugins' );
/**
 * Register the required plugins for this theme.
 *
 * In this example, we register two plugins - one included with the TGMPA library
 * and one from the .org repo.
 *
 * The variable passed to tgmpa_register_plugins() should be an array of plugin
 * arrays.
 *
 * This function is hooked into tgmpa_init, which is fired within the
 * TGM_Plugin_Activation class constructor.
 */
 
 
function acens_theme_register_required_plugins() {
    /**
     * Array of plugin arrays. Required keys are name and slug.
     * If the source is NOT from the .org repo, then source is also required.
     */
    $plugins = array(
        // This is an example of how to include a plugin from the WordPress Plugin Repository.
      array(
            'name'      => esc_html__( 'One Click Demo Import', 'acens' ),
            'slug'      => 'one-click-demo-import',
            'required'  => true,
        ), 
      array(
            'name'      => esc_html__( 'Classic Editor', 'acens' ),
            'slug'      => 'classic-editor',
            'required'  => true,
        ),
      array(
            'name'      => esc_html__( 'Elementor', 'acens' ),
            'slug'      => 'elementor',
            'required'  => true,
        ),  
      array(
            'name'      => esc_html__( 'Classic Widgets', 'acens' ),
            'slug'      => 'classic-widgets',
            'required'  => true,
        ),
      array(
            'name'      => esc_html__( 'Widget Importer & Exporter', 'acens' ),
            'slug'      => 'widget-importer-&-exporter',
            'required'  => true,
        ), 
      array(
            'name'      => esc_html__( 'Contact Form 7', 'acens' ),
            'slug'      => 'contact-form-7',
            'required'  => true,
        ), 
      array(
            'name'      => esc_html__( 'SVG Support', 'acens' ),
            'slug'      => 'svg-support',
            'required'  => true,
        ), 
      array(
            'name'      => esc_html__( 'WP Maximum Execution Time Exceeded', 'acens' ),
            'slug'      => 'wp-maximum-execution-time-exceeded',
            'required'  => true,
        ),
      array(
            'name'                     => esc_html__( 'Acens Common', 'acens' ),
            'slug'                     => 'acens-common',
            'required'                 => true,
            'source'                   => get_template_directory() . '/framework/plugins/acens-common.zip',
        ),
      array(
            'name'                     => esc_html__( 'Acens Elementor', 'acens' ),
            'slug'                     => 'acens-elementor',
            'required'                 => true,
            'source'                   => get_template_directory() . '/framework/plugins/acens-elementor.zip',
        ),
    );
    /**
     * Array of configuration settings. Amend each line as needed.
     * If you want the default strings to be available under your own theme domain,
     * leave the strings uncommented.
     * Some of the strings are added into a sprintf, so see the comments at the
     * end of each line for what each argument will be.
     */
    $config = array(
        'default_path' => '',                      // Default absolute path to pre-packaged plugins.
        'menu'         => 'tgmpa-install-plugins', // Menu slug.
        'has_notices'  => true,                    // Show admin notices or not.
        'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
        'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
        'is_automatic' => false,                   // Automatically activate plugins after installation or not.
        'message'      => '',                      // Message to output right before the plugins table.
        'strings'      => array(
            'page_title'                      => esc_html__( 'Install Required Plugins', 'acens' ),
            'menu_title'                      => esc_html__( 'Install Plugins', 'acens' ),
            'installing'                      => esc_html__( 'Installing Plugin: %s', 'acens' ), // %s = plugin name.
            'oops'                            => esc_html__( 'Something went wrong with the plugin API.', 'acens' ),
            'notice_can_install_required'     => _n_noop( 'This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.', 'acens' ), // %1$s = plugin name(s).
            'notice_can_install_recommended'  => _n_noop( 'This theme recommends the following plugin: %1$s.', 'This theme recommends the following plugins: %1$s.', 'acens' ), // %1$s = plugin name(s).
            'notice_cannot_install'           => _n_noop( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.', 'acens' ), // %1$s = plugin name(s).
            'notice_can_activate_required'    => _n_noop( 'The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.', 'acens' ), // %1$s = plugin name(s).
            'notice_can_activate_recommended' => _n_noop( 'The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.', 'acens' ), // %1$s = plugin name(s).
            'notice_cannot_activate'          => _n_noop( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.', 'acens' ), // %1$s = plugin name(s).
            'notice_ask_to_update'            => _n_noop( 'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.', 'acens' ), // %1$s = plugin name(s).
            'notice_cannot_update'            => _n_noop( 'Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.', 'acens' ), // %1$s = plugin name(s).
            'install_link'                    => _n_noop( 'Begin installing plugin', 'Begin installing plugins', 'acens' ),
            'activate_link'                   => _n_noop( 'Begin activating plugin', 'Begin activating plugins', 'acens' ),
            'return'                          => esc_html__( 'Return to Required Plugins Installer', 'acens' ),
            'plugin_activated'                => esc_html__( 'Plugin activated successfully.', 'acens' ),
            'complete'                        => esc_html__( 'All plugins installed and activated successfully. %s', 'acens' ), // %s = dashboard link.
            'nag_type'                        => 'updated' // Determines admin notice type - can only be 'updated', 'update-nag' or 'error'.
        )
    );
    tgmpa( $plugins, $config );
}
?>