<!doctype html>
<html <?php language_attributes(); ?>>
<?php $acens_redux_demo = get_option('redux_demo'); ?>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php if ( ! function_exists( 'has_site_icon' ) || ! has_site_icon() ) { ?>
        <?php if(isset($acens_redux_demo['favicon']['url'])){?>
        <link rel="shortcut icon" href="<?php echo esc_url($acens_redux_demo['favicon']['url']); ?>">
        <?php }?>
    <?php }?>
    <?php wp_head(); ?> 
</head>
<body <?php body_class(' dark '); ?>>
<?php
    wp_body_open();
?>
<div class="preloader-bg"></div>
<div id="preloader">
    <div id="preloader-status">
        <div class="preloader-position loader"> <span></span> </div>
    </div>
</div>
<!-- Progress scroll totop -->
<div class="progress-wrap cursor-pointer">
    <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
        <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" />
    </svg>
</div>
<!-- Navbar -->
<nav class="navbar navbar-expand-lg">
    <div class="container">
        <!-- Logo -->
        <?php if(isset($acens_redux_demo['logo']['url']) && $acens_redux_demo['logo']['url'] != ''){?>
        <div class="logo-wrapper logo-default">
            <a class="logo" href="<?php echo esc_url(home_url('/')); ?>"> <img src="<?php echo esc_url($acens_redux_demo['logo']['url']); ?>" class="logo-img" alt=""> </a>
        </div>
        <?php }else{ ?>
        <div class="logo-wrapper logo-default">
            <a class="logo" href="<?php echo esc_url(home_url('/')); ?>"> <img src="<?php echo get_template_directory_uri();?>/images/logo-light.png" class="logo-img" alt=""> </a>
        </div>
        <?php } ?> 
    
    <?php if(isset($acens_redux_demo['logo_dark']['url']) && $acens_redux_demo['logo_dark']['url'] != ''){?>
        <div class="logo-wrapper logo-sticky">
            <a class="logo" href="<?php echo esc_url(home_url('/')); ?>"> <img src="<?php echo esc_url($acens_redux_demo['logo_dark']['url']); ?>" class="logo-img" alt=""> </a>
        </div>
        <?php }else{ ?>
        <div class="logo-wrapper logo-sticky">
            <a class="logo" href="<?php echo esc_url(home_url('/')); ?>"> <img src="<?php echo get_template_directory_uri();?>/images/logo-dark.png" class="logo-img" alt=""> </a>
        </div>
        <?php } ?> 
        <!-- Button -->
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbar" aria-controls="navbar" aria-expanded="false"> <span class="navbar-toggler-icon"><i class="fa-regular fa-bars"></i></span> </button>
        <!-- Menu -->
        <div class="collapse scroll-init navbar-collapse" id="navbar">
            <ul class="navbar-nav ms-auto">
                <?php 
              wp_nav_menu( 
                  array( 
                      'theme_location' => 'onepage',
                      'container' => '',
                      'menu_class' => '', 
                      'menu_id' => '',
                      'menu'            => '',
                      'container_class' => '',
                      'container_id'    => '',
                      'echo'            => true,
                      'fallback_cb'       => 'wp_bootstrap_navwalker::fallback',
                      'walker'            => new acens_wp_bootstrap_navwalker2(),
                      'before'          => '',
                      'after'           => '',
                      'link_before'     => '',
                      'link_after'      => '',
                      'items_wrap'      => '<ul class="navbar-nav ms-auto %2$s" >%3$s</ul>',
                      'depth'           => 0,        
                  )
              ); ?>
            </ul>
            <!-- Call -->
            <div class="navbar-right">
                <div class="wrap">
                    <?php if(isset($acens_redux_demo['icon_phone']) && $acens_redux_demo['icon_phone'] != ''){?>
                    <div class="icon"> <i class="<?php echo esc_attr($acens_redux_demo['icon_phone']);?>"></i> </div>
                    <?php }else{ ?>
                    <div class="icon"> <i class="fa-solid fa-phone"></i> </div>
                    <?php } ?>  
                    <div class="text">
                        <?php if(isset($acens_redux_demo['title_phone']) && $acens_redux_demo['title_phone'] != ''){?>
                        <p><?php echo esc_attr($acens_redux_demo['title_phone']);?></p>
                        <?php }else{ ?>
                        <p><?php echo esc_html__( 'Call Us Today', 'acens' ); ?></p>
                        <?php } ?>
                        <?php if(isset($acens_redux_demo['phone_header']) && $acens_redux_demo['phone_header'] != ''){?>
                        <h5><a href="tel:<?php echo esc_attr($acens_redux_demo['phone_header']);?>">
                        <?php echo esc_attr($acens_redux_demo['phone_header']);?></a></h5>
                        <?php }else{ ?>
                        <h5><a href="tel:<?php echo esc_html__( '800 123 4567', 'acens' ); ?>">
                        <?php echo esc_html__( '800 123 4567', 'acens' ); ?></a></h5>
                        <?php } ?>  
                    </div>
                </div>
            </div>
        </div>
    </div>
</nav>