<?php
     $acens_redux_demo = get_option('redux_demo');
     get_header(); 
?>

<?php if(isset($acens_redux_demo['blog_image']['url']) && $acens_redux_demo['blog_image']['url'] != ''){?>
<section class="banner-header section-padding bg-img bg-fixed" data-overlay-dark="5" data-background="<?php echo esc_url($acens_redux_demo['blog_image']['url']); ?>">
<?php }else{ ?>
<section class="banner-header section-padding bg-img bg-fixed" data-overlay-dark="10">
<?php } ?>
    <div class="v-middle">
        <div class="container">
            <div class="row">
                <div class="col-md-12 text-center mt-60">
                    <h1><?php if(isset($acens_redux_demo['blog_title'])){?>
                    <?php echo esc_attr($acens_redux_demo['blog_title']);?>
                    <?php }else{?>
                    <?php echo esc_html__( 'Blog', 'acens' ); } ?></h1>
                    <ul class="breadcrumbs">
                        <li><a href="<?php echo esc_url(home_url('/')); ?>"><?php if(isset($acens_redux_demo['home'])){?>
                    <?php echo esc_attr($acens_redux_demo['home']);?>
                    <?php }else{?>
                    <?php echo esc_html__( 'Home', 'acens' ); } ?></a></li>
                        <li><?php if(isset($acens_redux_demo['blog_title'])){?>
                    <?php echo esc_attr($acens_redux_demo['blog_title']);?>
                    <?php }else{?>
                    <?php echo esc_html__( 'Blog', 'acens' ); } ?></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- divider line -->
<div class="line-vr-section"></div>
<!-- Blog -->
<section class="blog section-padding">
    <div class="container">
        <div class="row">
            <!-- blog content -->
            <?php if ( is_active_sidebar( 'sidebar-1' ) ){?>
            <div class="col-lg-8 col-md-12">
            <?php }else{?>
            <div class="col-lg-12 col-md-12">
            <?php } ?>
                <?php
                    while (have_posts()): the_post();
                ?> 
                <div class="row">
                    <div class="col-md-12">
                        <div class="item">
                            <?php if (wp_get_attachment_url(get_post_thumbnail_id()) !='')  { ?>
                            <div class="img img-grayscale">
                                <a href="<?php the_permalink();?>"> <img src="<?php echo wp_get_attachment_url(get_post_thumbnail_id());?>" alt="<?php the_title_attribute(); ?>"> </a>
                                <div class="date">
                                    <a href="<?php the_permalink();?>"> <span><?php the_time('F'); ?></span> <i><?php the_time('j'); ?></i> </a>
                                </div>
                            </div>
                            <?php } ?>
                            <div class="wrap">
                                <div class="category">
                                    <?php echo  get_the_category_list();?><div class="divider"></div><?php the_time(get_option( 'date_format'));?>
                                </div>
                                <?php if ( is_sticky() ) echo '<span class="featured-post">' . esc_html__( 'Sticky', 'acens' ) . '</span>';?>
                                <h4><a href="<?php the_permalink();?>"><?php the_title(); ?></a></h4>
                                <p><?php if(isset($acens_redux_demo['blog_excerpt'])){?>
                                    <?php echo esc_attr(acens_excerpt($acens_redux_demo['blog_excerpt'])); ?>
                                    <?php }else{?>
                                    <?php echo esc_attr(acens_excerpt(50)); } ?></p>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endwhile; ?>
                <div class="row mb-60">
                    <!-- pagination -->
                    <div class="col-md-12">
                        <?php 
                            $pagination = array(
                            'base'      => str_replace( 999999999, '%#%', get_pagenum_link( 999999999 ) ),
                            'format'    => '',
                            'prev_text' => wp_specialchars_decode('<i class="fa-solid fa-caret-left"></i>',ENT_QUOTES),
                            'next_text' => wp_specialchars_decode('<i class="fa-solid fa-caret-right"></i>',ENT_QUOTES),
                            'type'      => 'list',
                            'end_size'    => 3,
                            'mid_size'    => 3
                            );
                            if(paginate_links( $pagination ) != ''){
                                $return =  paginate_links( $pagination );
                                echo str_replace( "<ul class='page-numbers'>", '<ul class="pagination-wrap mb-30 mt-30">', $return );
                            }
                            ?>
                    </div>
                </div>
            </div>
            <!-- blog sidebar -->
            <?php if ( is_active_sidebar( 'sidebar-1' ) ){?>
            <div class="col-lg-4 col-md-12">
                <div class="row blog-sidebar">
                    <?php get_sidebar();?> 
                </div>
            </div>
            <?php } ?>
        </div>
    </div>
</section>
<?php
    get_footer();
?>