<?php
/**
 * @Packge     : Playrex
 * @Version    : 1.0
 * @Author     : Vecurosoft
 * @Author URI : https://www.vecurosoft.com/
 *
 */

    // Block direct access
    if( ! defined( 'ABSPATH' ) ){
        exit();
    }

    if( class_exists( 'ReduxFramework' ) ) {
        $playrexerrortitle   = playrex_opt( 'playrex_fof_error_number' );
        $playrex404title     = playrex_opt( 'playrex_fof_title' );
        $playrex404subtitle  = playrex_opt( 'playrex_fof_subtitle' );
        $playrex404btntext   = playrex_opt( 'playrex_fof_btn_text' );
        $playrex404placehol  = playrex_opt( 'playrex_fof_placeholder_text' );
    } else {
        $playrexerrortitle   = __( '404', 'Papara SuperMassive Gamer Hub' );
        $playrex404title     = __( 'OOOPS, PAGE NOT FOUND', 'Papara SuperMassive Gamer Hub' );
        $playrex404subtitle  = __( 'We Can\'t Seem to find the page you\'re looking for.', 'Papara SuperMassive Gamer Hub' );
        $playrex404btntext   = __( 'Return To Home', 'playrex' );
        $playrex404placehol  = __( 'Enter Your Keyword....', 'playrex' );
    }


    // get header
    get_header();

    $allowhtml = array(
        'p'         => array(
            'class'     => array()
        ),
        'span'      => array(
            'class'     => array(),
        ),
        'a'         => array(
            'href'      => array(),
            'title'     => array()
        ),
        'br'        => array(),
        'em'        => array(),
        'strong'    => array(),
        'b'         => array(),
        'sup'       => array(),
        'sub'       => array(),
    );

    echo '<section class="vs-error-wrapper space-top space-extra-bottom">';
        echo '<div class="container">';
            echo '<div class="error-content text-center">';
                if( ! empty( $playrexerrortitle ) ){
                    echo '<h2 class="error-number">'.wp_kses( $playrexerrortitle, $allowhtml ).'</h2>';
                }
                if( ! empty( $playrex404title ) ){
                    echo '<h3 class="error-title">'.esc_html( $playrex404title ).'</h3>';
                }
                if( ! empty( $playrex404subtitle ) ){
                    echo '<p class="error-text">'.esc_html( $playrex404subtitle ).'</p>';
                }
                
                if( ! empty( $playrex404btntext ) ){
                    echo '<a href="'.esc_url( home_url('/') ).'" class="vs-btn"><i class="fas fa-home ms-0 me-2"></i>'.esc_html( $playrex404btntext ).'</a>';
                }
            echo '</div>';
        echo '</div>';
    echo '</section>';

    //footer
    get_footer();