<?php
// Block direct access
if( !defined( 'ABSPATH' ) ){
    exit();
}
/**
 * @Packge     : Playrex
 * @Version    : 1.0
 * @Author     : Vecurosoft
 * @Author URI : https://www.vecurosoft.com/
 *
 */

// enqueue css
function playrex_common_custom_css(){
	wp_enqueue_style( 'playrex-color-schemes', get_template_directory_uri().'/assets/css/color.schemes.css' );

    $CustomCssOpt  = playrex_opt( 'playrex_css_editor' );
	if( $CustomCssOpt ){
		$CustomCssOpt = $CustomCssOpt;
	}else{
		$CustomCssOpt = '';
	}

    $customcss = "";

    if( get_header_image() ){
        $playrex_header_bg =  get_header_image();
    }else{
        if( playrex_meta( 'page_breadcrumb_settings' ) == 'page' && is_page() ){
            if( ! empty( playrex_meta( 'breadcumb_image' ) ) ){
                $playrex_header_bg = playrex_meta( 'breadcumb_image' );
            }
        }
    }

    if( !empty( $playrex_header_bg ) ){
        $customcss .= ".breadcumb-wrapper{
            background-image:url('{$playrex_header_bg}')!important;
        }";
    }

	// theme color
	$playrexthemecolor = playrex_opt('playrex_theme_color');
	$playrexsecondcolor = playrex_opt('playrex_secondary_color');
	$preloadercolor    = playrex_opt('playrex_preloader_color');
	$preloadercolortwo = playrex_opt('playrex_preloader_color_two');

	if( !empty( $playrexthemecolor ) ) {
		$customcss .= ":root {
		  --theme-color: {$playrexthemecolor};
		}";
	}

	if( !empty( $playrexsecondcolor ) ) {
		$customcss .= ":root {
			--vs-secondary-color: {$playrexsecondcolor};
		}";
	}

	if( !empty( $preloadercolor ) ) {
		$customcss .= ".loader {
            --theme-color: {$preloadercolor};
		}";
	}

	if( !empty( $preloadercolortwo ) ) {
		$customcss .= ".loader {
            --title-color: {$preloadercolortwo};
		}";
	}

	if( !empty( $CustomCssOpt ) ){
		$customcss .= $CustomCssOpt;
	}

    wp_add_inline_style( 'playrex-color-schemes', $customcss );
}
add_action( 'wp_enqueue_scripts', 'playrex_common_custom_css', 100 );