<?php

/**
 * Include and setup custom metaboxes and fields. (make sure you copy this file to outside the CMB2 directory)
 *
 * Be sure to replace all instances of 'yourprefix_' with your project's prefix.
 * http://nacin.com/2010/05/11/in-wordpress-prefix-everything/
 *
 * @category YourThemeOrPlugin
 * @package  Demo_CMB2
 * @license  http://www.opensource.org/licenses/gpl-license.php GPL v2.0 (or later)
 * @link     https://github.com/WebDevStudios/CMB2
 */

 /**
 * Only return default value if we don't have a post ID (in the 'post' query variable)
 *
 * @param  bool  $default On/Off (true/false)
 * @return mixed          Returns true or '', the blank default
 */
function playrex_set_checkbox_default_for_new_post( $default ) {
	return isset( $_GET['post'] ) ? '' : ( $default ? (string) $default : '' );
}

add_action( 'cmb2_admin_init', 'playrex_register_metabox' );

/**
 * Hook in and add a demo metabox. Can only happen on the 'cmb2_admin_init' or 'cmb2_init' hook.
 */

function playrex_register_metabox() {

	$prefix = '_playrex_';

	$prefixpage = '_playrexpage_';
	
	$playrex_team_meta = new_cmb2_box( array(
		'id'            => $prefixpage . 'team_page_control',
		'title'         => esc_html__( 'Team Page Controller', 'playrex' ),
		'object_types'  => array( 'zocker_team' ), // Post type
		'closed'        => true
	) );
	
	$playrex_team_meta->add_field( array(
		'name' => esc_html__( 'Team Player Number', 'playrex' ),
	   	'desc' => esc_html__( 'Write Team Player Number', 'playrex' ),
	   	'id'   => $prefix . 'zocker_team_player',
		'type' => 'text',
    ) );
	
	$playrex_player_meta = new_cmb2_box( array(
		'id'            => $prefixpage . 'player_page_control',
		'title'         => esc_html__( 'Player Page Controller', 'playrex' ),
		'object_types'  => array( 'zocker_player' ), // Post type
		'closed'        => true
	) );
	
	$playrex_player_meta->add_field( array(
		'name' => esc_html__( 'Player Designation', 'playrex' ),
	   	'desc' => esc_html__( 'Write Player Designation', 'playrex' ),
	   	'id'   => $prefix . 'zocker_player_designation',
		'type' => 'text',
    ) );
	
	$player_group_field_id = $playrex_player_meta->add_field( array(
		'id'          => $prefix .'player_social_group',
		'type'        => 'group',
		'description' => __( 'Social Profile', 'playrex' ),
		'options'     => array(
			'group_title'       => __( 'Social Profile {#}', 'playrex' ), // since version 1.1.4, {#} gets replaced by row number
			'add_button'        => __( 'Add Another Social Profile', 'playrex' ),
			'remove_button'     => __( 'Remove Social Profile', 'playrex' ),
			'closed'         => true
		),
	) );

	$playrex_player_meta->add_group_field( $player_group_field_id, array(
		'name'        => __( 'Select Icon', 'playrex' ),
		'id'          => $prefix .'player_social_profile_icon',
		'type'        => 'fontawesome_icon', // This field type
	) );

	$playrex_player_meta->add_group_field( $player_group_field_id, array(
		'desc'       => esc_html__( 'Set social profile link.', 'playrex' ),
		'id'         => $prefix . 'player_social_profile_link',
		'name'       => esc_html__( 'Social Profile link', 'playrex' ),
		'type'       => 'text'
	) );
	
	$playrex_service_meta = new_cmb2_box( array(
		'id'            => $prefixpage . 'service_page_control',
		'title'         => esc_html__( 'Service Page Controller', 'playrex' ),
		'object_types'  => array( 'playrex_service' ), // Post type
		'closed'        => true
	) );
	$playrex_service_meta->add_field( array(
		'name' => esc_html__( 'Write Flaticon Class', 'playrex' ),
	   	'desc' => esc_html__( 'Write Flaticon Class For The Icon', 'playrex' ),
	   	'id'   => $prefix . 'flat_icon_class',
		'type' => 'text',
    ) );

	$playrex_post_meta = new_cmb2_box( array(
		'id'            => $prefixpage . 'blog_post_control',
		'title'         => esc_html__( 'Post Thumb Controller', 'playrex' ),
		'object_types'  => array( 'post' ), // Post type
		'closed'        => true
	) );
	$playrex_post_meta->add_field( array(
		'name' => esc_html__( 'Post Format Video', 'playrex' ),
		'desc' => esc_html__( 'Use This Field When Post Format Video', 'playrex' ),
		'id'   => $prefix . 'post_format_video',
        'type' => 'text_url',
    ) );
	$playrex_post_meta->add_field( array(
		'name' => esc_html__( 'Post Format Audio', 'playrex' ),
		'desc' => esc_html__( 'Use This Field When Post Format Audio', 'playrex' ),
		'id'   => $prefix . 'post_format_audio',
        'type' => 'oembed',
    ) );
	$playrex_post_meta->add_field( array(
		'name' => esc_html__( 'Post Thumbnail For Slider', 'playrex' ),
		'desc' => esc_html__( 'Use This Field When You Want A Slider In Post Thumbnail', 'playrex' ),
		'id'   => $prefix . 'post_format_slider',
        'type' => 'file_list',
    ) );

	$playrex_page_meta = new_cmb2_box( array(
		'id'            => $prefixpage . 'page_meta_section',
		'title'         => esc_html__( 'Page Meta', 'playrex' ),
		'object_types'  => array( 'page' ), // Post type
        'closed'        => true
    ) );

    $playrex_page_meta->add_field( array(
		'name' => esc_html__( 'Page Breadcrumb Area', 'playrex' ),
		'desc' => esc_html__( 'check to display page breadcrumb area.', 'playrex' ),
		'id'   => $prefix . 'page_breadcrumb_area',
        'type' => 'select',
        'default' => '1',
        'options'   => array(
            '1'   => esc_html__('Show','playrex'),
            '2'     => esc_html__('Hide','playrex'),
        )
    ) );


    $playrex_page_meta->add_field( array(
		'name' => esc_html__( 'Page Breadcrumb Settings', 'playrex' ),
		'id'   => $prefix . 'page_breadcrumb_settings',
        'type' => 'select',
        'default'   => 'global',
        'options'   => array(
            'global'   => esc_html__( 'Global Settings', 'playrex' ),
            'page'     => esc_html__( 'Page Settings', 'playrex' ),
        )
	) );

	$playrex_page_meta->add_field( array(
	    'name'    => esc_html__( 'Breadcumb Image', 'playrex' ),
	    'desc'    => esc_html__( 'Upload an image or enter an URL.', 'playrex' ),
	    'id'      => $prefix . 'breadcumb_image',
	    'type'    => 'file',
	    // Optional:
	    'options' => array(
	        'url' => false, // Hide the text input for the url
	    ),
	    'text'    => array(
	        'add_upload_file_text' => __( 'Add File', 'playrex' ) // Change upload button text. Default: "Add or Upload File"
	    ),
	    'preview_size' => 'large', // Image size to use when previewing in the admin.
	) );

    $playrex_page_meta->add_field( array(
		'name' => esc_html__( 'Page Title', 'playrex' ),
		'desc' => esc_html__( 'check to display Page Title.', 'playrex' ),
		'id'   => $prefix . 'page_title',
        'type' => 'select',
        'default' => '1',
        'options'   => array(
            '1'   	=> esc_html__( 'Show','playrex'),
            '2'     => esc_html__( 'Hide','playrex'),
        )
	) );

    $playrex_page_meta->add_field( array(
		'name' => esc_html__( 'Page Title Settings', 'playrex' ),
		'id'   => $prefix . 'page_title_settings',
        'type' => 'select',
        'options'   => array(
            'default'  => esc_html__('Default Title','playrex'),
            'custom'  => esc_html__('Custom Title','playrex'),
        ),
        'default'   => 'default'
    ) );

    $playrex_page_meta->add_field( array(
		'name' => esc_html__( 'Custom Page Title', 'playrex' ),
		'id'   => $prefix . 'custom_page_title',
        'type' => 'text'
    ) );

    $playrex_page_meta->add_field( array(
		'name' => esc_html__( 'Breadcrumb', 'playrex' ),
		'desc' => esc_html__( 'Select Show to display breadcrumb area', 'playrex' ),
		'id'   => $prefix . 'page_breadcrumb_trigger',
        'type' => 'switch_btn',
        'default' => playrex_set_checkbox_default_for_new_post( true ),
    ) );

    $playrex_layout_meta = new_cmb2_box( array(
		'id'            => $prefixpage . 'page_layout_section',
		'title'         => esc_html__( 'Page Layout', 'playrex' ),
        'context' 		=> 'side',
        'priority' 		=> 'high',
        'object_types'  => array( 'page' ), // Post type
        'closed'        => true
	) );

	$playrex_layout_meta->add_field( array(
		'desc'       => esc_html__( 'Set page layout container,container fluid,fullwidth or both. It\'s work only in template builder page.', 'playrex' ),
		'id'         => $prefix . 'custom_page_layout',
		'type'       => 'radio',
        'options' => array(
            '1' => esc_html__( 'Container', 'playrex' ),
            '2' => esc_html__( 'Container Fluid', 'playrex' ),
            '3' => esc_html__( 'Fullwidth', 'playrex' ),
        ),
	) );
	$playrex_theme_meta = new_cmb2_box( array(
		'id'            => $prefixpage . 'theme_select',
		'title'         => esc_html__( 'Set Theme', 'playrex' ),
        'context' 		=> 'side',
        'priority' 		=> 'high',
        'object_types'  => array( 'page' ), // Post type
        'closed'        => true
	) );
	$playrex_theme_meta->add_field( array(
		'desc'       => esc_html__( 'Set page Theme', 'playrex' ),
		'id'         => $prefix . 'dark_light_theme',
		'type'       => 'radio',
        'options' => array(
            '1' => esc_html__( 'Dark', 'playrex' ),
            '2' => esc_html__( 'Light', 'playrex' ),
        ),
		'default'	=> '1'
	) );

	$playrex_product_meta = new_cmb2_box( array(
		'id'            => $prefixpage . 'product_meta_section',
		'title'         => esc_html__( 'Swap Image', 'playrex' ),
		'object_types'  => array( 'product' ), // Post type
		'closed'        => true,
		'context'		=> 'side',
		'priority'		=> 'default'
	) );

	$playrex_product_meta->add_field( array(
		'name' 		=> esc_html__( 'Product Swap Image', 'playrex' ),
		'desc' 		=> esc_html__( 'Set Product Swap Image', 'playrex' ),
		'id'   		=> $prefix.'product_swap_image',
		'type'    	=> 'file',
		// Optional:
		'options' 	=> array(
			'url' 		=> false, // Hide the text input for the url
		),
		'text'    	=> array(
			'add_upload_file_text' => __( 'Add Swap Image', 'playrex' ) // Change upload button text. Default: "Add or Upload File"
		),
	) );
}

add_action( 'cmb2_admin_init', 'playrex_register_taxonomy_metabox' );
/**
 * Hook in and add a metabox to add fields to taxonomy terms
 */
function playrex_register_taxonomy_metabox() {

    $prefix = '_playrex_';
	/**
	 * Metabox to add fields to categories and tags
	 */
	$playrex_term_meta = new_cmb2_box( array(
		'id'               => $prefix.'term_edit',
		'title'            => esc_html__( 'Category Metabox', 'playrex' ),
		'object_types'     => array( 'term' ),
		'taxonomies'       => array( 'category'),
	) );
	$playrex_term_meta->add_field( array(
		'name'     => esc_html__( 'Extra Info', 'playrex' ),
		'id'       => $prefix.'term_extra_info',
		'type'     => 'title',
		'on_front' => false,
	) );
	$playrex_term_meta->add_field( array(
		'name' => esc_html__( 'Category Image', 'playrex' ),
		'desc' => esc_html__( 'Set Category Image', 'playrex' ),
		'id'   => $prefix.'term_avatar',
        'type' => 'file',
        'text'    => array(
			'add_upload_file_text' => esc_html__('Add Image','playrex') // Change upload button text. Default: "Add or Upload File"
		),
	) );
}