<?php

/**
 * @Packge     : Playrex
 * @Version    : 1.0
 * @Author     : Vecurosoft
 * @Author URI : https://www.vecurosoft.com/
 *
 */


// Block direct access
if( ! defined( 'ABSPATH' ) ){
    exit;
}

 // theme option callback
function playrex_opt( $id = null, $url = null ){
    global $playrex_opt;

    if( $id && $url ){

        if( isset( $playrex_opt[$id][$url] ) && $playrex_opt[$id][$url] ){
            return $playrex_opt[$id][$url];
        }
    }else{
        if( isset( $playrex_opt[$id] )  && $playrex_opt[$id] ){
            return $playrex_opt[$id];
        }
    }
}


// theme logo
function playrex_theme_logo() {
    // escaping allow html
    $allowhtml = array(
        'a'    => array(
            'href' => array()
        ),
        'span' => array(),
        'i'    => array(
            'class' => array()
        )
    );
    $siteUrl = home_url('/');
    if( has_custom_logo() ) {
        $custom_logo_id = get_theme_mod( 'custom_logo' );
        $siteLogo = '';
        $siteLogo .= '<a class="logo" href="'.esc_url( $siteUrl ).'">';
        $siteLogo .= playrex_img_tag( array(
            "class" => "img-fluid logo-img",
            "url"   => esc_url( wp_get_attachment_image_url( $custom_logo_id, 'full') )
        ) );
        $siteLogo .= '</a>';

        return $siteLogo;
    } elseif( !playrex_opt('playrex_text_title') && playrex_opt('playrex_site_logo', 'url' )  ){

        $siteLogo = '<img class="img-fluid logo-img" src="'.esc_url( playrex_opt('playrex_site_logo', 'url' ) ).'" alt="'.esc_attr__( 'logo', 'playrex' ).'" />';
        return '<a class="logo" href="'.esc_url( $siteUrl ).'">'.$siteLogo.'</a>';


    }elseif( playrex_opt('playrex_text_title') ){
        return '<h2 class="mb-0"><a class="logo" href="'.esc_url( $siteUrl ).'">'.wp_kses( playrex_opt('playrex_text_title'), $allowhtml ).'</a></h2>';
    }else{
        return '<h2 class="mb-0"><a class="logo" href="'.esc_url( $siteUrl ).'">'.esc_html( get_bloginfo('name') ).'</a></h2>';
    }
}

// Playrex Coming Soon Logo
function playrex_coming_soon_logo() {
    // escaping allow html
    $allowhtml = array(
        'a'    => array(
            'href' => array()
        ),
        'span' => array(),
        'i'    => array(
            'class' => array()
        )
    );
    $siteUrl = home_url('/');
    // site logo
    if( playrex_opt( 'playrex_coming_logo', 'url' )  ){

        $siteLogo = '<img src="'.esc_url( playrex_opt('playrex_coming_logo', 'url' ) ).'" alt="'.esc_attr__( 'logo', 'playrex' ).'" />';

        return '<a class="logo" href="'.esc_url( $siteUrl ).'">'.$siteLogo.'</a>';

    }elseif( playrex_opt('playrex_coming_site_title') ){
        return '<h2 class="mb-0"><a class="text-logo" href="'.esc_url( $siteUrl ).'">'.wp_kses( playrex_opt('playrex_coming_site_title'), $allowhtml ).'</a></h2>';
    }else{
        return '<h2 class="mb-0"><a class="text-logo" href="'.esc_url( $siteUrl ).'">'.esc_html( get_bloginfo('name') ).'</a></h2>';
    }
}

// custom meta id callback
function playrex_meta( $id = '' ){
    $value = get_post_meta( get_the_ID(), '_playrex_'.$id, true );
    return $value;
}


// Blog Date Permalink
function playrex_blog_date_permalink() {
    $year  = get_the_time('Y');
    $month_link = get_the_time('m');
    $day   = get_the_time('d');
    $link = get_day_link( $year, $month_link, $day);
    return $link;
}

//audio format iframe match
function playrex_iframe_match() {
    $audio_content = playrex_embedded_media( array('audio', 'iframe') );
    $iframe_match = preg_match("/\iframe\b/i",$audio_content, $match);
    return $iframe_match;
}


//Post embedded media
function playrex_embedded_media( $type = array() ){
    $content = do_shortcode( apply_filters( 'the_content', get_the_content() ) );
    $embed   = get_media_embedded_in_content( $content, $type );


    if( in_array( 'audio' , $type) ){
        if( count( $embed ) > 0 ){
            $output = str_replace( '?visual=true', '?visual=false', $embed[0] );
        }else{
           $output = '';
        }

    }else{
        if( count( $embed ) > 0 ){
            $output = $embed[0];
        }else{
           $output = '';
        }
    }
    return $output;
}


// WP post link pages
function playrex_link_pages(){
    wp_link_pages( array(
        'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'playrex' ) . '</span>',
        'after'       => '</div>',
        'link_before' => '<span>',
        'link_after'  => '</span>',
        'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'playrex' ) . ' </span>%',
        'separator'   => '<span class="screen-reader-text">, </span>',
    ) );
}


// Data Background image attr
function playrex_data_bg_attr( $imgUrl = '' ){
    return 'data-bg-img="'.esc_url( $imgUrl ).'"';
}

// image alt tag
function playrex_image_alt( $url = '' ){
    if( $url != '' ){
        // attachment id by url
        $attachmentid = attachment_url_to_postid( esc_url( $url ) );
       // attachment alt tag
        $image_alt = get_post_meta( esc_html( $attachmentid ) , '_wp_attachment_image_alt', true );
        if( $image_alt ){
            return $image_alt ;
        }else{
            $filename = pathinfo( esc_url( $url ) );
            $alt = str_replace( '-', ' ', $filename['filename'] );
            return $alt;
        }
    }else{
       return;
    }
}


// Flat Content wysiwyg output with meta key and post id

function playrex_get_textareahtml_output( $content ) {
    global $wp_embed;

    $content = $wp_embed->autoembed( $content );
    $content = $wp_embed->run_shortcode( $content );
    $content = wpautop( $content );
    $content = do_shortcode( $content );

    return $content;
}

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */

function playrex_pingback_header() {
    if ( is_singular() && pings_open() ) {
        echo '<link rel="pingback" href="', esc_url( get_bloginfo( 'pingback_url' ) ), '">';
    }
}
add_action( 'wp_head', 'playrex_pingback_header' );


// Excerpt More
function playrex_excerpt_more( $more ) {
    return '...';
}

add_filter( 'excerpt_more', 'playrex_excerpt_more' );


// playrex comment template callback
function playrex_comment_callback( $comment, $args, $depth ) {
        $add_below = 'comment';
    ?>
    <li <?php comment_class( array('vs-comment') ); ?>>
        <div id="comment-<?php comment_ID() ?>" class="vs-post-comment">
            <?php
                if( get_avatar( $comment, 110 )  ) :
            ?>
            <!-- Author Image -->
            <div class="comment-avater">
                <?php
                    if ( $args['avatar_size'] != 0 ) {
                        echo get_avatar( $comment, 110 );
                    }
                ?>
            </div>
            <!-- Author Image -->
            <?php
                endif;
            ?>
            <!-- Comment Content -->
            <div class="comment-content">
                <h4 class="name h4"><?php echo esc_html( ucwords( get_comment_author() ) ); ?></h4>
                <span class="commented-on"><i class="fal fa-calendar-alt"></i><?php printf( esc_html__('%1$s', 'playrex'), get_comment_date() ); ?> </span>
                
                <?php comment_text(); ?>
                <div class="reply_and_edit">
                    <?php
                        comment_reply_link(array_merge( $args, array( 'add_below' => $add_below, 'depth' => 1, 'max_depth' => 5, 'reply_text' => 'Reply' ) ) );
                    ?>
                    <span class="comment-edit-link pl-10"><?php edit_comment_link( esc_html__( 'Edit', 'playrex' ), '  ', '' ); ?></span>
                </div>

                <?php if ( $comment->comment_approved == '0' ) : ?>
                <p class="comment-awaiting-moderation"><?php esc_html_e( 'Your comment is awaiting moderation.', 'playrex' ); ?></p>
                <?php endif; ?>
            </div>
        </div>
        <!-- Comment Content -->
<?php
}

//body class
add_filter( 'body_class', 'playrex_body_class' );

function playrex_body_class( $classes ) {

    $classes[] = '';

    $playrex_dark_mode          = playrex_meta('dark_light_theme');

    if( $playrex_dark_mode == '1' ){
        $classes[] = 'dark-mode';
    }elseif( $playrex_dark_mode == '2' )  {
        $classes[] = '';
    }else{
        $classes[] = 'dark-mode';
    }

    if( class_exists('ReduxFramework') ) {
        $playrex_blog_single_sidebar = playrex_opt('playrex_blog_single_sidebar');
        if( ($playrex_blog_single_sidebar != '2' && $playrex_blog_single_sidebar != '3' ) || ! is_active_sidebar('playrex-blog-sidebar') ) {
            $classes[] = 'no-sidebar';
        }
        
    } else {
        if( !is_active_sidebar('playrex-blog-sidebar') ) {
            $classes[] = 'no-sidebar';
        }
    }
    return $classes;
}


function playrex_footer_global_option(){

    // Playrex Footer Bottom Enable Disable
    if( class_exists( 'ReduxFramework' ) ){
        $playrex_footer_bottom_active = playrex_opt( 'playrex_disable_footer_bottom' );
    }else{
        $playrex_footer_bottom_active = '1';
    }

    $allowhtml = array(
        'p'         => array(
            'class'     => array()
        ),
        'span'      => array(
            'class'     => array(),
        ),
        'a'         => array(
            'href'      => array(),
            'title'     => array()
        ),
        'br'        => array(),
        'em'        => array(),
        'strong'    => array(),
        'b'         => array(),
    );

    if( $playrex_footer_bottom_active == '1' ){
        echo '<!-- Footer -->';
        echo '<footer class="footer-wrapper footer-layout2">';

            if( $playrex_footer_bottom_active == '1' ){
                $allowhtml = array(
                    'p'         => array(
                        'class'     => array()
                    ),
                    'span'      => array(),
                    'a'         => array(
                        'href'      => array(),
                        'title'     => array(),
                        'class'     => array(),
                    ),
                    'br'        => array(),
                    'em'        => array(),
                    'strong'    => array(),
                    'b'         => array(),
                );
                echo '<div class="copyright-wrap">';
                    echo '<div class="container">';
                        echo '<div class="row align-items-center">';
                            if( ! empty( playrex_opt( 'playrex_copyright_text' ) ) ){
                                echo '<p class="copyright-text">'.wp_kses( playrex_opt( 'playrex_copyright_text' ), $allowhtml ).'</p>';
                            }
                        echo '</div>';
                    echo '</div>';
                echo '</div>';
            }
        echo '</footer>';
        echo '<!-- End Footer -->';
    }
}

function playrex_social_icon(){
    $playrex_social_icon = playrex_opt( 'playrex_social_links' );
    if( ! empty( $playrex_social_icon ) && isset( $playrex_social_icon ) ){
        foreach( $playrex_social_icon as $social_icon ){
            if( ! empty( $social_icon['title'] ) ){
                echo '<a href="'.esc_url( $social_icon['url'] ).'"><i class="'.esc_attr( $social_icon['title'] ).'"></i>'.esc_html( $social_icon['description'] ).'</a>';
            }
        }
    }
}
function playrex_social_icon_two(){
    $playrex_social_icon = playrex_opt( 'playrex_social_links' );
    if( ! empty( $playrex_social_icon ) && isset( $playrex_social_icon ) ){
        foreach( $playrex_social_icon as $social_icon ){
            if( ! empty( $social_icon['title'] ) ){
                echo '<li><a href="'.esc_url( $social_icon['url'] ).'"><i class="'.esc_attr( $social_icon['title'] ).'"></i></a></li>';
            }
        }
    }
}

// global header
function playrex_global_header_option() {
    playrex_global_header();
    
    echo '<div class="popup-search-box">';
        echo '<button class="searchClose">';
            echo '<i class="fal fa-times"></i>';
        echo '</button>';
        echo '<form action="'.esc_url( home_url('/') ).'">';
            echo '<input name="s" type="text" placeholder="'.esc_attr__( 'What are you looking for','playrex' ).'">';
            echo '<button type="submit"><i class="fal fa-search"></i></button>';
        echo '</form>';
    echo '</div>';
    
    echo '<header class="vs-header header-default">';
        echo '<div class="sticky-active">';
            echo '<div class="container position-relative">';
                echo '<div class="row align-items-center justify-content-between">';
                    echo '<div class="col-auto align-self-center">';
                        echo '<div class="header-logo">';
                            echo playrex_theme_logo();
                        echo '</div>';
                    echo '</div>';
                    echo '<div class="col-auto">';
                        if( has_nav_menu( 'primary-menu' ) ){
                            echo '<nav class="main-menu menu-style1 d-none d-lg-block">';
                                wp_nav_menu( array(
                                    "theme_location"    => 'primary-menu',
                                    "container"         => '',
                                    "menu_class"        => ''
                                ) );
                            echo '</nav>';
                        }
                    echo '</div>';
                    echo '<div class="col-auto">';
                        echo '<div class="header-btns">';
                            echo '<button class="icon-btn searchBoxTggler"><i class="far fa-search"></i></button>';
                            echo '<!-- Mobile Menu Toggler -->';
                            if( has_nav_menu( 'primary-menu' ) ){
                                echo '<button class="vs-menu-toggle d-inline-block d-lg-none"><i class="far fa-bars"></i></button>';
                            }
                        echo '</div>';
                    echo '</div>';
                echo '</div>';
            echo '</div>';
        echo '</div>';
        if( ! empty( playrex_opt( 'playrex_notice_text' ) ) ){
            echo '<div class="header-notice d-none d-md-block">';
                echo '<div class="container">';
                    echo '<p class="mb-0 fs-xs text-title">'.esc_html( playrex_opt( 'playrex_notice_text' ) ).'</p>';
                echo '</div>';
            echo '</div>';
        }
    echo '</header>';

}

// Playrex Default Header
if( ! function_exists( 'playrex_global_header' ) ){
    function playrex_global_header(){
        // Mobile Menu
        echo '<div class="vs-menu-wrapper">';
            echo '<div class="vs-menu-area">';
                echo '<button class="vs-menu-toggle"><i class="fal fa-times"></i></button>';
                echo '<div class="mobile-logo">';
                    echo playrex_theme_logo();
                echo '</div>';
                if( has_nav_menu( 'mobile-menu' ) ){
                    echo '<div class="vs-mobile-menu link-inherit">';
                        wp_nav_menu( array(
                            "theme_location"    => 'mobile-menu',
                            "container"         => '',
                            "menu_class"        => ''
                        ) );
                    echo '</div>';
                }
            echo '</div>';
        echo '</div>';
    }
}

// playrex woocommerce breadcrumb
function playrex_woo_breadcrumb( $args ) {
    return array(
        'delimiter'   => '',
        'wrap_before' => '<ul class="breadcumb-menu">',
        'wrap_after'  => '</ul>',
        'before'      => '<li>',
        'after'       => '</li>',
        'home'        => _x( 'Home', 'breadcrumb', 'playrex' ),
    );
}

add_filter( 'woocommerce_breadcrumb_defaults', 'playrex_woo_breadcrumb' );

function playrex_custom_search_form( $class ) {
    echo '<!-- Search Form -->';
    echo '<form role="search" method="get" action="'.esc_url( home_url( '/' ) ).'" class="'.esc_attr( $class ).'">';
        echo '<label class="searchIcon">';
            echo '<input value="'.esc_html( get_search_query() ).'" name="s" required type="search" placeholder="'.esc_attr__('What are you looking for?', 'playrex').'">';
        echo '</label>';
    echo '</form>';
    echo '<!-- End Search Form -->';
}



//Fire the wp_body_open action.
if ( ! function_exists( 'wp_body_open' ) ) {
	function wp_body_open() {
		do_action( 'wp_body_open' );
	}
}

//Remove Tag-Clouds inline style
add_filter( 'wp_generate_tag_cloud', 'playrex_remove_tagcloud_inline_style',10,1 );
function playrex_remove_tagcloud_inline_style( $input ){
   return preg_replace('/ style=("|\')(.*?)("|\')/','',$input );
}

// password protected form
add_filter('the_password_form','playrex_password_form',10,1);
function playrex_password_form( $output ) {
    $output = '<form action="' . esc_url( site_url( 'wp-login.php?action=postpass', 'login_post' ) ) . '" class="post-password-form" method="post"><div class="theme-input-group">
        <input name="post_password" type="password" class="theme-input-style" placeholder="'.esc_attr__( 'Enter Password','playrex' ).'">
        <button type="submit" class="submit-btn btn-fill">'.esc_html__( 'Enter','playrex' ).'</button></div></form>';
    return $output;
}

function playrex_setPostViews( $postID ) {
    $count_key  = 'post_views_count';
    $count      = get_post_meta( $postID, $count_key, true );
    if( $count == '' ){
        $count = 0;
        delete_post_meta( $postID, $count_key );
        add_post_meta( $postID, $count_key, '0' );
    }else{
        $count++;
        update_post_meta( $postID, $count_key, $count );
    }
}

function playrex_getPostViews( $postID ){
    $count_key  = 'post_views_count';
    $count      = get_post_meta( $postID, $count_key, true );
    if( $count == '' ){
        delete_post_meta( $postID, $count_key );
        add_post_meta( $postID, $count_key, '0' );
        return __( '0', 'playrex' );
    }
    return $count;
}


/* This code filters the Categories archive widget to include the post count inside the link */
add_filter( 'wp_list_categories', 'playrex_cat_count_span' );
function playrex_cat_count_span( $links ) {
    $links = str_replace('</a> (', '</a> <span class="category-number">', $links);
    $links = str_replace(')', '</span>', $links);
    return $links;
}

/* This code filters the Archive widget to include the post count inside the link */
add_filter( 'get_archives_link', 'playrex_archive_count_span' );
function playrex_archive_count_span( $links ) {
    $links = str_replace('</a>&nbsp;(', '</a> <span class="category-number">(', $links);
    $links = str_replace(')', ')</span>', $links);
	return $links;
}


if( ! function_exists( 'playrex_blog_category' ) ){
    function playrex_blog_category(){
        if( class_exists( 'ReduxFramework' ) ){
            $playrex_display_post_category =  playrex_opt('playrex_display_post_category');
        }else{
            $playrex_display_post_category = '1';
        }

        if( $playrex_display_post_category ){
            $playrex_post_categories = get_the_category();
            if( is_array( $playrex_post_categories ) && ! empty( $playrex_post_categories ) ){
                if( playrex_opt( 'playrex_blog_style' ) == '2' ){
                    $padding_class = 'mb-20';
                }else{
                    $padding_class = '';
                }
                echo '<div class="blog-category '.esc_attr( $padding_class ).'">';
                    echo ' <a href="'.esc_url( get_term_link( $playrex_post_categories[0]->term_id ) ).'">'.esc_html( $playrex_post_categories[0]->name ).'</a> ';
                echo '</div>';
            }
        }
    }
}

// Add Extra Class On Comment Reply Button
function playrex_custom_comment_reply_link( $content ) {
    $extra_classes = 'replay-btn';
    return preg_replace( '/comment-reply-link/', 'comment-reply-link ' . $extra_classes, $content);
}

add_filter('comment_reply_link', 'playrex_custom_comment_reply_link', 99);

// Add Extra Class On Edit Comment Link
function playrex_custom_edit_comment_link( $content ) {
    $extra_classes = 'replay-btn';
    return preg_replace( '/comment-edit-link/', 'comment-edit-link ' . $extra_classes, $content);
}

add_filter('edit_comment_link', 'playrex_custom_edit_comment_link', 99);


function playrex_post_classes( $classes, $class, $post_id ) {
    if ( get_post_type() === 'post' ) {
        if( ! is_single() ){
            if( playrex_opt( 'playrex_blog_style' ) == '3' ){
                $classes[] = "vs-blog blog-grid grid-wide";
            }else{
                $classes[] = "vs-blog blog-single";
            }
        }else{
            $classes[] = "vs-blog blog-single";
        }
    }elseif( get_post_type() === 'product' ){
        // Return Class
    }elseif( get_post_type() === 'page' ){
        $classes[] = "page--item";
    }

    return $classes;
}
add_filter( 'post_class', 'playrex_post_classes', 10, 3 );