<?php
/**
 * @Packge     : Playrex
 * @Version    : 1.0
 * @Author     : Vecurosoft
 * @Author URI : https://www.vecurosoft.com/
 *
 */


// Block direct access
if( !defined( 'ABSPATH' ) ){
    exit;
}

function playrex_widgets_init() {

    if( class_exists('ReduxFramework') ) {
        $playrex_sidebar_widget_title_heading_tag = playrex_opt('playrex_sidebar_widget_title_heading_tag');
    } else {
        $playrex_sidebar_widget_title_heading_tag = 'h3';
    }

    //sidebar widgets register
    register_sidebar( array(
        'name'          => esc_html__( 'Blog Sidebar', 'playrex' ),
        'id'            => 'playrex-blog-sidebar',
        'description'   => esc_html__( 'Add Blog Sidebar Widgets Here.', 'playrex' ),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<'.esc_attr($playrex_sidebar_widget_title_heading_tag).' class="widgettitle">',
        'after_title'   => '</'.esc_attr($playrex_sidebar_widget_title_heading_tag).'>',
    ) );

    // page sidebar widgets register
    register_sidebar( array(
        'name'          => esc_html__( 'Page Sidebar', 'playrex' ),
        'id'            => 'playrex-page-sidebar',
        'description'   => esc_html__( 'Add Page Sidebar Widgets Here.', 'playrex' ),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widgettitle">',
        'after_title'   => '</h3>',
    ) );
    // page sidebar widgets register
    register_sidebar( array(
        'name'          => esc_html__( 'Offcanvas Sidebar', 'playrex' ),
        'id'            => 'playrex-offcanvas-sidebar',
        'description'   => esc_html__( 'Add Offcanvas Sidebar Widgets Here.', 'playrex' ),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widgettitle">',
        'after_title'   => '</h3>',
    ) );
    register_sidebar( array(
       'name'          => esc_html__( 'Player Details Sidebar', 'zocker' ),
       'id'            => 'playrex-player-sidebar',
       'before_widget' => '<div id="%1$s" class="widget player-widget %2$s">',
       'after_widget'  => '</div>',
       'before_title'  => '<h3 class="sidebox-title-v2 h5">',
       'after_title'   => '</h3>',
    ) );
    register_sidebar( array(
       'name'          => esc_html__( 'Team Details Sidebar', 'zocker' ),
       'id'            => 'playrex-team-sidebar',
       'before_widget' => '<div id="%1$s" class="widget team-widget %2$s">',
       'after_widget'  => '</div>',
       'before_title'  => '<h3 class="sidebox-title-v2 h5">',
       'after_title'   => '</h3>',
    ) );
    if( class_exists('woocommerce') ) {
        register_sidebar(
            array(
                'name'          => esc_html__( 'WooCommerce Sidebar', 'playrex' ),
                'id'            => 'playrex-woo-sidebar',
                'description'   => esc_html__( 'Add widgets here to appear in your woocommerce page sidebar.', 'playrex' ),
                'before_widget' => '<div class="widget %2$s">',
                'after_widget'  => '</div>',
                'before_title'  => '<div class="widgettitle"><h4>',
                'after_title'   => '</h4></div>',
            )
        );
    }

}

add_action( 'widgets_init', 'playrex_widgets_init' );