<?php
/**
 * @Packge     : Playrex
 * @Version    : 1.0
 * @Author     : Vecurosoft
 * @Author URI : https://www.vecurosoft.com/
 *
 */

    // Block direct access
    if( !defined( 'ABSPATH' ) ){
        exit();
    }

    if( defined( 'CMB2_LOADED' )  ){
        if( !empty( playrex_meta('page_breadcrumb_area') ) ) {
            $playrex_page_breadcrumb_area  = playrex_meta('page_breadcrumb_area');
        } else {
            $playrex_page_breadcrumb_area = '1';
        }
    }else{
        $playrex_page_breadcrumb_area = '1';
    }

    $allowhtml = array(
        'p'         => array(
            'class'     => array()
        ),
        'span'      => array(
            'class'     => array(),
        ),
        'a'         => array(
            'href'      => array(),
            'title'     => array()
        ),
        'br'        => array(),
        'em'        => array(),
        'strong'    => array(),
        'b'         => array(),
        'sub'       => array(),
        'sup'       => array(),
    );

    if(  is_page() || is_page_template( 'template-builder.php' )  ) {
        if( $playrex_page_breadcrumb_area == '1' ) {
            echo '<!-- Page title -->';
            echo '<div class="breadcumb-wrapper background-image">';
                echo '<div class="container z-index-common">';
                    echo '<div class="breadcumb-content">';
                        if( defined('CMB2_LOADED') || class_exists('ReduxFramework') ) {
                            if( playrex_meta('page_breadcrumb_settings') == 'page' ) {
                                $playrex_page_title_switcher = playrex_meta('page_title');
                            } elseif( playrex_opt('playrex_page_title_switcher') == true ) {
                                $playrex_page_title_switcher = playrex_opt('playrex_page_title_switcher');
                            }else{
                                $playrex_page_title_switcher = '1';
                            }
                        } else {
                            $playrex_page_title_switcher = '1';
                        }

                        if( $playrex_page_title_switcher == '1' ){
                            if( class_exists( 'ReduxFramework' ) ){
                                $playrex_page_title_tag    = playrex_opt('playrex_page_title_tag');
                            }else{
                                $playrex_page_title_tag    = 'h1';
                            }

                            if( defined( 'CMB2_LOADED' )  ){
                                if( !empty( playrex_meta('page_title_settings') ) ) {
                                    $playrex_custom_title = playrex_meta('page_title_settings');
                                } else {
                                    $playrex_custom_title = 'default';
                                }
                            }else{
                                $playrex_custom_title = 'default';
                            }

                            if( $playrex_custom_title == 'default' ) {
                                echo playrex_heading_tag(
                                    array(
                                        "tag"   => esc_attr( $playrex_page_title_tag ),
                                        "text"  => esc_html( get_the_title( ) ),
                                        'class' => 'breadcumb-title'
                                    )
                                );
                            } else {
                                echo playrex_heading_tag(
                                    array(
                                        "tag"   => esc_attr( $playrex_page_title_tag ),
                                        "text"  => esc_html( playrex_meta('custom_page_title') ),
                                        'class' => 'breadcumb-title'
                                    )
                                );
                            }

                        }
                        if( defined('CMB2_LOADED') || class_exists('ReduxFramework') ) {

                            if( playrex_meta('page_breadcrumb_settings') == 'page' ) {
                                $playrex_breadcrumb_switcher = playrex_meta('page_breadcrumb_trigger');
                            } else {
                                $playrex_breadcrumb_switcher = playrex_opt('playrex_enable_breadcrumb');
                            }

                        } else {
                            $playrex_breadcrumb_switcher = '1';
                        }

                        if( $playrex_breadcrumb_switcher == '1' && (  is_page() || is_page_template( 'template-builder.php' ) )) {
                            playrex_breadcrumbs(
                                array(
                                    'breadcrumbs_classes' => 'nav',
                                )
                            );
                        }
                        echo '</div>';
                echo '</div>';
            echo '</div>';
            echo '<!-- End of Page title -->';
        }
    } else {
        echo '<!-- Page title -->';
        echo '<div class="breadcumb-wrapper breadcumb-layout1">';
            echo '<div class="container z-index-common">';
                echo '<div class="breadcumb-content">';
                    if( class_exists( 'ReduxFramework' )  ){
                        $playrex_page_title_switcher  = playrex_opt('playrex_page_title_switcher');
                    }else{
                        $playrex_page_title_switcher = '1';
                    }

                    if( $playrex_page_title_switcher ){
                        if( class_exists( 'ReduxFramework' ) ){
                            $playrex_page_title_tag    = playrex_opt('playrex_page_title_tag');
                        }else{
                            $playrex_page_title_tag    = 'h1';
                        }
                        if( class_exists('woocommerce') && is_shop() ) {
                            echo playrex_heading_tag(
                                array(
                                    "tag"   => esc_attr( $playrex_page_title_tag ),
                                    "text"  => wp_kses( woocommerce_page_title( false ), $allowhtml ),
                                    'class' => 'breadcumb-title'
                                )
                            );
                        }elseif ( is_archive() ){
                            echo playrex_heading_tag(
                                array(
                                    "tag"   => esc_attr( $playrex_page_title_tag ),
                                    "text"  => wp_kses( get_the_archive_title(), $allowhtml ),
                                    'class' => 'breadcumb-title'
                                )
                            );
                        }elseif ( is_home() ){
                            $playrex_blog_page_title_setting = playrex_opt('playrex_blog_page_title_setting');
                            $playrex_blog_page_title_switcher = playrex_opt('playrex_blog_page_title_switcher');
                            $playrex_blog_page_custom_title = playrex_opt('playrex_blog_page_custom_title');
                            if( class_exists('ReduxFramework') ){
                                if( $playrex_blog_page_title_switcher ){
                                    echo playrex_heading_tag(
                                        array(
                                            "tag"   => esc_attr( $playrex_page_title_tag ),
                                            "text"  => !empty( $playrex_blog_page_custom_title ) && $playrex_blog_page_title_setting == 'custom' ? esc_html( $playrex_blog_page_custom_title) : esc_html__( 'Blog', 'playrex' ),
                                            'class' => 'breadcumb-title'
                                        )
                                    );
                                }
                            }else{
                                echo playrex_heading_tag(
                                    array(
                                        "tag"   => "h1",
                                        "text"  => esc_html__( 'Blog', 'playrex' ),
                                        'class' => 'breadcumb-title',
                                    )
                                );
                            }
                        }elseif( is_search() ){
                            echo playrex_heading_tag(
                                array(
                                    "tag"   => esc_attr( $playrex_page_title_tag ),
                                    "text"  => esc_html__( 'Search Result', 'playrex' ),
                                    'class' => 'breadcumb-title'
                                )
                            );
                        }elseif( is_404() ){
                            echo playrex_heading_tag(
                                array(
                                    "tag"   => esc_attr( $playrex_page_title_tag ),
                                    "text"  => esc_html__( '404 PAGE', 'playrex' ),
                                    'class' => 'breadcumb-title'
                                )
                            );
                        }elseif( is_singular( 'product' ) ){
                            $posttitle_position  = playrex_opt('playrex_product_details_title_position');
                            $postTitlePos = false;
                            if( class_exists( 'ReduxFramework' ) ){
                                if( $posttitle_position && $posttitle_position != 'header' ){
                                    $postTitlePos = true;
                                }
                            }else{
                                $postTitlePos = false;
                            }

                            if( $postTitlePos != true ){
                                echo playrex_heading_tag(
                                    array(
                                        "tag"   => esc_attr( $playrex_page_title_tag ),
                                        "text"  => wp_kses( get_the_title( ), $allowhtml ),
                                        'class' => 'breadcumb-title'
                                    )
                                );
                            } else {
                                if( class_exists( 'ReduxFramework' ) ){
                                    $playrex_post_details_custom_title  = playrex_opt('playrex_product_details_custom_title');
                                }else{
                                    $playrex_post_details_custom_title = __( 'Shop Details','playrex' );
                                }

                                if( !empty( $playrex_post_details_custom_title ) ) {
                                    echo playrex_heading_tag(
                                        array(
                                            "tag"   => esc_attr( $playrex_page_title_tag ),
                                            "text"  => wp_kses( $playrex_post_details_custom_title, $allowhtml ),
                                            'class' => 'breadcumb-title'
                                        )
                                    );
                                }
                            }
                        }else{
                            $posttitle_position  = playrex_opt('playrex_post_details_title_position');
                            $postTitlePos = false;
                            if( is_single( 'post' ) ){
                                if( class_exists( 'ReduxFramework' ) ){
                                    if( $posttitle_position && $posttitle_position != 'header' ){
                                        $postTitlePos = true;
                                    }
                                }else{
                                    $postTitlePos = false;
                                }
                            }
                            if( is_singular( 'product' ) ){
                                $posttitle_position  = playrex_opt('playrex_product_details_title_position');
                                $postTitlePos = false;
                                if( class_exists( 'ReduxFramework' ) ){
                                    if( $posttitle_position && $posttitle_position != 'header' ){
                                        $postTitlePos = true;
                                    }
                                }else{
                                    $postTitlePos = false;
                                }
                            }

                            if( $postTitlePos != true ){
                                echo playrex_heading_tag(
                                    array(
                                        "tag"   => esc_attr( $playrex_page_title_tag ),
                                        "text"  => wp_kses( get_the_title( ), $allowhtml ),
                                        'class' => 'breadcumb-title'
                                    )
                                );
                            } else {
                                if( class_exists( 'ReduxFramework' ) ){
                                    $playrex_post_details_custom_title  = playrex_opt('playrex_post_details_custom_title');
                                }else{
                                    $playrex_post_details_custom_title = __( 'Blog Details','playrex' );
                                }

                                if( !empty( $playrex_post_details_custom_title ) ) {
                                    echo playrex_heading_tag(
                                        array(
                                            "tag"   => esc_attr( $playrex_page_title_tag ),
                                            "text"  => wp_kses( $playrex_post_details_custom_title, $allowhtml ),
                                            'class' => 'breadcumb-title'
                                        )
                                    );
                                }
                            }
                        }
                    }
                    if( class_exists('ReduxFramework') ) {
                        $playrex_breadcrumb_switcher = playrex_opt( 'playrex_enable_breadcrumb' );
                    } else {
                        $playrex_breadcrumb_switcher = '1';
                    }
                    if( $playrex_breadcrumb_switcher == '1' ) {
                        playrex_breadcrumbs(
                            array(
                                'breadcrumbs_classes' => 'nav',
                            )
                        );
                    }
                echo '</div>';
            echo '</div>';
        echo '</div>';
        echo '<!-- End of Page title -->';
    }