<?php
/**
 * @Packge     : Playrex
 * @Version    : 1.0
 * @Author     : Vecurosoft
 * @Author URI : https://www.vecurosoft.com/
 *
 */

    // Block direct access
    if( ! defined( 'ABSPATH' ) ){
        exit();
    }

    if( class_exists( 'ReduxFramework' ) && defined('ELEMENTOR_VERSION') ) {
        if( is_page() || is_page_template('template-builder.php') ) {
            $playrex_post_id = get_the_ID();

            // Get the page settings manager
            $playrex_page_settings_manager = \Elementor\Core\Settings\Manager::get_settings_managers( 'page' );

            // Get the settings model for current post
            $playrex_page_settings_model = $playrex_page_settings_manager->get_model( $playrex_post_id );

            // Retrieve the color we added before
            $playrex_header_style = $playrex_page_settings_model->get_settings( 'playrex_header_style' );
            $playrex_header_builder_option = $playrex_page_settings_model->get_settings( 'playrex_header_builder_option' );

            if( $playrex_header_style == 'header_builder'  ) {

                if( !empty( $playrex_header_builder_option ) ) {
                    $playrexheader = get_post( $playrex_header_builder_option );
                    echo '<header class="header">';
                        echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $playrexheader->ID );
                    echo '</header>';
                }
            } else {
                // global options
                $playrex_header_builder_trigger = playrex_opt('playrex_header_options');
                if( $playrex_header_builder_trigger == '2' ) {
                    echo '<header>';
                    $playrex_global_header_select = get_post( playrex_opt( 'playrex_header_select_options' ) );
                    $header_post = get_post( $playrex_global_header_select );
                    echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $header_post->ID );
                    echo '</header>';
                } else {
                    // wordpress Header
                    playrex_global_header_option();
                }
            }
        } else {
            $playrex_header_options = playrex_opt('playrex_header_options');
            if( $playrex_header_options == '1' ) {
                playrex_global_header_option();
            } else {
                $playrex_header_select_options = playrex_opt('playrex_header_select_options');
                $playrexheader = get_post( $playrex_header_select_options );
                echo '<header class="header">';
                    echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $playrexheader->ID );
                echo '</header>';
            }
        }
    } else {
        playrex_global_header_option();
    }