<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Border;
/**
 *
 * Header Widget .
 *
 */
class Zocker_Header extends Widget_Base {

	public function get_name() {
		return 'zockerheader';
	}

	public function get_title() {
		return __( 'Header', 'zocker' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'zocker_header_elements' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'header_section',
			[
				'label' 	=> __( 'Header', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );



        $this->add_control(
			'header_style',
			[
				'label' 	=> __( 'Style', 'zocker' ),
				'type' 		=> Controls_Manager::SELECT,
				'options' 	=> [
					'1' => __( 'Style One', 'zocker' ),
					'2' => __( 'Style Two', 'zocker' ),
					'3' => __( 'Style Three', 'zocker' ),
				],
				'default' 	=> '1',
			]
        );

		$this->add_control(
			'zocker_topbar_left_text',
			[
				'label' 		=> __( 'Topbar Left Text', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'condition'		=> [
					'header_style!' => '3'
				]
			]
		);
		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'social_icon',
			[
				'label' 		=> __( 'Social Icon', 'zocker' ),
				'type' 			=> Controls_Manager::ICONS,
				'default' 		=> [
					'value' 		=> 'fas fa-star',
					'library' 		=> 'solid',
				],
			]
		);

		$repeater->add_control(
			'icon_link',
			[
				'label' 		=> __( 'Link', 'zocker' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'zocker' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
			]
		);

		$this->add_control(
			'social_icon_repeat',
			[
				'label' 	=> __( 'Icon List', 'zocker' ),
				'type' 		=> Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
				'default' 	=> [
					[
						'social_icon' 	=> __( 'Icon #1', 'zocker' ),
					],
					[
						'social_icon' 	=> __( 'Icon #2', 'zocker' ),
					],
				],
				'title_field' 	=> '{{{ social_icon.value }}}',
			]
		);
		$this->add_control(
			'logo_image',
			[
				'label' 		=> __( 'Upload Logo', 'zocker' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'logo_link',
			[
				'label' 		=> __( 'Logo Link', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
			]
		);

		$this->add_control(
			'zocker_live_stream_text',
			[
				'label' 		=> __( 'Live Streaming Text', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'condition'		=> [ 'header_style'	=> ['1','2'] ]
			]
		);

		$this->add_control(
			'zocker_live_stream_url',
			[
				'label' 		=> __( 'Live Streaming Url', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'condition'		=> [ 'header_style'	=> ['1','2'] ]
			]
		);

		$this->add_control(
			'show_language',
			[
				'label' 		=> __( 'Show Language?', 'zocker' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'zocker' ),
				'label_off' 	=> __( 'Hide', 'zocker' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
				'condition'		=> [
					'header_style!' => '3'
				]
			]
		);

		$this->add_control(
			'show_search',
			[
				'label' 		=> __( 'Show Search?', 'zocker' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'zocker' ),
				'label_off' 	=> __( 'Hide', 'zocker' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);

		$this->add_control(
			'show_offcanvas',
			[
				'label' 		=> __( 'Show Offcanvas?', 'zocker' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'zocker' ),
				'label_off' 	=> __( 'Hide', 'zocker' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);

		$this->add_control(
			'zocker_my_account_text',
			[
				'label' 		=> __( 'My Account Text', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'condition'		=> [ 'header_style'	=> '3' ]
			]
		);

		$this->add_control(
			'zocker_my_account_url',
			[
				'label' 		=> __( 'My Account Url', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'condition'		=> [ 'header_style'	=> '3' ]
			]
		);

        $this->end_controls_section();

		$this->start_controls_section(
			'header_topbar_style',
			[
				'label' 	=> __( 'Header Topbar Style', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'topbar_background_color',
			[
				'label' 		=> __( 'Topbar Background Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .header-top' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .header-layout5 .animate-line' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'topbar_left_text_color',
			[
				'label' 		=> __( 'Topbar Left Text Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .header-top p,{{WRAPPER}} .header-layout5 .animate-line p' => 'color: {{VALUE}} !important',
				],
				'condition'		=> [ 'header_style'	=> [ '1','2' ] ],
			]
		);

		$this->add_control(
			'topbar_links_icon_color',
			[
				'label' 		=> __( 'Topbar Links Icon Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .social-links li a' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'topbar_links_icon_hover_color',
			[
				'label' 		=> __( 'Topbar Links Icon Hover Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .social-links li a:hover' => 'color: {{VALUE}}!important',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'menu_top_level_menu_item_style_section',
			[
				'label' 	=> __( 'Top Level Menu Items', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'top_level_menu_alignment',
			[
				'label' 	=> __( 'Menu Alignment', 'zocker' ),
				'type' 		=> Controls_Manager::CHOOSE,
				'options' 	=> [
					'left' 		=> [
						'title' 	=> __( 'Left', 'zocker' ),
						'icon' 		=> 'fa fa-align-left',
					],
					'center' 	=> [
						'title' 	=> __( 'Center', 'zocker' ),
						'icon' 		=> 'fa fa-align-center',
					],
					'right' 	=> [
						'title' 	=> __( 'Right', 'zocker' ),
						'icon' 		=> 'fa fa-align-right',
					],
				],
				'selectors' 	=> [
					'{{WRAPPER}} ul.mega-menu' => 'text-align: {{VALUE}} !important;',
				],
				'toggle' 		=> true,
			]
		);

        $this->add_control(
			'top_level_menu_color',
			[
				'label' 		=> __( 'Menu Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} ul.mega-menu > li > a' => 'color: {{VALUE}} !important;',
                ]
			]
        );

        $this->add_control(
			'top_level_menu_hover_color',
			[
				'label' 			=> __( 'Menu Hover Color', 'zocker' ),
				'type' 				=> Controls_Manager::COLOR,
				'selectors' 		=> [
					'{{WRAPPER}} ul.mega-menu > li > a:hover' => 'color: {{VALUE}} !important;',
                ]
			]
        );

        $this->add_control(
			'top_level_menu_bg_color',
			[
				'label' 			=> __( 'Menu Background Color', 'zocker' ),
				'type' 				=> Controls_Manager::COLOR,
				'selectors' 		=> [
					'{{WRAPPER}} #mega-menu-wrap-primary-menu,{{WRAPPER}} ul.mega-menu > li > a' => 'background-color: {{VALUE}} !important;',
                ]
			]
		);

		$this->add_control(
			'top_level_menu_hover_bg_color',
			[
				'label' 		=> __( 'Menu Hover Background Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} ul.mega-menu > li > a:hover' => 'background-color: {{VALUE}} !important;',
                ]
			]
		);

		$this->add_control(
			'top_level_menu_current_item_color',
			[
				'label' 		=> __( 'Menu Current Item Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} ul.mega-menu > li.mega-current-menu-item > a' => 'color: {{VALUE}} !important;',
					'{{WRAPPER}} ul.mega-menu > li.mega-current-menu-ancestor.mega-current-menu-parent > a' => 'color: {{VALUE}} !important;',
                ]
			]
        );

		$this->add_control(
			'top_level_menu_current_item_bg_color',
			[
				'label' 		=> __( 'Menu Current Item Background Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} ul.mega-menu > li.mega-current-menu-item > a' => 'background-color: {{VALUE}} !important;',
					'{{WRAPPER}} ul.mega-menu > li.mega-current-menu-ancestor.mega-current-menu-parent > a' => 'background-color: {{VALUE}} !important;',
                ]
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'top_level_menu_typography',
				'label' 		=> __( 'Menu Typography', 'zocker' ),
                'selector' 		=> '{{WRAPPER}} ul.mega-menu > li > a,#mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-item > a.mega-menu-link',
			]
		);

        $this->add_responsive_control(
			'top_level_menu_margin',
			[
				'label' 		=> __( 'Menu Margin', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} ul.mega-menu > li > a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ]
			]
        );

        $this->add_responsive_control(
			'top_level_menu_padding',
			[
				'label' 		=> __( 'Menu Padding', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} ul.mega-menu > li > a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ]
			]
		);

		$this->add_control(
			'top_level_menu_height',
			[
				'label' 		=> __( 'Height', 'zocker' ),
				'type' 			=> Controls_Manager::SLIDER,
				'size_units' 	=> [ 'px' ],
				'range' 	=> [
					'px' 	=> [
						'min' 	=> 0,
						'step' 	=> 1,
						'max'	=> 500
					],
				],
				'selectors' => [
					'{{WRAPPER}} ul.mega-menu > li > a' => 'height: {{SIZE}}{{UNIT}} !important;line-height: {{SIZE}}{{UNIT}} !important;'
                ]
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'top_level_menu_border',
				'label' 	=> __( 'Border', 'zocker' ),
				'selector' 	=> '{{WRAPPER}} ul.mega-menu > li > a,{{WRAPPER}} #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li > a',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'flyout_menu_item_style_section',
			[
				'label' 	=> __( 'Flyout Menu', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_control(
			'flyout_submenu_bg_color',
			[
				'label' 		=> __( 'Sub Menu Background', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} ul.mega-menu li.mega-menu-flyout ul li a,{{WRAPPER}} ul.mega-menu li.mega-menu-flyout ul' => 'background-color: {{VALUE}} !important;',
                ]
			]
		);

		$this->add_control(
			'flyout_submenu_width',
			[
				'label' 		=> __( 'Sub Menu Width', 'zocker' ),
				'type' 			=> Controls_Manager::SLIDER,
				'size_units' 	=> [ 'px' ],
				'range' 	=> [
					'px' 	=> [
						'min' 	=> 0,
						'step' 	=> 1,
						'max'	=> 500
					],
				],
				'selectors' => [
					'{{WRAPPER}} ul.mega-menu li.mega-menu-flyout ul' => 'width: {{SIZE}}{{UNIT}} !important;',
                ]
			]
		);

		$this->add_responsive_control(
			'flyout_submenu_padding',
			[
				'label' 		=> __( 'Sub Menu Padding', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} ul.mega-menu li.mega-menu-flyout ul' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ]
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'flyout_submenu_border',
				'label' 	=> __( 'Sub Menu Border', 'zocker' ),
				'selector' 	=> '{{WRAPPER}} ul.mega-menu li.mega-menu-flyout ul,{{WRAPPER}} #mega-menu-wrap-primary-menu #mega-menu-primary-menu li.mega-menu-flyout ul',
			]
		);

		$this->add_responsive_control(
			'flyout_submenu_border_radius',
			[
				'label' => __( 'Sub Menu Border Radius', 'zocker' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} ul.mega-menu li.mega-menu-flyout ul' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				]
			]
		);

		$this->add_control(
			'flyout_menu_item_color',
			[
				'label' => __( 'Menu Item Color', 'zocker' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} ul.mega-menu li.mega-menu-flyout ul li a' => 'color: {{VALUE}} !important;',
				]
			]
		);

		$this->add_control(
			'flyout_menu_item_bg_color',
			[
				'label' => __( 'Menu Item Background Color', 'zocker' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} ul.mega-menu li.mega-menu-flyout ul li a' => 'background-color: {{VALUE}} !important;',
                ]
			]
		);

		$this->add_control(
			'flyout_menu_item_hover_color',
			[
				'label' => __( 'Menu Item Hover Color', 'zocker' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} ul.mega-menu li.mega-menu-flyout ul li a:hover' => 'color: {{VALUE}} !important;',
                ]
			]
		);

		$this->add_control(
			'flyout_menu_item_hover_bg_color',
			[
				'label' => __( 'Menu Item Hover Background Color', 'zocker' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} ul.mega-menu li.mega-menu-flyout ul li a:hover' => 'background-color: {{VALUE}} !important;',
                ]
			]
		);

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'flyout_menu_item_typography',
				'label' => __( 'Menu Item Typography', 'zocker' ),
                'selector' => '{{WRAPPER}} ul.mega-menu li.mega-menu-flyout ul li a',
			]
		);

        $this->add_responsive_control(
			'flyout_menu_item_margin',
			[
				'label' => __( 'Menu Item Margin', 'zocker' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} ul.mega-menu li.mega-menu-flyout ul li a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ]
			]
        );

        $this->add_responsive_control(
			'flyout_menu_item_padding',
			[
				'label' => __( 'Menu Item Padding', 'zocker' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} ul.mega-menu li.mega-menu-flyout ul li a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ]
			]
		);

		$this->add_control(
			'flyout_menu_item_height',
			[
				'label' 		=> __( 'Menu Item Height', 'zocker' ),
				'type' 			=> Controls_Manager::SLIDER,
				'size_units' 	=> [ 'px' ],
				'range' 	=> [
					'px' 	=> [
						'min' 	=> 0,
						'step' 	=> 1,
						'max'	=> 500
					],
				],
				'selectors' => [
					'{{WRAPPER}} ul.mega-menu li.mega-menu-flyout ul li a' => 'height: {{SIZE}}{{UNIT}} !important;',
                ]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'mega_menu_style_section',
			[
				'label' => __( 'Mega Menu', 'zocker' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_control(
			'megamenu_panel_bg_color',
			[
				'label' => __( 'Panel Background', 'zocker' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} ul.mega-menu > li.mega-menu-megamenu > ul.mega-sub-menu' => 'background-color: {{VALUE}} !important;',
                ]
			]
		);

		$this->add_responsive_control(
			'megamenu_panel_padding',
			[
				'label' => __( 'Panel Padding', 'zocker' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} ul.mega-menu > li.mega-menu-megamenu > ul.mega-sub-menu' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ]
			]
		);

		$this->add_responsive_control(
			'megamenu_column_padding',
			[
				'label' => __( 'Column Padding', 'zocker' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} ul.mega-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ]
			]
		);

		$this->add_control(
			'megamenu_second_level_items',
			[
				'label' 	=> __( 'Second Level Menu Items', 'zocker' ),
				'type' 		=> Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'megamenu_second_level_item_color',
			[
				'label' 	=> __( 'Item Color', 'zocker' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link' => 'color: {{VALUE}} !important;',
				]
			]
		);

		$this->add_control(
			'megamenu_second_level_item_hover_color',
			[
				'label' 		=> __( 'Item Hover Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link:hover' => 'color: {{VALUE}} !important;',
				]
			]
		);

		$this->add_control(
			'megamenu_second_level_item_bg_color',
			[
				'label' 		=> __( 'Item Background Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link' => 'background-color: {{VALUE}} !important;',
				]
			]
		);

		$this->add_control(
			'megamenu_second_level_item_bg_hover_color',
			[
				'label' 		=> __( 'Item Hover Background Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link:hover' => 'background-color: {{VALUE}} !important;',
				]
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'megamenu_second_level_item_typography',
				'label' 	=> __( 'Item Typography', 'zocker' ),
                'selector' 	=> '{{WRAPPER}} #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link',
			]
		);

		$this->add_responsive_control(
			'megamenu_second_level_item_padding',
			[
				'label' 		=> __( 'Item Padding', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ]
			]
		);

        $this->add_responsive_control(
			'megamenu_second_level_item_margin',
			[
				'label' 		=> __( 'Item Margin', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ]
			]
		);

		$this->add_control(
			'megamenu_third_level_items',
			[
				'label' 		=> __( 'Third Level Menu Items', 'zocker' ),
				'type' 			=> Controls_Manager::HEADING,
				'separator' 	=> 'before',
			]
		);

		$this->add_control(
			'megamenu_third_level_item_color',
			[
				'label' 	=> __( 'Item Color', 'zocker' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item li.mega-menu-item > a.mega-menu-link' => 'color: {{VALUE}} !important;',
				]
			]
		);

		$this->add_control(
			'megamenu_third_level_item_hover_color',
			[
				'label' 	=> __( 'Item Hover Color', 'zocker' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item li.mega-menu-item > a.mega-menu-link:hover' => 'color: {{VALUE}} !important;',
				]
			]
		);

		$this->add_control(
			'megamenu_third_level_item_bg_color',
			[
				'label' 	=> __( 'Item Background Color', 'zocker' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item li.mega-menu-item > a.mega-menu-link' => 'background-color: {{VALUE}} !important;',
				]
			]
		);

		$this->add_control(
			'megamenu_third_level_item_bg_hover_color',
			[
				'label' 		=> __( 'Item Hover Background Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item li.mega-menu-item > a.mega-menu-link:hover' => 'background-color: {{VALUE}} !important;',
				]
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'megamenu_third_level_item_typography',
				'label' 	=> __( 'Item Typography', 'zocker' ),
                'selector' 	=> '{{WRAPPER}} #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item li.mega-menu-item > a.mega-menu-link',
			]
		);

		$this->add_responsive_control(
			'megamenu_third_level_item_padding',
			[
				'label' 		=> __( 'Item Padding', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item li.mega-menu-item > a.mega-menu-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ]
			]
		);

        $this->add_responsive_control(
			'megamenu_third_level_item_margin',
			[
				'label' 		=> __( 'Item Margin', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} #mega-menu-wrap-primary-menu #mega-menu-primary-menu > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item li.mega-menu-item > a.mega-menu-link' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ]
			]
        );

		$this->end_controls_section();

        $this->start_controls_section(
			'general_style',
			[
				'label' 	=> __( 'General', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'header_background_color',
			[
				'label' 		=> __( 'Header Background Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} #mega-menu-wrap-primary-menu,{{WRAPPER}} .header-main .bg-dark,{{WRAPPER}} .header-layout5 .bg-fluid,{{WRAPPER}} .menu-area.bg-black' => 'background-color: {{VALUE}}!important',
				],
				'separator'		=> 'after',
			]
		);

		$this->add_control(
			'button_text_color',
			[
				'label' 		=> __( 'Button Text Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .vs-btn.outline1' => 'color: {{VALUE}}',
				],
				'condition'		=> [ 'header_style' => [ '1', '2' ] ]
			]
		);

		$this->add_control(
			'button_text_color_hover',
			[
				'label' 		=> __( 'Button Text Color On Hover', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .vs-btn.outline1:hover' => 'color: {{VALUE}}',
				],
				'condition'		=> [ 'header_style' => [ '1', '2' ] ]
			]
		);

		$this->add_control(
			'button_border_color',
			[
				'label' 		=> __( 'Button Border Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .vs-btn.outline1:before' => 'border-color: {{VALUE}}',
				],
				'condition'		=> [ 'header_style' => [ '1', '2' ] ]
			]
		);

		$this->add_control(
			'button_border_color_hover',
			[
				'label' 		=> __( 'Button Border Color Hover', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .vs-btn.outline1:hover::before' => 'border-color: {{VALUE}}',
				],
				'condition'		=> [ 'header_style' => [ '1', '2' ] ]
			]
		);

		$this->add_control(
			'header_icon_color',
			[
				'label' 		=> __( 'Header Icon Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .header-list1 button' => 'color: {{VALUE}}',
				],
				'condition'		=> [ 'header_style' => [ '1', '2' ] ]
			]
		);

		$this->add_control(
			'header_icon_color_hover',
			[
				'label' 		=> __( 'Header Icon Color Hover', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .header-list1 button:hover' => 'color: {{VALUE}}',
				],
				'condition'		=> [ 'header_style' => [ '1', '2' ] ]
			]
		);

        $this->end_controls_section();


    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        if( $settings['header_style'] == '1' ) {
			echo '<div class="header-wrapper header-layout4">';
				echo '<div class="header-top">';
					echo '<div class="container">';
						echo '<div class="row py-md-2 align-items-center">';
							echo '<div class="col-sm-6 d-none d-md-block">';
								if( ! empty( $settings['zocker_topbar_left_text'] ) ){
									echo '<p class="header-text">'.wp_kses_post( $settings['zocker_topbar_left_text'] ).'</p>';
								}
							echo '</div>';
							echo '<div class="col-sm-6 text-end d-none d-md-block">';
								$social_icon = $settings['social_icon_repeat'];
								if( ! empty( $social_icon ) ){
									echo '<ul class="social-links fs-xs text-white">';
										foreach( $social_icon as $single_icon ){
											$target   = $single_icon['icon_link']['is_external'] ? ' target="_blank"' : '';
											$nofollow = $single_icon['icon_link']['nofollow'] ? ' rel="nofollow"' : '';
											echo '<li><a '.wp_kses_post( $target.$nofollow ).' href="'.esc_url( $single_icon['icon_link']['url'] ).'">';
												\Elementor\Icons_Manager::render_icon( $single_icon['social_icon'], [ 'aria-hidden' => 'true' ] );
											echo '</a></li>';
										}
									echo '</ul>';
								}
							echo '</div>';
						echo '</div>';
					echo '</div>';
				echo '</div>';
				echo '<div class="header-main">';
					echo '<div class="container position-relative">';
						echo '<div class="header-inner">';
		                    echo '<div class="row align-items-center justify-content-between">';
		                        echo '<div class="col-auto col-lg-4 d-block d-xl-none py-xl-0">';
		                            if( ! empty( $settings['logo_image']['url'] ) ){
										echo '<div class="header-logo-one">';
			                                echo '<a href="'.esc_url( $settings['logo_link'] ).'">';
												echo playrex_img_tag( array(
													'url' => esc_url( $settings['logo_image']['url'] ),
													'class' => 'logo-img',
												) );
											echo '</a>';
			                            echo '</div>';
									}
		                        echo '</div>';
		                        echo '<div class="col-auto col-lg-8 col-xl-5 text-end text-xl-start">';
		                            echo '<nav class="main-menu menu-style1 d-none d-lg-block" data-expand="992">';
		                                if( has_nav_menu('primary-menu') ) {
		                                    wp_nav_menu( array(
		                                        "theme_location"    => 'primary-menu',
		                                        "container"         => '',
		                                        "menu_class"        => ''
		                                    ) );
		                                }
		                            echo '</nav>';
		                            echo '<button type="button" class="vs-menu-toggle ms-auto text-white d-block d-lg-none"> <i class="far fa-bars"></i></button>';
		                        echo '</div>';
		                        echo '<div class="col-md-4 col-lg-2 text-center d-none d-xl-block align-self-strech">';
									if( ! empty( $settings['logo_image']['url'] ) ){
										echo '<div class="header-logo1">';
											echo '<a href="'.esc_url( $settings['logo_link'] ).'">';
												echo playrex_img_tag( array(
													'url' => esc_url( $settings['logo_image']['url'] ),
													'class' => 'logo-img',
												) );
											echo '</a>';
										echo '</div>';
									}
		                        echo '</div>';
		                        echo '<div class="col-md-4 col-lg-5 d-none d-xl-block">';
		                            echo '<div class="header-right d-flex align-items-center justify-content-end">';
		                                if( ! empty( $settings['zocker_live_stream_text'] ) ){
		                                    echo '<a href="'.esc_url( $settings['zocker_live_stream_url'] ).'" class="vs-btn style3 d-none d-xl-inline-block"><i class="fab fa-twitch"></i><strong>'.esc_html( $settings['zocker_live_stream_text'] ).'</strong></a>';
		                                }
		                                echo '<ul class="header-list1 list-style-none ml-30">';
		                                    if( class_exists( 'GTranslate' ) && $settings['show_language'] == 'yes' ){
		                                        echo '<li>';
		                                            echo '<button class="dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">';
		                                                echo '<i class="fas fa-globe flag radius-circle"></i>';
		                                            echo '</button>';
		                                            echo '<ul class="dropdown-menu">';
		                                                echo '<li>';
		                                                    echo do_shortcode('[gtranslate]');
		                                                echo '</li>';
		                                            echo '</ul>';
		                                        echo '</li>';
		                                    }
		                                    if( $settings['show_search'] == 'yes' ){
		                                        echo '<li>';
		                                            echo '<button class="searchBoxTggler"><i class="far fa-search"></i></button>';
		                                        echo '</li>';
		                                    }
		                                    if( $settings['show_offcanvas'] == 'yes' && is_active_sidebar( 'playrex-offcanvas-sidebar' ) ){
		                                        echo '<li>';
		                                            echo '<button class="sideMenuToggler"><i class="fal fa-grip-horizontal fs-2"></i></button>';
		                                        echo '</li>';
		                                    }
		                                echo '</ul>';
		                            echo '</div>';
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
	                echo '</div>';
                echo '</div>';
            echo '</div>';
        }elseif( $settings['header_style'] == '2' ) {
			echo '<div class="header-wrapper header-layout5">';
				echo '<div class="container">';
					echo '<div class="header-inner">';
						echo '<div class="header-top">';
							echo '<div class="row">';
								echo '<div class="col-sm-6 d-none d-sm-block">';
									if( ! empty( $settings['zocker_topbar_left_text'] ) ){
										echo '<p class="header-text">'.wp_kses_post( $settings['zocker_topbar_left_text'] ).'</p>';
									}
								echo '</div>';
								echo '<div class="col-sm-6 text-center text-sm-end">';
									$social_icon = $settings['social_icon_repeat'];
									if( ! empty( $social_icon ) ){
										echo '<ul class="social-links fs-xs text-white">';
											foreach( $social_icon as $single_icon ){
												$target   = $single_icon['icon_link']['is_external'] ? ' target="_blank"' : '';
												$nofollow = $single_icon['icon_link']['nofollow'] ? ' rel="nofollow"' : '';
												echo '<li><a '.wp_kses_post( $target.$nofollow ).' href="'.esc_url( $single_icon['icon_link']['url'] ).'">';
													\Elementor\Icons_Manager::render_icon( $single_icon['social_icon'], [ 'aria-hidden' => 'true' ] );
												echo '</a></li>';
											}
										echo '</ul>';
									}
								echo '</div>';
							echo '</div>';
						echo '</div>';
						echo '<div class="menu-area">';
		                    echo '<div class="row align-items-center">';
		                        echo '<div class="col-6 col-lg-3 col-xl-2">';
                                    if( ! empty( $settings['logo_image']['url'] ) ){
                                        echo '<div class="header-logo py-3 py-lg-0">';
                                            echo '<a href="'.esc_url( $settings['logo_link'] ).'">';
                                                echo playrex_img_tag( array(
                                                    'url' => esc_url( $settings['logo_image']['url'] ),
                                                    'class' => 'logo-img',
                                                ) );
                                            echo '</a>';
                                        echo '</div>';
                                    }
		                        echo '</div>';
		                        echo '<div class="col-6 col-lg-6 col-xl-5 text-end">';
		                            echo '<nav class="main-menu menu-style1 d-none d-lg-block">';
										if( has_nav_menu('primary-menu') ) {
											wp_nav_menu( array(
												"theme_location"    => 'primary-menu',
												"container"         => '',
												"menu_class"        => ''
											) );
										}
		                            echo '</nav>';
		                            echo '<button type="button" class="vs-menu-toggle ms-auto text-white d-block d-lg-none"> <i class="far fa-bars"></i></button>';
		                        echo '</div>';
		                        echo '<div class="col-lg-3 col-xl-5 d-none d-lg-block">';
		                            echo '<div class="header-right d-flex align-items-center justify-content-end">';
										if( ! empty( $settings['zocker_live_stream_text'] ) ){
											echo '<a href="'.esc_url( $settings['zocker_live_stream_url'] ).'" class="vs-btn outline1 d-none d-xl-inline-block"><i class="fab fa-twitch"></i><strong>'.esc_html( $settings['zocker_live_stream_text'] ).'</strong></a>';
										}
										echo '<ul class="header-list1 list-style-none ml-30">';
											if( class_exists( 'GTranslate' ) && $settings['show_language'] == 'yes' ){
												echo '<li>';
													echo '<button class="dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">';
														echo '<i class="fas fa-globe flag radius-circle"></i>';
													echo '</button>';
													echo '<ul class="dropdown-menu">';
														echo '<li>';
															echo do_shortcode('[gtranslate]');
														echo '</li>';
													echo '</ul>';
												echo '</li>';
											}
											if( $settings['show_search'] == 'yes' ){
												echo '<li>';
													echo '<button class="searchBoxTggler"><i class="far fa-search"></i></button>';
												echo '</li>';
											}
											if( $settings['show_offcanvas'] == 'yes' && is_active_sidebar( 'playrex-offcanvas-sidebar' ) ){
												echo '<li>';
													echo '<button class="sideMenuToggler"><i class="fal fa-grip-horizontal fs-2"></i></button>';
												echo '</li>';
											}
										echo '</ul>';
		                            echo '</div>';
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
					echo '</div>';
				echo '</div>';
            echo '</div>';
        }else{
			echo '<div class="header-wrapper header-layout6 z-index-step1">';
		        echo '<div class="bg-major-black header-top py-2">';
		            echo '<div class="container">';
		                echo '<div class="row">';
		                    echo '<div class="col-sm-6 col-lg-4 offset-lg-2 d-none d-sm-block">';
								$social_icon = $settings['social_icon_repeat'];
								if( ! empty( $social_icon ) ){
									echo '<ul class="social-links fs-xs text-white">';
										foreach( $social_icon as $single_icon ){
											$target   = $single_icon['icon_link']['is_external'] ? ' target="_blank"' : '';
											$nofollow = $single_icon['icon_link']['nofollow'] ? ' rel="nofollow"' : '';
											echo '<li><a '.wp_kses_post( $target.$nofollow ).' href="'.esc_url( $single_icon['icon_link']['url'] ).'">';
												\Elementor\Icons_Manager::render_icon( $single_icon['social_icon'], [ 'aria-hidden' => 'true' ] );
											echo '</a></li>';
										}
									echo '</ul>';
								}
		                    echo '</div>';
		                    echo '<div class="col-sm-6 col-lg-6 text-center text-sm-end">';
		                        echo '<ul class="header-list2 list-style-none">';
									if( ! empty( $settings['zocker_my_account_text'] ) ){
			                            echo '<li><a href="'.esc_url( $settings['zocker_my_account_url'] ).'"><i class="fal fa-user"></i>'.esc_html( $settings['zocker_my_account_text'] ).'</a></li>';
									}
		                        echo '</ul>';
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		        echo '<div class="menu-area bg-black py-3 py-lg-0">';
		            echo '<div class="container position-relative">';
		                echo '<div class="row align-items-center">';
		                    echo '<div class="col-6 col-xl-2">';
								if( ! empty( $settings['logo_image']['url'] ) ){
									echo '<div class="header-logo3 bg-major-black d-none d-lg-block">';
										echo '<a href="'.esc_url( $settings['logo_link'] ).'">';
											echo playrex_img_tag( array(
												'url' => esc_url( $settings['logo_image']['url'] ),
												'class' => 'logo-img',
											) );
										echo '</a>';
									echo '</div>';
									echo '<a class="d-inline-block d-lg-none" href="'.esc_url( $settings['logo_link'] ).'">';
										echo playrex_img_tag( array(
											'url' => esc_url( $settings['logo_image']['url'] ),
											'class' => 'logo-img',
										) );
									echo '</a>';
								}
		                    echo '</div>';
		                    echo '<div class="col-6 col-lg-8 col-xl-6 offset-lg-4 offset-xl-0 text-end text-xl-start">';
								echo '<nav class="main-menu menu-style2 d-none d-lg-block" data-expand="992">';
									if( has_nav_menu( 'primary-menu' ) ) {
										wp_nav_menu( array(
											"theme_location"    => 'primary-menu',
											"container"         => '',
											"menu_class"        => ''
										) );
									}
								echo '</nav>';
		                        echo '<button type="button" class="vs-menu-toggle text-white d-inline-block d-lg-none"> <i class="far fa-bars"></i></button>';
		                    echo '</div>';
		                    echo '<div class="col-xl-4 align-items-stretch d-none d-xl-flex">';
		                        if( $settings['show_search'] == 'yes' ){
									echo '<form action="'.esc_url( home_url( '/' ) ).'" class="header-form bg-major-black">';
			                            echo '<input name="s" type="text" class="form-control text-white" placeholder="'.esc_attr__( 'Type Keyword', 'zocker' ).'">';
			                            echo '<button type="submit"><i class="far fa-search"></i></button>';
			                        echo '</form>';
								}
								if( $settings['show_offcanvas'] == 'yes' && is_active_sidebar( 'playrex-offcanvas-sidebar' ) ){
			                        echo '<button class="sideMenuToggler toggler-btn2"><i class="far fa-bars"></i></button>';
								}
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';
		}

		 // Mobile Menu
		 echo '<div class="vs-menu-wrapper">';
		 echo '<div class="vs-menu-area bg-dark">';
			 echo '<button class="vs-menu-toggle"><i class="fal fa-times"></i></button>';
			if( ! empty( $settings['logo_image']['url'] ) ){
					echo '<div class="mobile-logo">';
						echo '<a href="'.esc_url( $settings['logo_link'] ).'">';
							echo playrex_img_tag( array(
								'url' => esc_url( $settings['logo_image']['url'] ),
								'class' => 'logo-img',
							) );
						echo '</a>';
					echo '</div>';
			}
			if( has_nav_menu( 'mobile-menu' ) ){
				echo '<div class="vs-mobile-menu link-inherit">';
					wp_nav_menu( array(
						"theme_location"    => 'mobile-menu',
						"container"         => '',
						"menu_class"        => ''
					) );
				echo '</div>';
			}
		echo '</div>';
	echo '</div>';

		echo '<div class="popup-search-box d-none d-lg-block">';
			echo '<button class="searchClose">';
			echo '<i class="fal fa-times"></i></button>';
			echo '<form action="'.esc_url( home_url() ).'">';
				echo '<input name="s" value="" type="text" class="border-theme" placeholder="'.esc_attr__( 'What are you looking for', 'zocker' ).'">';
				echo '<button type="submit"><i class="fal fa-search"></i></button>';
			echo '</form>';
		echo '</div>';


		if( is_active_sidebar( 'playrex-offcanvas-sidebar' ) ){
			echo '<div class="sidemenu-wrapper d-none d-lg-block">';
				echo '<div class="sidemenu-content bg-light-dark">';
					echo '<button class="closeButton sideMenuCls">';
						echo '<i class="far fa-times"></i>';
					echo '</button>';
					dynamic_sidebar( 'playrex-offcanvas-sidebar' );
				echo '</div>';
			echo '</div>';
		}
	}

}