<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * About Us Widget .
 *
 */
class Zocker_About_Us extends Widget_Base {

	public function get_name() {
		return 'zockeraboutus';
	}

	public function get_title() {
		return __( 'About Us', 'zocker' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'zocker' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'image_section',
			[
				'label'     => __( 'About Us', 'zocker' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );
		$this->add_control(
			'about_style',
			[
				'label' 		=> __( 'About Us Style', 'zocker' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'one',
				'options' 		=> [
					'one'  			=> __( 'Style One', 'zocker' ),
					'two' 			=> __( 'Style Two', 'zocker' ),
				],
			]
		);
		$this->add_control(
			'about_image_shape_one',
			[
				'label'     => __( 'About Image Shape One', 'zocker' ),
				'type'      => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'about_image_shape_two',
			[
				'label'     => __( 'About Image Shape Two', 'zocker' ),
				'type'      => Controls_Manager::MEDIA,
				'default' 	=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'about_image',
			[
				'label'     => __( 'About Image', 'zocker' ),
				'type'      => Controls_Manager::MEDIA,
				'default' 	=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'counter_number',
            [
				'label'         => __( 'Counter Number', 'zocker' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( '5' , 'zocker' ),
				'label_block'   => true,
				'condition'		=> [ 'about_style' =>  'one' ],

			]
		);
		$this->add_control(
			'counter_number_text',
            [
				'label'         => __( 'Counter Number Text', 'zocker' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Year Experience' , 'zocker' ),
				'label_block'   => true,
				'condition'		=> [ 'about_style' =>  'one' ],

			]
		);

		$this->add_control(
			'about_subtitle',
            [
				'label'         => __( 'About Subtitle', 'zocker' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'PROFESSIONAL ESPORTS TEAM' , 'zocker' ),
				'label_block'   => true,
				'condition'		=> [ 'about_style' =>  'two' ],
			]
		);
        $this->add_control(
			'about_title',
            [
				'label'         => __( 'About Title', 'zocker' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'About Us' , 'zocker' ),
				'label_block'   => true,
			]
		);
        $this->add_control(
			'about_description',
            [
				'label'         => __( 'About Description', 'zocker' ),
				'type'          => Controls_Manager::WYSIWYG,
				'default'       => __( 'About Description' , 'zocker' ),
				'label_block'   => true,
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'list_title', [
				'label' 		=> __( 'Title', 'zocker' ),
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> __( 'List Title' , 'zocker' ),
				'label_block' 	=> true,
			]
		);

		$this->add_control(
			'list',
			[
				'label' 			=> __( 'Repeater List', 'zocker' ),
				'type' 				=> Controls_Manager::REPEATER,
				'fields' 			=> $repeater->get_controls(),
				'default' 			=> [
					[
						'list_title' 		=> __( 'Title #1', 'zocker' ),
					],
					[
						'list_title' 		=> __( 'Title #2', 'zocker' ),
					],
				],
				'title_field' 				=> '{{{ list_title }}}',
				'condition'			=> [ 'about_style' => 'two' ],
			]
		);

		$this->add_control(
			'button_text',
            [
				'label'         => __( 'Button Text?', 'zocker' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Set Button Text' , 'zocker' ),
				'label_block'   => true,
				'condition'		=> [ 'about_style' => 'two' ],
			]
		);

        $this->add_control(
			'button_url',
            [
				'label'         => __( 'Button Url?', 'zocker' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( '#' , 'zocker' ),
				'label_block'   => true,
				'condition'		=> [ 'about_style' => 'two' ],
			]
		);

		$this->add_control(
			'video_url',
			[
				'label'         => __( 'Video Url?', 'zocker' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Set Video Url' , 'zocker' ),
				'label_block'   => true,
				'condition'		=> [ 'about_style' => 'two' ],
			]
		);
        $this->end_controls_section();


		$this->start_controls_section(
			'about_us_style_option',
			[
				'label' 	=> __( 'Style', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'about_us_subtitle_color',
			[
				'label' 		=> __( 'Sub Title Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .sub-title2' => 'color: {{VALUE}}',
                ],
				'condition'		=> [ 'about_style' => 'two' ],

			]
        );
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'          => 'about_us_subtitle_typography',
				'label'         => __( 'Sub Title Typography', 'zocker' ),
                'selector'      => '{{WRAPPER}} .sub-title2',
				'condition'		=> [ 'about_style' => 'two' ],
			]
		);
		$this->add_control(
			'about_us_title_color',
			[
				'label' 		=> __( 'Title Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .sec-title1,{{WRAPPER}} .sec-title2' => 'color: {{VALUE}}',
                ],
				'separator'		=> 'before',
			]
        );
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'          => 'about_us_title_typography',
				'label'         => __( 'Title Typography', 'zocker' ),
                'selector'      => '{{WRAPPER}} .sec-title1,{{WRAPPER}} .sec-title2',
			]
		);
        $this->add_responsive_control(
			'about_us_title_margin',
			[
				'label'         => __( 'Title Margin', 'zocker' ),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
					'{{WRAPPER}} .sec-title1,{{WRAPPER}} .sec-title2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->add_responsive_control(
			'about_us_title_padding',
			[
				'label'         => __( 'Title Padding', 'zocker' ),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
					'{{WRAPPER}} .sec-title1,{{WRAPPER}} .sec-title2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
				'separator'		=> 'after',
			]
		);
		$this->add_control(
			'about_us_description_color',
			[
				'label' 		=> __( 'About Us Description Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .about-content1 p,{{WRAPPER}} .vs-about-wrapper p' => 'color: {{VALUE}}',
                ]
			]
        );
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'          => 'about_us_description_typography',
				'label'         => __( 'About Us Description Typography', 'zocker' ),
                'selector'      => '{{WRAPPER}} .about-content1 p,{{WRAPPER}} .vs-about-wrapper p',
			]
		);
        $this->add_responsive_control(
			'about_us_description_margin',
			[
				'label'         => __( 'About Us Description Margin', 'zocker' ),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
					'{{WRAPPER}} .about-content1 p,{{WRAPPER}} .vs-about-wrapper p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->add_responsive_control(
			'about_us_description_padding',
			[
				'label'         => __( 'About Us Description Padding', 'zocker' ),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
					'{{WRAPPER}} .about-content1 p,{{WRAPPER}} .vs-about-wrapper p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'list_title_option',
			[
				'label' 	=> __( 'List Title Style', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
				'condition'	=> [ 'about_style' => 'two' ],
			]
		);
		$this->add_control(
			'list_title_color',
			[
				'label' 		=> __( 'List Title Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .about-list li' => 'color: {{VALUE}}',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'          => 'list_title_typography',
				'label'         => __( 'List Title Typography', 'zocker' ),
				'selector'      => '{{WRAPPER}} .about-list li',
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'button_option',
			[
				'label' 	=> __( 'Button Style', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
				'condition'	=> [ 'about_style' => 'two' ],
			]
		);
		$this->add_control(
			'button_color',
			[
				'label' 		=> __( 'Button Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .vs-btn.gradient-btn' => 'color: {{VALUE}}',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'          => 'button_typography',
				'label'         => __( 'Button Typography', 'zocker' ),
				'selector'      => '{{WRAPPER}} .vs-btn.gradient-btn',
			]
		);
		$this->end_controls_section();

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		if( $settings['about_style'] == 'one' ){
			echo '<section class="vs-about-wrapper position-relative space-bottom">';
				if( $settings['about_image_shape_one']['url'] ){
					echo '<div class="position-absolute bottom-0 end-0 d-none d-lg-block">';
						echo playrex_img_tag( array(
							'url'	=> esc_url( $settings['about_image_shape_one']['url'] )
						) );
					echo '</div>';
				}
				if( $settings['about_image_shape_two']['url'] ){
					echo '<div class="position-absolute bottom-0 start-0 d-none d-lg-block">';
						echo playrex_img_tag( array(
							'url'	=> esc_url( $settings['about_image_shape_two']['url'] )
						) );
					echo '</div>';
				}
				echo '<div class="container z-index-common">';
					echo '<div class="row gx-60">';
						echo '<div class="col-lg-6 mb-20 mb-lg-0">';
							echo '<div class="picture-box1 hover-shape">';
								if( ! empty( $settings['about_image']['url'] ) ){
									echo playrex_img_tag( array(
										'url'	=> esc_url( $settings['about_image']['url'] ),
										'class' => 'w-100 d-block'
									) );
								}
								echo '<div class="exp-box1 text-start">';
									if( ! empty( $settings['counter_number'] ) ){
										echo '<h2 class="h1 mb-0 counter"><span class="number">'.esc_html( $settings['counter_number'] ).'</span>+</h2>';
									}
									if( ! empty( $settings['counter_number_text'] ) ){
										echo '<p class="exp-text mb-0">'.esc_html( $settings['counter_number_text'] ).'</p>';
									}
								echo '</div>';
							echo '</div>';
						echo '</div>';
						echo '<div class="col-lg-6 align-self-center">';
							echo '<div class="about-content1 pl-35">';
								if( ! empty( $settings['about_title'] ) ){
									echo '<h2 class="sec-title2">'.esc_html( $settings['about_title'] ).'</h2>';
								}
								if( ! empty( $settings['about_description'] ) ){
									echo wp_kses_post( $settings['about_description'] );
								}
							echo '</div>';
						echo '</div>';
					echo '</div>';
				echo '</div>';
			echo '</section>';
		}else{
			echo '<section class="vs-about-wrapper">';
		        echo '<div class="container">';
		            echo '<div class="row flex-lg-row-reverse">';
		                echo '<div class="col-md-8 col-lg-6 mb-40 mb-xl-0">';
		                    echo '<div class="hover-shape position-relative img-box2 text-start text-xl-end">';
								if( $settings['about_image_shape_one']['url'] ){
									echo '<div class="shape1 position-absolute start-0 top-0 ml-15">';
										echo playrex_img_tag( array(
											'url'	=> esc_url( $settings['about_image_shape_one']['url'] )
										) );
									echo '</div>';
								}
								if( $settings['about_image_shape_two']['url'] ){
									echo '<div class="shape2 position-absolute">';
										echo playrex_img_tag( array(
											'url'	=> esc_url( $settings['about_image_shape_two']['url'] )
										) );
									echo '</div>';
								}
								if( ! empty( $settings['about_image']['url'] ) ){
									echo playrex_img_tag( array(
										'url'	=> esc_url( $settings['about_image']['url'] ),
									) );
								}
								if( ! empty( $settings['video_url'] ) ){
			                        echo '<a href="'.esc_url( $settings['video_url'] ).'" class="popup-video play-btn position-center"><i class="fas fa-play"></i></a>';
								}
		                    echo '</div>';
		                echo '</div>';
		                echo '<div class="col-lg-6">';
							if( ! empty( $settings['about_subtitle'] ) ){
			                    echo '<span class="sub-title2 mb-30">'.esc_html( $settings['about_subtitle'] ).'</span>';
							}
							if( ! empty( $settings['about_title'] ) ){
			                    echo '<h2 class="sec-title1 mb-15">'.esc_html( $settings['about_title'] ).'</h2>';
							}
							if( ! empty( $settings['about_description'] ) ){
			                    echo wp_kses_post( $settings['about_description'] );
							}
							if( ! empty( $settings['list'] ) ){
			                    echo '<ul class="about-list fs-18 list-style-none mb-35">';
									foreach( $settings['list'] as $single_list ){
				                        echo '<li>'.esc_html( $single_list['list_title'] ).'</li>';
									}
			                    echo '</ul>';
							}
							if( ! empty( $settings['button_text'] ) ){
			                    echo '<a href="'.esc_url( $settings['button_url'] ).'" class="vs-btn gradient-btn">'.esc_html( $settings['button_text'] ).'</a>';
							}
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</section>';
		}
	}
}