<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
/**
 *
 * Blog Post Widget .
 *
 */
class Zocker_Blog_Post extends Widget_Base {

	public function get_name() {
		return 'zockerblogpost';
	}

	public function get_title() {
		return __( 'Blog Post', 'zocker' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'zocker' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'blog_post_section',
			[
				'label' 	=> __( 'Blog Post', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'blog_style',
			[
				'label' 	=> __( 'Blog Style', 'zocker' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  	=> __( 'Style One', 'zocker' ),
					'2' 	=> __( 'Style Two', 'zocker' ),
					'3' 	=> __( 'Style Three', 'zocker' ),
					'4' 	=> __( 'Style Four', 'zocker' ),
				],
			]
		);

        $this->add_control(
			'blog_post_count',
			[
				'label' 	=> __( 'No of Post to show', 'zocker' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( '4', 'zocker' )
			]
        );

		$this->add_control(
			'title_count',
			[
				'label' 	=> __( 'Title Length', 'zocker' ),
				'type' 		=> Controls_Manager::TEXT,
				'default'  	=> __( '4', 'zocker' ),
			]
		);

        $this->add_control(
			'blog_post_order',
			[
				'label' 	=> __( 'Order', 'zocker' ),
                'type' 		=> Controls_Manager::SELECT,
                'options'   => [
                    'ASC'   	=> __('ASC','zocker'),
                    'DESC'   	=> __('DESC','zocker'),
                ],
                'default'  	=> 'DESC'
			]
        );

        $this->add_control(
			'blog_post_order_by',
			[
				'label' 	=> __( 'Order By', 'zocker' ),
                'type' 		=> Controls_Manager::SELECT,
                'options'   => [
                    'ID'    	=> __( 'ID', 'zocker' ),
                    'author'    => __( 'Author', 'zocker' ),
                    'title'    	=> __( 'Title', 'zocker' ),
                    'date'    	=> __( 'Date', 'zocker' ),
                    'rand'    	=> __( 'Random', 'zocker' ),
                ],
                'default'  	=> 'ID'
			]
        );

        $this->add_control(
			'exclude_cats',
			[
				'label' 		=> __( 'Exclude Categories', 'zocker' ),
                'type' 			=> Controls_Manager::SELECT2,
                'multiple' 		=> true,
				'options' 		=> $this->zocker_get_categories(),
			]
        );

        $this->add_control(
			'exclude_tags',
			[
				'label' 		=> __( 'Exclude Tags', 'zocker' ),
                'type' 			=> Controls_Manager::SELECT2,
                'multiple' 		=> true,
				'options' 		=> $this->zocker_get_tags(),
			]
        );

        $this->add_control(
			'exclude_post_id',
			[
				'label'         => __( 'Exclude Post', 'zocker' ),
                'type'          => Controls_Manager::SELECT2,
                'multiple'      => true,
				'options'       => $this->zocker_post_id(),
			]
        );

        $this->end_controls_section();

		$this->start_controls_section(
			'slider_control_section',
			[
				'label' 		=> __( 'Slider Control', 'zocker' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'show_arrows',
			[
				'label' 		=> __( 'Show Arrows?', 'zocker' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'zocker' ),
				'label_off' 	=> __( 'Hide', 'zocker' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);

		$this->add_control(
			'slide_to_show',
			[
				'label' 		=> __( 'Slide To Show', 'zocker' ),
				'type' 			=> Controls_Manager::SLIDER,
				'size_units' 	=> [ 'px' ],
				'range' 		=> [
					'px' 			=> [
						'min' 			=> 0,
						'max' 			=> 10,
						'step'			=> 1,
					],
				],
				'default' 	=> [
					'unit' 		=> 'px',
					'size' 		=> 3,
				],
			]
		);
		$this->end_controls_section();

        $this->start_controls_section(
			'post_title_style_section',
			[
				'label' 	=> __( 'Title', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'post_title_color',
			[
				'label' 		=> __( 'Title Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .vs-blog .blog-title a' => 'color: {{VALUE}} !important',
				],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'post_title_typography',
				'label' 	=> __( 'Title Typography', 'zocker' ),
				'selector' 	=> '{{WRAPPER}} .vs-blog .blog-title a',
			]
        );

        $this->add_responsive_control(
			'post_title_margin',
			[
				'label' 		=> __( 'Title Margin', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .vs-blog .blog-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'post_title_padding',
			[
				'label' 		=> __( 'Title Padding', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .vs-blog .blog-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

        $this->end_controls_section();

		$this->start_controls_section(
			'meta_style',
			[
				'label' 	=> __( 'Meta', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'meta_color',
			[
				'label' 		=> __( 'Meta Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .vs-blog .blog-meta a,{{WRAPPER}} .blog-meta a' => 'color: {{VALUE}}!important',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'meta_typography',
				'label' 	=> __( 'Meta Typography', 'zocker' ),
				'selector' 	=> '{{WRAPPER}} .vs-blog .blog-meta a,{{WRAPPER}} .blog-meta a',
			]
		);
		$this->end_controls_section();
    }

    public function zocker_get_categories() {
        $cats = get_terms(array(
            'taxonomy' => 'category',
            'hide_empty' => true,
        ));

        $catarr = [];

        foreach( $cats as $singlecat ) {
            $catarr[$singlecat->term_id] = __($singlecat->name,'zocker');
        }

        return $catarr;
    }

    public function zocker_get_tags() {
        $cats = get_terms(array(
            'taxonomy' => 'post_tag',
            'hide_empty' => true,
        ));

        $catarr = [];

        foreach( $cats as $singlecat ) {
            $catarr[$singlecat->term_id] = __($singlecat->name,'zocker');
        }

        return $catarr;
    }

    // Get Specific Post
    public function zocker_post_id(){
        $args = array(
            'post_type'         => 'post',
            'posts_per_page'    => -1,
        );

        $zocker_post = new WP_Query( $args );

        $postarray = [];

        while( $zocker_post->have_posts() ){
            $zocker_post->the_post();
            $postarray[get_the_Id()] = get_the_title();
        }
        wp_reset_postdata();
        return $postarray;
    }

	protected function render() {

        $settings = $this->get_settings_for_display();
        $exclude_post = $settings['exclude_post_id'];

        if( !empty( $settings['exclude_cats'] ) && empty( $settings['exclude_tags'] ) && empty( $settings['exclude_post_id'] ) ) {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true,
                'category__not_in'      => $settings['exclude_cats']
            );
        } elseif( !empty( $settings['exclude_cats'] ) && !empty( $settings['exclude_tags'] ) && empty( $settings['exclude_post_id'] ) ) {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true,
                'category__not_in'      => $settings['exclude_cats'],
                'tag__not_in'           => $settings['exclude_tags']
            );
        }elseif( !empty( $settings['exclude_cats'] ) && !empty( $settings['exclude_tags'] ) && !empty( $settings['exclude_post_id'] ) ) {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true,
                'category__not_in'      => $settings['exclude_cats'],
                'tag__not_in'           => $settings['exclude_tags'],
                'post__not_in'          => $exclude_post
            );
        } elseif( !empty( $settings['exclude_cats'] ) && empty( $settings['exclude_tags'] ) && !empty( $settings['exclude_post_id'] ) ) {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true,
                'category__not_in'      => $settings['exclude_cats'],
                'post__not_in'          => $exclude_post
            );
        } elseif( empty( $settings['exclude_cats'] ) && !empty( $settings['exclude_tags'] ) && !empty( $settings['exclude_post_id'] ) ) {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true,
                'tag__not_in'           => $settings['exclude_tags'],
                'post__not_in'          => $exclude_post
            );
        } elseif( empty( $settings['exclude_cats'] ) && !empty( $settings['exclude_tags'] ) && empty( $settings['exclude_post_id'] ) ) {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true,
                'tag__not_in'           => $settings['exclude_tags'],
            );
        } elseif( empty( $settings['exclude_cats'] ) && empty( $settings['exclude_tags'] ) && !empty( $settings['exclude_post_id'] ) ) {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true,
                'post__not_in'          => $exclude_post
            );
        } else {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true
            );
        }
		if( $settings['blog_style'] == '1' ){
	        $this->add_render_attribute( 'wrapper', 'class', 'row vs-carousel arrow-white' );
		}elseif( $settings['blog_style'] == '2' ){
			$this->add_render_attribute( 'wrapper', 'class', 'row vs-carousel arrow-margin' );
		}else{
			$this->add_render_attribute( 'wrapper', 'class', 'row vs-carousel multibg-color-cat  arrow-margin arrow-white arrow-wrap' );
		}

		if( $settings['show_arrows'] == 'yes' ){
	        $this->add_render_attribute( 'wrapper', 'data-slick-arrows', 'true' );
		}else{
			$this->add_render_attribute( 'wrapper', 'data-slick-arrows', 'false' );
		}

        $this->add_render_attribute( 'wrapper', 'data-slide-to-show', $settings['slide_to_show']['size'] );
        $this->add_render_attribute( 'wrapper', 'data-slick-autoplay', 'true' );


        $blogpost = new WP_Query( $args );

		if( $settings['blog_style'] == '1' ){
	        if( $blogpost->have_posts() ) {
				echo '<!-- blog Area -->';
				echo '<section class="vs-blog-wrapper vs-blog-layout1">';
				  	echo '<div class="container">';
				    	echo '<div '.$this->get_render_attribute_string('wrapper').'>';
							while( $blogpost->have_posts() ) {
								$blogpost->the_post();
								echo '<div class="col-lg-4">';
				                    echo '<div class="vs-blog">';
										if( has_post_thumbnail() ){
											echo '<div class="blog-image image-scale-hover">';
												echo '<a href="'.esc_url( get_the_permalink() ).'">';
													the_post_thumbnail( 'home-slider-blog-image', array( 'class' => 'w-100' ) );
												echo '</a>';
												echo '<div class="blog-category">';
													$category = get_the_category();
													if( $category && ! empty( $category ) ){
														echo '<a href="'.esc_url( get_term_link( $category[0]->term_id ) ).'">'.esc_html( $category[0]->name ).'</a>';
													}
												echo '</div>';
											echo '</div>';
										}
				                        echo '<div class="blog-content">';
											if( get_the_title() ){
												echo '<!-- Post Title -->';
												echo '<h3 class="blog-title text-white fs-20"><a href="'.esc_url( get_permalink() ).'">'.esc_html( wp_trim_words( get_the_title( ), $settings['title_count'], '' ) ).'</a></h3>';
												echo '<!-- End Post Title -->';
											}
				                            echo '<div class="blog-meta text-light fs-xs">';
				                                echo '<a href="'.esc_url( playrex_blog_date_permalink() ).'"><i class="fal fa-calendar-alt"></i>';
													echo '<time datetime="'.esc_attr( get_the_date( DATE_W3C ) ).'">'.esc_html( get_the_date() ).'</time>';
												echo '</a>';
				                                echo '<a href="'.esc_url( get_author_posts_url( get_the_author_meta('ID') ) ).'"><i class="fal fa-user"></i>'.esc_html( ucwords( get_the_author() ) ).'</a>';
				                            echo '</div>';
				                        echo '</div>';
				                    echo '</div>';
				                echo '</div>';
						  	}
							wp_reset_postdata();
				    	echo '</div><!-- .row END -->';
				  	echo '</div><!-- .container END -->';
				echo '</section>';
				echo '<!-- blog Area end -->';
	        }
		}elseif( $settings['blog_style'] == '2' ){
			if( $blogpost->have_posts() ) {
				echo '<section class="vs-blog-wrapper vs-blog-layout2 link-inherit arrow-wrap">';
			        echo '<div class="container">';
						echo '<div '.$this->get_render_attribute_string('wrapper').'>';
							while( $blogpost->have_posts() ) {
								$blogpost->the_post();
				                echo '<div class="col-xl-4">';
				                    echo '<div class="vs-blog image-scale-hover">';
										if( has_post_thumbnail() ){
					                        echo '<a href="'.esc_url( get_the_permalink() ).'" class="overlay"></a>';
											echo '<div class="blog-image">';
												echo '<a href="'.esc_url( get_the_permalink() ).'">';
													the_post_thumbnail( 'home-slider-blog-image-two', array( 'class' => 'w-100' ) );
												echo '</a>';
					                        echo '</div>';
										}
				                        echo '<div class="blog-content">';
				                            echo '<div class="blog-meta text-light fs-xs mb-10 text-white">';
												echo '<a href="'.esc_url( playrex_blog_date_permalink() ).'"><i class="fal fa-calendar-alt"></i>';
													echo '<time datetime="'.esc_attr( get_the_date( DATE_W3C ) ).'">'.esc_html( get_the_date() ).'</time>';
												echo '</a>';
				                            echo '</div>';
											if( get_the_title() ){
												echo '<!-- Post Title -->';
												echo '<h3 class="blog-title h5 font-theme mb-0 text-white"><a href="'.esc_url( get_permalink() ).'">'.esc_html( wp_trim_words( get_the_title( ), $settings['title_count'], '' ) ).'</a></h3>';
												echo '<!-- End Post Title -->';
											}
				                        echo '</div>';
				                    echo '</div>';
				                echo '</div>';
							}
				        echo '</div>';
			        echo '</div>';
			    echo '</section>';
			}
		}elseif( $settings['blog_style'] == '3' ){
			if( $blogpost->have_posts() ) {				
			echo '<!-- blog Area -->';
				echo '<div class="vs-video-area blog-demo-layout3">';
			        echo '<div class="container">';
						echo '<div '.$this->get_render_attribute_string('wrapper').'>';
							while( $blogpost->have_posts() ) {
								$blogpost->the_post();
				                echo '<div class="col-lg-4 vs-blog mb-25">';
				                    echo '<div class="position-relative">';
										if( has_post_thumbnail() ){
											echo '<div class="blog-image">';
												echo '<a href="'.esc_url( get_the_permalink() ).'">';
													the_post_thumbnail( 'home-slider-blog-image', array( 'class' => 'w-100' ) );
												echo '</a>';
												echo '<div class="blog-category">';
													$category = get_the_category();
													if( $category && ! empty( $category ) ){
														echo '<a href="'.esc_url( get_term_link( $category[0]->term_id ) ).'">'.esc_html( $category[0]->name ).'</a>';
													}
												echo '</div>';
											echo '</div>';
										}
				                        echo '<div class="blog-content mt-15">';
											if( get_the_title() ){
												echo '<!-- Post Title -->';
												echo '<h3 class="blog-title font-theme text-white lh-base fs-20 mb-1"><a href="'.esc_url( get_permalink() ).'">'.esc_html( wp_trim_words( get_the_title( ), $settings['title_count'], '' ) ).'</a></h3>';
												echo '<!-- End Post Title -->';
											}

				                            echo '<div class="blog-meta text-light fs-xs">';
												echo '<a href="'.esc_url( playrex_blog_date_permalink() ).'"><i class="fal fa-calendar-alt"></i>';
													echo '<time datetime="'.esc_attr( get_the_date( DATE_W3C ) ).'">'.esc_html( get_the_date() ).'</time>';
												echo '</a>';
				                            echo '</div>';

				                        echo '</div>';
				                    echo '</div>';
				                echo '</div>';
							}
			            echo '</div>';
			        echo '</div>';
			    echo '</div>';
			}
		}else{
			if( $blogpost->have_posts() ) {
				echo '<div class="featured-blog-wrapper">';
			        echo '<div class="container">';
						echo '<div '.$this->get_render_attribute_string('wrapper').'>';
							while( $blogpost->have_posts() ) {
								$blogpost->the_post();
								echo '<div class="vs-blog col-xl-3">';
				                    echo '<div class="position-relative">';
										if( has_post_thumbnail() ){
					                        echo '<a href="'.esc_url( get_permalink() ).'" class="overlay overlay-lg"></a>';
					                        echo '<div class="blog-image">';
					                            the_post_thumbnail( 'home-slider-blog-image-three', array( 'class' => 'w-100' ) );
					                        echo '</div>';
										}
				                        echo '<div class="blog-content pos-bottom">';
											$category = get_the_category();
											if( $category && ! empty( $category ) ){
					                            echo '<div class="blog-category mb-1">';
													echo '<a href="'.esc_url( get_term_link( $category[0]->term_id ) ).'">'.esc_html( $category[0]->name ).'</a>';
				                            	echo '</div>';
											}
											if( get_the_title() ){
					                            echo '<h3 class="blog-title h5 text-white font-theme lh-base mb-2"><a href="'.esc_url( get_permalink() ).'">'.esc_html( wp_trim_words( get_the_title( ), $settings['title_count'], '' ) ).'</a></h3>';
											}
				                            echo '<div class="blog-meta text-light-white fs-xs ">';
												echo '<a href="'.esc_url( playrex_blog_date_permalink() ).'"><i class="fal fa-calendar-alt"></i>';
													echo '<time datetime="'.esc_attr( get_the_date( DATE_W3C ) ).'">'.esc_html( get_the_date() ).'</time>';
												echo '</a>';
				                            echo '</div>';
				                        echo '</div>';
				                    echo '</div>';
				                echo '</div>';
							}
			            echo '</div>';
			        echo '</div>';
			    echo '</div>';
			}
		}
	}
}