<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
/**
 *
 * Client Logo Widget .
 *
 */
class Zocker_Client_Logo extends Widget_Base {

	public function get_name() {
		return 'zockerclientlogo';
	}

	public function get_title() {
		return __( 'Client Logo', 'zocker' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'zocker' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'client_logo_section',
			[
				'label' 	=> __( 'Client Logo', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

        $repeater = new Repeater();

		$repeater->add_control(
			'client_logo',
			[
				'label' 	=> __( 'Client Logo', 'zocker' ),
				'type' 		=> Controls_Manager::MEDIA,
				'default' => [
					'url' 	=> Utils::get_placeholder_image_src(),
				],
			]
		);

		$repeater->add_control(
			'logo_link',
			[
				'label' 		=> __( 'Link', 'zocker' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'zocker' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
			]
		);

		$this->add_control(
			'logos',
			[
				'label' 		=> __( 'Client Logos', 'zocker' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'client_logo' => Utils::get_placeholder_image_src(),
					],
					[
						'client_logo' => Utils::get_placeholder_image_src(),
					],
					[
						'client_logo' => Utils::get_placeholder_image_src(),
					],
					[
						'client_logo' => Utils::get_placeholder_image_src(),
					],
					[
						'client_logo' => Utils::get_placeholder_image_src(),
					],
				]
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
			'slider_control_section',
			[
				'label' 		=> __( 'Slider Control', 'zocker' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
			'desktop_items',
			[
				'label' 		=> __( 'Items To Show', 'zocker' ),
				'type' 			=> Controls_Manager::SLIDER,
				'size_units' 	=> [ '%' ],
				'range' 		=> [
					'%' 	=> [
						'min' 		=> 0,
						'step' 		=> 1,
						'max' 		=> 10,
					],
				],
				'default' 		=> [
					'unit' 			=> '%',
					'size' 			=> 5,
				],
			]
		);

		$this->add_control(
			'slider_autoplay',
			[
				'label' 		=> __( 'Autoplay', 'zocker' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'zocker' ),
				'label_off' 	=> __( 'No', 'zocker' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);

		$this->add_control(
			'slider_arrows',
			[
				'label' 		=> __( 'Arrows', 'zocker' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'zocker' ),
				'label_off' 	=> __( 'No', 'zocker' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);

		$this->add_control(
			'arrows_color',
			[
				'label' 		=> __( 'Arrows Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .arrow-white .slick-arrow' => 'color: {{VALUE}}!important',
				],
				'condition'		=> [ 'slider_arrows'	=> 'yes' ]
			]
		);

		$this->add_responsive_control(
			'image_align',
			[
				'label' 		=> __( 'Alignment', 'zocker' ),
				'type' 			=> Controls_Manager::CHOOSE,
				'options' 		=> [
					'left' 			=> [
						'title' 		=> __( 'Left', 'zocker' ),
						'icon' 			=> 'fa fa-align-left',
					],
					'center' 		=> [
						'title' 		=> __( 'Center', 'zocker' ),
						'icon' 			=> 'fa fa-align-center',
					],
					'right' 	=> [
						'title' 		=> __( 'Right', 'zocker' ),
						'icon' 			=> 'fa fa-align-right',
					],
				],
				'default' 		=> 'left',
				'toggle' 		=> true,
				'selectors' 	=> [
					'{{WRAPPER}} .vs-brand-wrapper .col-xl-2' => 'text-align: {{VALUE}}',
                ],
			]
        );

        $this->end_controls_section();

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

	    $this->add_render_attribute( 'wrapper', 'class', 'row vs-carousel arrow-white' );

        $this->add_render_attribute('wrapper','data-slide-to-show',$settings['desktop_items']['size']);

		if( $settings['slider_autoplay'] == 'yes' ) {
			$this->add_render_attribute('wrapper','data-slick-autoplay','true');
		} else {
			$this->add_render_attribute('wrapper','data-slick-autoplay','false');
		}

		if( $settings['slider_arrows'] == 'yes' ) {
			$this->add_render_attribute( 'wrapper', 'data-slick-arrows', 'true' );
		} else {
			$this->add_render_attribute( 'wrapper', 'data-slick-arrows', 'false' );
		}

		echo '<div class="vs-brand-wrapper arrow-wrap">';
			if( ! empty( $settings['logos'] ) ){
		        echo '<div class="container">';
		            echo '<div '.$this->get_render_attribute_string('wrapper').'>';
						foreach( $settings['logos'] as $singlelogo ) {
							$target = $singlelogo['logo_link']['is_external'] ? ' target="_blank"' : '';
							$nofollow = $singlelogo['logo_link']['nofollow'] ? ' rel="nofollow"' : '';
							echo '<div class="col-xl-2">';
			                    echo '<div class="vs-brand">';
			                        echo '<a '.wp_kses_post( $nofollow.$target ).' href="'.esc_url( $singlelogo['logo_link']['url'] ).'">';
			                            echo '<img src="'.esc_url( $singlelogo['client_logo']['url'] ).'" alt="'.esc_attr( playrex_image_alt( $singlelogo['client_logo']['url']) ).'">';
			                        echo '</a>';
			                    echo '</div>';
			                echo '</div>';
						}
		            echo '</div>';
		        echo '</div>';
			}
	    echo '</div>';
	}
}