<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
/**
 *
 * Contact Form Widget .
 *
 */
class Zocker_Contact_Form extends Widget_Base {

	public function get_name() {
		return 'zockercontactform';
	}

	public function get_title() {
		return __( 'Contact Form', 'zocker' );
	}


	public function get_icon() {
		return 'fa fa-code';
    }


	public function get_categories() {
		return [ 'zocker' ];
	}


	protected function _register_controls() {

		$this->start_controls_section(
			'form_section',
			[
				'label' 	=> __( 'Contact Form', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'form_style',
			[
				'label' 	=> __( 'Form Style', 'zocker' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> 'one',
				'options' 	=> [
					'one'  		=> __( 'Style One', 'zocker' ),
					'two' 		=> __( 'Style Two', 'zocker' ),
					'three' 	=> __( 'Style Three', 'zocker' ),
				],
			]
		);

        $this->add_control(
			'section_title',
			[
				'label' 	=> __( 'Title', 'zocker' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Title', 'zocker' ),
				'condition' => [ 'form_style' => [ 'one','three' ] ],
			]
        );
        $this->add_control(
			'section_description',
			[
				'label' 	=> __( 'Section Description', 'zocker' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Write Description', 'zocker' ),
				'condition' => [ 'form_style' => [ 'one','three' ] ],
			]
        );

        $this->add_control(
			'contact_form_shortcode',
			[
				'label' => __( 'Form Shortcode', 'zocker' ),
                'type' => Controls_Manager::TEXTAREA,
			]
        );

        $this->end_controls_section();

		$this->start_controls_section(
			'general',
			[
				'label' 	=> __( 'General', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

		$this->end_controls_section();

        $this->start_controls_section(
			'section_title_style',
			[
				'label' 		=> __( 'Section Title', 'zocker' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
				'condition'     => [ 'form_style' => [ 'one','three' ] ],
			]
        );

        $this->add_control(
			'section_title_color',
			[
				'label' => __( 'Title Color', 'zocker' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .vs-appointment h2' => 'color: {{VALUE}}',
				],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'section_title_typography',
				'label' => __( 'Title Typography', 'zocker' ),
				'selector' => '{{WRAPPER}} .vs-appointment h2',
			]
        );

        $this->add_responsive_control(
			'section_title_margin',
			[
				'label' => __( 'Title Margin', 'zocker' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .vs-appointment h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'section_title_padding',
			[
				'label' => __( 'Title Padding', 'zocker' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .vs-appointment h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
			'section_description_style',
			[
				'label' 		=> __( 'Section Description', 'zocker' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
				'condition'     => [ 'form_style' => [ 'one','three' ] ],
			]
        );
		$this->add_control(
			'section_description_color',
			[
				'label' 		=> __( 'Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .vs-appointment p' => 'color: {{VALUE}} !important;',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'section_description_typography',
				'label' 	=> __( 'Typography', 'zocker' ),
				'selector'	=> '{{WRAPPER}} .vs-appointment p',
			]
		);
        $this->add_responsive_control(
			'section_description_margin',
			[
				'label' 		=> __( 'Margin', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .vs-appointment p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'section_description_padding',
			[
				'label' 		=> __( 'Padding', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .vs-appointment p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
		);

        $this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		if( $settings['form_style'] == 'one' ){
			echo '<div class="container position-relative">';
	            echo '<div class="row align-items-center justify-content-center">';
	                echo '<div class="col-lg-8 col-xl-6 text-center">';
	                    echo '<div class="vs-appointment mb-40">';
							if( ! empty( $settings['section_title'] ) ){
								echo '<h2 class="h1">'.esc_html( $settings['section_title'] ).'</h2>';
							}
	                        if( ! empty( $settings['section_description'] ) ){
								echo '<p class="sec-text mb-0 mr-xl-40">'.wp_kses_post( $settings['section_description'] ).'</p>';
							}
	                    echo '</div>';
	                echo '</div>';
	                echo '<div class="col-xl-10">';
						echo '<div class="appointment-form-style1">';
							echo '<div class="row">';
								echo '<div class="col-lg-4 form-group">';
									echo '<i class="fal fa-calendar-alt"></i>';
									echo '<input type="text" id="aptDay" autocomplete="off" class="form-control date-pick" placeholder="'.esc_attr__( 'Select Date', 'zocker' ).'">';
								echo '</div>';
								echo '<div class="col-lg-4 form-group">';
									echo '<i class="fal fa-user"></i>';
									echo '<input type="number" id="aptGuests" autocomplete="off" class="qty-input form-control" placeholder="'.esc_attr__( 'Total Guests', 'zocker' ).'">';
								echo '</div>';
								echo '<div class="col-lg-4 form-group">';
									echo '<button id="aptSubmit1" type="submit" class="vs-btn style1 rounded-0 w-100" data-toggle="modal" data-target="#appointmentPopup">'.esc_html__( 'Book Now', 'zocker' ).'</button>';
								echo '</div>';
							echo '</div>';
						echo '</div>';
					echo '</div>';
				echo '</div>';
			echo '</div>';

			echo '<!-- Popup Appointment -->';
			echo '<div class="modal fade" id="appointmentPopup" aria-hidden="true">';
				echo '<div class="modal-dialog modal-dialog-centered" role="document">';
					echo '<div class="modal-content">';
						echo '<div class="modal-body text-center">';
							echo '<button type="button" class="close" data-dismiss="modal" aria-label="Close">';
								echo '<span class="text-theme"><i class="fal fa-times fa-1x"></i></span>';
							echo '</button>';
							echo '<div class="popup-appointment-form pt-lg-20 pb-lg-25 px-lg-20 ">';
								if( ! empty( $settings['contact_form_shortcode'] ) ){
									echo do_shortcode( $settings['contact_form_shortcode'] );
								}
							echo '</div>';
						echo '</div>';
					echo '</div>';
				echo '</div>';
			echo '</div>';
		}elseif( $settings['form_style'] == 'two' ){
			echo '<div class="vs-box2 h-100 bg-white mr-xl-200">';
				echo '<div class="reservation-form px-30 px-lg-40 px-xl-100 py-60 py-lg-100 py-xl-150">';
					if( ! empty( $settings['contact_form_shortcode'] ) ){
						echo do_shortcode( $settings['contact_form_shortcode'] );
					}
				echo '</div>';
			echo '</div>';
		}else{
			echo '<section class="appointment-form-wrapper appointment-form-layout2 z-index-common">';
		        echo '<div class="container position-relative">';
		            echo '<div class="row align-items-center justify-content-center">';
		                echo '<div class="col-lg-8 col-xl-5 text-center text-xl-left">';
		                    echo '<div class="vs-appointment mb-40">';
								if( ! empty( $settings['section_title'] ) ){
									echo '<h2 class="h1 text-white">'.esc_html( $settings['section_title'] ).'</h2>';
								}
		                        if( ! empty( $settings['section_description'] ) ){
									echo '<p class="sec-text text-white-light mb-0 mr-xl-40">'.wp_kses_post( $settings['section_description'] ).'</p>';
								}
		                    echo '</div>';
		                echo '</div>';
		                echo '<div class="col-xl-7">';
		                    echo '<div class="appointment-form-style2">';
		                        echo '<div class="row justify-content-center justify-content-lg-start">';
		                            echo '<div class="col-md-6 col-lg-4 form-group">';
		                                echo '<i class="fal fa-calendar-alt"></i>';
		                                echo '<input type="text" id="aptDay" autocomplete="off" class="form-control date-pick" placeholder="'.esc_attr__( 'Select Date', 'zocker' ).'">';
		                            echo '</div>';
		                            echo '<div class="col-md-6 col-lg-4 form-group">';
		                                echo '<i class="fal fa-user"></i>';
		                                echo '<input type="number" min="1" id="aptGuests" autocomplete="off" class="qty-input form-control" placeholder="'.esc_attr__( 'Total Guests', 'zocker' ).'">';
		                            echo '</div>';
		                            echo '<div class="col-md-4 col-lg-4 form-group">';
		                                echo '<button id="aptSubmit1" type="submit" class="vs-btn style1 w-100" data-toggle="modal" data-target="#appointmentPopup">'.esc_html__( 'Book Your Seat', 'zocker' ).'</button>';
		                            echo '</div>';
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</section>';

		    echo '<!-- Popup Appointment -->';
		    echo '<div class="modal fade" id="appointmentPopup" aria-hidden="true">';
		        echo '<div class="modal-dialog modal-dialog-centered" role="document">';
		            echo '<div class="modal-content">';
		                echo '<div class="modal-body text-center">';
		                    echo '<button type="button" class="close" data-dismiss="modal" aria-label="Close">';
		                        echo '<span class="text-theme"><i class="fal fa-times fa-1x"></i></span>';
		                    echo '</button>';
		                    echo '<div class="popup-appointment-form pt-lg-20 pb-lg-25 px-lg-20 ">';
								if( ! empty( $settings['contact_form_shortcode'] ) ){
									echo do_shortcode( $settings['contact_form_shortcode'] );
								}
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';
		}
	}
}