<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
use \Elementor\Utils;
/**
 * 
 * Contact Info Widget .
 *
 */
class Zocker_Contact_Info extends Widget_Base {

	public function get_name() {
		return 'zockercontactinfos';
	}

	public function get_title() {
		return __( 'Contact Info', 'zocker' );
	}

	public function get_icon() {
		return 'fa fa-code';
    }

	public function get_categories() {
		return [ 'zocker' ];
	}
	
	protected function _register_controls() {

		$this->start_controls_section(
			'contact_info_section',
			[
				'label' => __( 'Contact Info', 'zocker' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );
		
		
		$repeater = new Repeater();

		$repeater->add_control(
			'contact_icon',
			[
				'label'         => __( 'Choose Contact Icon', 'zocker' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => 'fal fa-envelope',
			]
		);

        $repeater->add_control(
			'contact_info_type',
			[
				'label' 	=> __( 'Contact Info Type', 'zocker' ),
				'type' 		=> Controls_Manager::SELECT,
				'default'	=> '1',
				'options' 	=> [
					'1'  => __( 'Location/Office Hour', 'zocker' ),
					'2'  => __( 'Phone', 'zocker' ),
					'3'  => __( 'Email', 'zocker' ),
				],
			]
		);
		
		$repeater->add_control(
			'info_head', [
				'label' 		=> __( 'Info Heading Text', 'zocker' ),
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> __( 'Mail Us' , 'zocker' ),
				'label_block' 	=> true,
			]
		);
		
		$repeater->add_control(
			'email_address_one', [
				'label' 		=> __( 'Email Address', 'zocker' ),
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> __( 'support@yourmail.com' , 'zocker' ),
				'label_block' 	=> true,
				'condition' 	=> [
                    'contact_info_type' => '3'
                ]
			]
		);
		
		$repeater->add_control(
			'phone_no_one', [
				'label' 		=> __( 'Phone Number', 'zocker' ),
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> __( '+967-321-111-222' , 'zocker' ),
				'label_block' 	=> true,
				'condition' 	=> [
                    'contact_info_type' => '2'
                ]
			]
		);

		$repeater->add_control(
			'location',
			[
				'label' 		=> __( 'Lcoation/Office Hour', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
                'placeholder' 	=> __( 'Type your description here', 'zocker' ),
                'condition' 	=> [
                    'contact_info_type' => '1'
                ]
			]
		);

		$this->add_control(
			'contact_information',
			[
				'label' 		=> __( 'Contact Information', 'zocker' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'email_address_one' => __( 'support@yourmail.com', 'zocker' ),
					],
				],
                'title_field' 	=> '{{{ email_address_one }}}',
			]
		);

        $this->end_controls_section();
		
        $this->start_controls_section(
			'contact_info_title_style_section',
			[
				'label' 		=> __( 'Contact Info Title Style', 'zocker' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        
        $this->add_control(
			'contact_info_background_color',
			[
				'label' 		=> __( 'Contact Info Background Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .info-box2' => 'background-color: {{VALUE}}',
                ]
			]
        );
		
        $this->add_control(
			'contact_info_icon_color',
			[
				'label' 		=> __( 'Contact Info Icon Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .icon-btn2 i' => 'color: {{VALUE}}!important',
                ]
			]
        );
		
        $this->add_control(
			'contact_info_title_color',
			[
				'label' 		=> __( 'Contact Info Title Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .info-style1 .heading' => 'color: {{VALUE}}!important',
                ]
			]
        );
		
        $this->add_control(
			'contact_info_title_color',
			[
				'label' 		=> __( 'Contact Info Title Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .info-style1 .heading' => 'color: {{VALUE}}!important',
                ]
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'contact_info_title_typography',
				'label' 	=> __( 'Contact Info Title Typography', 'zocker' ),
                'selector' 	=> '{{WRAPPER}} .info-style1 .heading',
			]
		);

        $this->add_responsive_control(
			'contact_info_title_margin',
			[
				'label' 		=> __( 'Contact Info Title Margin', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .info-style1 .heading' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
        
        $this->add_responsive_control(
			'contact_info_title_padding',
			[
				'label' 		=> __( 'Contact Info Title Padding', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .info-style1 .heading' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
        
        $this->end_controls_section();
		
        $this->start_controls_section(
			'contact_info_subtitle_style_section',
			[
				'label' => __( 'Contact Info SubTitle Style', 'zocker' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );
        
        $this->add_control(
			'contact_info_subtitle_color',
			[
				'label' => __( 'Contact Info SubTitle Color', 'zocker' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .info-style1 p.subtitle' => 'color: {{VALUE}}!important',
                ]
			]
        );
        $this->add_control(
			'contact_info_subtitle_ancor_color',
			[
				'label' => __( 'Contact Info SubTitle Ancor Color', 'zocker' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .info-style1 p.subtitle a' => 'color: {{VALUE}}',
                ]
			]
        );
		
        $this->add_control(
			'contact_info_subtitle_ancor_hover_color',
			[
				'label' 	=> __( 'Contact Info SubTitle Ancor Hover Color', 'zocker' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .info-style1 p.subtitle a:hover' => 'color: {{VALUE}}',
                ]
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'contact_info_subtitle_typography',
				'label' 	=> __( 'Contact Info SubTitle Typography', 'zocker' ),
                'selector' 	=> '{{WRAPPER}} .info-style1 p.subtitle',
			]
		);
        
        $this->end_controls_section();

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		echo '<!-- Contact Form -->';
		echo '<div class="info-box2 px-60 py-60 mb-40">';
			if( ! empty( $settings['contact_information'] ) ):
				foreach( $settings['contact_information'] as $contact ):
					echo '<!-- Information Box -->';
					echo '<div class="info-style1 text-center text-sm-start">';
						if( ! empty( $contact['contact_icon'] ) ){
							echo '<span class="icon-btn2"><i class="'.esc_attr( $contact['contact_icon'] ).'"></i></span>';
						}
						$replace 	= array(' ','-',' - ');
					    $with 		= array('','','');
						if( ! empty( $contact['info_head'] ) ){
							echo '<p class="heading fs-4 lh-1 fw-medium text-white mb-1 mb-sm-0">'.esc_html( $contact['info_head'] ).'</p>';
						}
						if( $contact['contact_info_type'] == '3' && ! empty( $contact['email_address_one'] ) ){
							$emailurl = str_replace( $replace, $with, $contact['email_address_one'] );
							echo '<p class="text-white subtitle mb-0"><a class="text-inherit" href="'.esc_attr( 'mailto:'.$emailurl ).'">'.esc_html( $contact['email_address_one'] ).'</a></p>';
						}elseif( $contact['contact_info_type'] == '2' && ! empty( $contact['phone_no_one'] ) ){
							$phoneurl = str_replace( $replace, $with, $contact['phone_no_one'] );
							echo '<p class="text-white subtitle mb-0"><a class="text-inherit" href="'.esc_attr( 'tel:'.$phoneurl ).'">'.esc_html( $contact['phone_no_one'] ).'</a></p>';
						}else{
							echo '<p class="text-white subtitle mb-0">'.esc_html( $contact['location'] ).'</p>';
						}
					echo '</div>';
				endforeach;
			endif;
		echo '</div>';
		echo '<!-- Contact Form end -->';
	}

}