<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
/**
 *
 * Google Map Widget .
 *
 */
class Zocker_Google_Map extends Widget_Base {

	public function get_name() {
		return 'zockergooglemap';
	}

	public function get_title() {
		return __( 'Google Map', 'zocker' );
	}


	public function get_icon() {
		return 'eicon-code';
    }


	public function get_categories() {
		return [ 'zocker' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'map_address_section',
			[
				'label' => __( 'Addresss', 'zocker' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
			'map_latitude',
			[
				'label' => __( 'Latitude', 'zocker' ),
                'type' => Controls_Manager::TEXT,
                'default'   => '23.7909601'
			]
        );

        $this->add_control(
			'map_longitude',
			[
				'label' => __( 'longitude', 'zocker' ),
                'type' => Controls_Manager::TEXT,
                'default'   => '90.3772613'
			]
        );

        $this->add_control(
			'map_zoom',
			[
				'label' => __( 'Zoom', 'zocker' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ '%' ],
				'range' => [
					'%' => [
						'min' => 0,
						'step' => 1,
						'max' => 20,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 10,
				],
			]
		);

        $this->add_control(
			'map_marker',
			[
				'label' => __( 'Marker', 'zocker' ),
                'type' => Controls_Manager::MEDIA
			]
        );

        $this->end_controls_section();

		$this->start_controls_section(
			'info_box_section',
			[
				'label' 	=> __( 'Info Box', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'service_center_name',
			[
				'label' 		=> __( 'Service Center Name', 'zocker' ),
                'type' 			=> Controls_Manager::TEXTAREA,
                'default'   	=> __( 'Washington DC, Services Center', 'zocker' ),
			]
        );

		$this->add_control(
			'service_center_address',
			[
				'label' 		=> __( 'Sevice Center Address', 'zocker' ),
                'type' 			=> Controls_Manager::TEXTAREA,
                'default'   	=> __( '301 Massachusetts Ave, Lunenburg MA 1462', 'zocker' ),
			]
        );

		$this->add_control(
			'phone_number_title',
			[
				'label' 		=> __( 'Phone Number Title', 'zocker' ),
                'type' 			=> Controls_Manager::TEXTAREA,
                'default'   	=> __( 'Get In Touch', 'zocker' ),
			]
        );

		$this->add_control(
			'phone_number',
			[
				'label' 		=> __( 'Phone Number', 'zocker' ),
                'type' 			=> Controls_Manager::TEXTAREA,
                'default'   	=> __( '85 125 1256 12145', 'zocker' ),
			]
        );

		$this->add_control(
			'email_address_title',
			[
				'label' 		=> __( 'Email Address Title', 'zocker' ),
                'type' 			=> Controls_Manager::TEXTAREA,
                'default'   	=> __( 'Mail Us', 'zocker' ),
			]
        );

		$this->add_control(
			'email_address',
			[
				'label' 		=> __( 'Email Address', 'zocker' ),
                'type' 			=> Controls_Manager::TEXTAREA,
                'default'   	=> __( 'zocker@gmail.com', 'zocker' ),
			]
        );

		$this->end_controls_section();

		$this->start_controls_section(
			'info_box_style',
			[
				'label' 	=> __( 'Info Box Style', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

		$this->add_control(
			'info_box_background',
			[
				'label' 		=> __( 'Info Box Background', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .info-box3' => 'background-color: {{VALUE}}!important',
				],
			]
		);

		$this->add_control(
			'service_title_color',
			[
				'label' 		=> __( 'Service Title Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .info-box3 h3' => 'color: {{VALUE}}!important',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'service_center_typography',
				'label' 		=> __( 'Service Center Typography', 'zocker' ),
				'selector' 		=> '{{WRAPPER}} .info-box3 h3',
			]
		);

		$this->add_control(
			'address_color',
			[
				'label' 		=> __( 'Address Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .info-box3 p' => 'color: {{VALUE}}!important',
				],
				'separator'		=> 'before'
			]
		);

		$this->add_control(
			'info_icon_color',
			[
				'label' 		=> __( 'Info Icon Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .icon-btn3 i' => 'color: {{VALUE}}!important',
				],
			]
		);

		$this->add_control(
			'info_head_color',
			[
				'label' 		=> __( 'Info Head Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .media-body h4' => 'color: {{VALUE}}!important',
				],
				'separator'		=> 'before'
			]
		);

		$this->add_control(
			'info_desc_color',
			[
				'label' 		=> __( 'Info Description Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .media-body a' => 'color: {{VALUE}}!important',
				],
				'separator'		=> 'before'
			]
		);

		$this->end_controls_section();

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        if( !empty( $settings['map_latitude'] ) || !empty( $settings['map_longitude'] ) ) {
            if( !empty( $settings['map_marker']['url'] ) ) {
                $map_marker_url = $settings['map_marker']['url'];
            } else {
                $map_marker_url = '';
            }
			echo '<div class="position-relative">';
	            echo '<!-- Start Map -->';
				echo '<div class="map-wrap">';
		            echo '<div class="google-map" id="google-map" class="map" data-marker="'.esc_url( $map_marker_url ).'" data-latitude="'.esc_attr( $settings['map_latitude'] ).'" data-longitude="'.esc_attr( $settings['map_longitude'] ).'" data-zoom="'.esc_attr($settings['map_zoom']['size']).'" data-trigger="map">';
		            echo '</div>';
		        echo '</div>';
	            echo '<!-- End Map -->';
				echo '<div class="info-box3 bg-dark position-absolute start-0 bottom-0 px-40 py-40">';
					if( ! empty( $settings['service_center_name'] ) ){
						echo '<h3 class="h4 text-white text-normal mb-2">'.esc_html( $settings['service_center_name'] ).'</h3>';
					}
					if( ! empty( $settings['service_center_address'] ) ){
						echo '<p class="text-white"><i class="fas fa-map-marker-alt me-2"></i>'.esc_html( $settings['service_center_address'] ).'</p>';
					}

					$email 			= $settings['email_address'];
					$mobile 		= $settings['phone_number'];

					$replace 		= array(' ','-',' - ');
					$with 			= array('','','');
					$emailurl 		= str_replace( $replace, $with, $email );

					$mobileurl 	    = str_replace( $replace, $with, $mobile );

					echo '<div class="row mt-lg-4">';
						if( ! empty( $settings['phone_number_title'] && $settings['phone_number'] ) ){
							echo '<div class="col-sm-6 mb-10 mb-sm-0">';
								echo '<div class="d-flex">';
									echo '<span class="icon-btn3 me-3"><i class="fas fa-phone-alt"></i></span>';
									echo '<div class="media-body align-self-center">';
										if( ! empty( $settings['phone_number_title'] ) ){
											echo '<h4 class="h5 text-white font-theme text-normal mb-0">'.esc_html( $settings['phone_number_title'] ).'</h4>';
										}
										if( ! empty( $settings['phone_number'] ) ){
											echo '<a href="'.esc_attr( 'tel:'.$mobileurl ).'" class="text-white d-inline-block">'.esc_html( $mobile ).'</a>';
										}
									echo '</div>';
								echo '</div>';
							echo '</div>';
						}
						if( ! empty( $settings['email_address_title'] && $settings['email_address'] ) ){
							echo '<div class="col-sm-6">';
								echo '<div class="d-flex">';
									echo '<span class="icon-btn3 me-3"><i class="fal fa-envelope"></i></span>';
									echo '<div class="media-body align-self-center">';
										if( ! empty( $settings['email_address_title'] ) ){
											echo '<h4 class="h5 text-white font-theme text-normal mb-0">'.esc_html( $settings['email_address_title'] ).'</h4>';
										}
										if( ! empty( $settings['phone_number'] ) ){
											echo '<a href="'.esc_attr( 'mailto:'.$emailurl ).'" class="text-white d-inline-block">'.esc_html( $email ).'</a>';
										}
									echo '</div>';
								echo '</div>';
							echo '</div>';
						}
					echo '</div>';
				echo '</div>';
			echo '</div>';
        }

	}

}