<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
/**
 *
 * Live Stream Widget .
 *
 */
class Zocker_Live_Stream_Box extends Widget_Base{

	public function get_name() {
		return 'zockerlivestreambox';
	}

	public function get_title() {
		return __( 'Live Stream', 'zocker' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'zocker' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'livestreambox_section',
			[
				'label' 	=> __( 'Live Stream', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'section_title', [
				'label' 		=> __( 'Section Title', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Live Stream' , 'zocker' ),
				'label_block' 	=> true,
			]
        );

		$this->add_control(
			'stream_info', [
				'label' 		=> __( 'Stream Info', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( '12 Hour Ago' , 'zocker' ),
				'label_block' 	=> true,
			]
        );

		$this->add_control(
			'video_image',
			[
				'label' 		=> __( 'Image', 'zocker' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'video_url', [
				'label' 		=> __( 'Video Url?', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'https://www.youtube.com/watch?v=_sI_Ps7JSEk' , 'zocker' ),
				'label_block' 	=> true,
			]
        );

		$this->add_control(
			'player_image',
			[
				'label' 		=> __( 'Player Image', 'zocker' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'player_name', [
				'label' 		=> __( 'Player Name', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'David Smith' , 'zocker' ),
				'label_block' 	=> true,
			]
        );

		$this->add_control(
			'views_count', [
				'label' 		=> __( 'Views Count Text', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( '250k views' , 'zocker' ),
				'label_block' 	=> true,
			]
        );

		$this->add_control(
			'share_text', [
				'label' 		=> __( 'Share Text', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Share Stream:' , 'zocker' ),
				'label_block' 	=> true,
			]
        );

		$this->end_controls_section();

		$this->start_controls_section(
			'general_style_section',
			[
				'label' 	=> __( 'General Style', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

		$this->add_control(
			'stream_info_color',
			[
				'label' 		=> __( 'Stream Info Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .hover-shape span' => 'color: {{VALUE}}',
                ],
			]
        );

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'stream_info_typography',
				'label' 	=> __( 'Stream Info Typography', 'zocker' ),
                'selector' 	=> '{{WRAPPER}} .hover-shape span',
			]
        );

		$this->add_control(
			'player_name_color',
			[
				'label' 		=> __( 'Player Name Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .media-body .name' => 'color: {{VALUE}}!important',
                ],
				'separator'		=> 'before',
			]
        );

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'player_name_typography',
				'label' 	=> __( 'Player Name Typography', 'zocker' ),
                'selector' 	=> '{{WRAPPER}} .media-body .name',
			]
        );

		$this->add_control(
			'views_count_color',
			[
				'label' 		=> __( 'Views Count Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .media-body span' => 'color: {{VALUE}}!important',
                ],
				'separator'		=> 'before',
			]
        );

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'views_count_typography',
				'label' 	=> __( 'Views Count Typography', 'zocker' ),
                'selector' 	=> '{{WRAPPER}} .media-body span',
			]
        );

		$this->add_control(
			'social_icon_color',
			[
				'label' 		=> __( 'Social Icon Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .icon-btn3.size-40 i' => 'color: {{VALUE}}!important',
                ],
				'separator'		=> 'before',
			]
        );

		$this->end_controls_section();

		$this->start_controls_section(
			'section_title_style_section',
			[
				'label' 	=> __( 'Section Title Style', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'section_title_color',
			[
				'label' 		=> __( 'Section Title Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .vs-box1 h4' => 'color: {{VALUE}}',
                ],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'section_title_typography',
				'label' 	=> __( 'Section Title Typography', 'zocker' ),
                'selector' 	=> '{{WRAPPER}} .vs-box1 h4',
			]
        );

        $this->add_responsive_control(
			'section_title_margin',
			[
				'label' 		=> __( 'Section Title Margin', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .vs-box1 h4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'section_title_padding',
			[
				'label' 		=> __( 'Section Title Padding', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .vs-box1 h4' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

		$this->end_controls_section();

	}

	protected function render() {

		$settings = $this->get_settings_for_display();

		echo '<div class="vs-box1 mb-30">';
			if( ! empty( $settings['section_title'] ) ){
				echo '<h4 class="h5 mb-25 mt-n1">'.esc_html( $settings['section_title'] ).'</h4>';
			}
			echo '<div class="hover-shape position-relative">';
				if( ! empty( $settings['stream_info'] ) ){
					echo '<span class="bg-gradient  text-white post-time d-none d-sm-inline-block">'.esc_html( $settings['stream_info'] ).'</span>';
				}
				if( ! empty( $settings['video_image']['url'] ) ){
					echo playrex_img_tag( array(
						'url'	=> esc_url( $settings['video_image']['url'] ),
						'class' => 'w-100'
					) );
				}
				if( ! empty( $settings['video_url'] ) ){
					echo '<a href="'.esc_url( $settings['video_url'] ).'" class="play-btn position-center popup-video"><i class="fas fa-play"></i></a>';
				}
			echo '</div>';
			echo '<div class="row mt-20 mt-lg-30 flex-row-reverse">';
				echo '<div class="col-md-7 mb-15 mb-md-0 text-md-end">';
					if( function_exists( 'zocker_social_sharing_buttons_for_player_details' ) ){
						if( ! empty( $settings['share_text'] ) ){
							echo '<strong class="text-title fs-18 mb-2 mb-md-0 me-md-2 d-md-inline-block d-block">'.esc_html( $settings['share_text'] ).'</strong>';
						}
						echo '<div class="d-inline-flex gap-2">';
							echo zocker_social_sharing_buttons_for_player_details();
						echo '</div>';
					}
				echo '</div>';
				echo '<div class="col-md-5">';
					echo '<div class="author-box d-flex">';
						if( ! empty( $settings['player_image']['url'] ) ){
							echo playrex_img_tag( array(
								'url'	=> esc_url( $settings['player_image']['url'] ),
							) );
						}
						echo '<div class="media-body align-self-center">';
							if( ! empty( $settings['player_name'] ) ){
								echo '<h6 class="name mb-0 text-normal lh-base">'.esc_html( $settings['player_name'] ).'</h6>';
							}
							if( ! empty( $settings['views_count'] ) ){
								echo '<span class="fs-xs">'.esc_html( $settings['views_count'] ).'</span>';
							}
						echo '</div>';
					echo '</div>';
				echo '</div>';
			echo '</div>';
		echo '</div>';
	}

}