<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
/**
 *
 * Blog Post Widget .
 *
 */
class Zocker_Most_Viewed_Blog extends Widget_Base {

	public function get_name() {
		return 'zockermostviewedblog';
	}

	public function get_title() {
		return __( 'Most Viewed Blog', 'zocker' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'zocker' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'blog_post_section',
			[
				'label' 	=> __( 'Most Viewed Blog', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
			'blog_post_count',
			[
				'label' 	=> __( 'No of Post to show', 'zocker' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( '4', 'zocker' ),
			]
        );

		$this->add_control(
			'title_count',
			[
				'label' 	=> __( 'Title Length', 'zocker' ),
				'type' 		=> Controls_Manager::TEXT,
				'default'  	=> __( '4', 'zocker' ),
			]
		);

        $this->end_controls_section();

		$this->start_controls_section(
			'general_style',
			[
				'label' 	=> __( 'General', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'box_bg_color',
			[
				'label' 		=> __( 'Box Background Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .vs-blog' => 'background-color: {{VALUE}}!important',
				],
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'category_style',
			[
				'label' 	=> __( 'Category', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'category_color',
			[
				'label' 		=> __( 'Category Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .blog-category a' => 'color: {{VALUE}}!important',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'category_typography',
				'label' 	=> __( 'Category Typography', 'zocker' ),
				'selector' 	=> '{{WRAPPER}} .blog-category a',
			]
		);
		$this->end_controls_section();

        $this->start_controls_section(
			'post_title_style_section',
			[
				'label' 	=> __( 'Title', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'post_title_color',
			[
				'label' 		=> __( 'Title Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .vs-blog .blog-title.h5' => 'color: {{VALUE}} !important',
				],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'post_title_typography',
				'label' 	=> __( 'Title Typography', 'zocker' ),
				'selector' 	=> '{{WRAPPER}} .vs-blog .blog-title.h5',
			]
        );

        $this->add_responsive_control(
			'post_title_margin',
			[
				'label' 		=> __( 'Title Margin', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .vs-blog .blog-title.h5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'post_title_padding',
			[
				'label' 		=> __( 'Title Padding', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .vs-blog .blog-title.h5' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

        $this->end_controls_section();

		$this->start_controls_section(
			'meta_style',
			[
				'label' 	=> __( 'Meta', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'meta_color',
			[
				'label' 		=> __( 'Meta Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .blog-meta a' => 'color: {{VALUE}}!important',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'meta_typography',
				'label' 	=> __( 'Meta Typography', 'zocker' ),
				'selector' 	=> '{{WRAPPER}} .blog-meta a',
			]
		);
		$this->end_controls_section();

    }


	protected function render() {

        $settings = $this->get_settings_for_display();

		$args = array(
			"post_type"             => "post",
			"posts_per_page"        => esc_attr( $settings['blog_post_count'] ),
			"post_status"           => "publish",
			"meta_key"              => "post_views_count",
			"orderby"               => "meta_value_num",
			"ignore_sticky_posts"   => true
		);

        $mostviews = new WP_Query( $args );

		if( $mostviews->have_posts() ) {
			echo '<!-- blog Area -->';
			echo '<div class="blog-demo-layout1 multibg-color-cat">';
				while( $mostviews->have_posts() ) {
					$mostviews->the_post();
					echo '<div class="vs-blog bg-major-black mb-20">';
						echo '<div class="row gx-xl-4">';
							echo '<div class="col-md-6">';
								if( has_post_thumbnail( ) ){
									echo '<div class="blog-image">';
									echo '<a href="'.esc_url( get_permalink() ).'">';
										the_post_thumbnail( 'home-slider-blog-image-six', array( 'class' => 'w-100' ) );
									echo '</a>';
									echo '</div>';
								}
							echo '</div>';
							echo '<div class="col-md-6 align-self-center">';
								echo '<div class="blog-conent pt-25 pb-20 px-30 px-md-0 pe-xl-5">';
									echo '<div class="blog-category mb-1">';
										$category = get_the_category();
										if( $category && ! empty( $category ) ){
											echo '<a href="'.esc_url( get_term_link( $category[0]->term_id ) ).'">'.esc_html( $category[0]->name ).'</a>';
										}
									echo '</div>';
									if( get_the_title() ){
										echo '<h3 class="blog-title text-white font-theme h5"><a href="'.esc_url( get_permalink() ).'">'.esc_html( wp_trim_words( get_the_title( ), $settings['title_count'], '' ) ).'</a></h3>';
									}
									echo '<div class="blog-meta text-light fs-xs">';
										echo '<a href="'.esc_url( playrex_blog_date_permalink() ).'"><i class="fal fa-calendar-alt"></i>';
											echo '<time datetime="'.esc_attr( get_the_date( DATE_W3C ) ).'">'.esc_html( get_the_date() ).'</time>';
										echo '</a>';
										echo '<a href="'.esc_url( get_author_posts_url( get_the_author_meta('ID') ) ).'"><i class="fal fa-user"></i>'.esc_html( ucwords( get_the_author() ) ).'</a>';
									echo '</div>';
								echo '</div>';
							echo '</div>';
						echo '</div>';
					echo '</div>';
				}
				wp_reset_postdata();
			echo '</div>';
			echo '<!-- blog Area end -->';
		}
	}
}