<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
/**
 *
 * Player Info Widget .
 *
 */
class Zocker_Player_Info extends Widget_Base {

	public function get_name() {
		return 'zockerplayerinfo';
	}

	public function get_title() {
		return __( 'Player Info', 'zocker' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'zocker' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'player_info_section',
			[
				'label' 	=> __( 'Player Info', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'player_image',
			[
				'label' 	=> __( 'Player Image', 'zocker' ),
				'type' 		=> Controls_Manager::MEDIA,
				'default' => [
					'url' 	=> Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'player_tag_text',
			[
				'label' 		=> __( 'Player Tag Text', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Pro', 'zocker' ),
				'placeholder' 	=> __( 'Type player description here', 'zocker' ),
			]
		);

		$this->add_control(
			'player_description',
			[
				'label' 		=> __( 'Player Description', 'zocker' ),
				'type' 			=> Controls_Manager::WYSIWYG,
				'default' 		=> __( 'Default description', 'zocker' ),
				'placeholder' 	=> __( 'Type player description here', 'zocker' ),
			]
		);

        $this->end_controls_section();

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		echo '<div class="vs-box1 d-md-flex mb-30 info-box4 align-items-center">';
			if( ! empty( $settings['player_tag_text'] ) ){
				echo '<div class="pro-tag position-absolute end-0 top-0 bg-gradient text-white">';
					echo '<i class="fas fa-check-circle"></i>';
					echo esc_html( $settings['player_tag_text'] );
				echo '</div>';
			}
			if( ! empty( $settings['player_image']['url'] ) ){
				echo '<div class="inner-img1">';
					echo playrex_img_tag( array(
						'url'	=> esc_url( $settings['player_image']['url'] ),
					) );
				echo '</div>';
			}
			echo '<div class="media-body ml-lg-30">';
				echo wp_kses_post( $settings['player_description'] );
			echo '</div>';
		echo '</div>';

	}
}