<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
/**
 *
 * Player Rank Tab Widget .
 *
 */
class Zocker_Player_Rank_Tab extends Widget_Base{

	public function get_name() {
		return 'zockerplayerranktab';
	}

	public function get_title() {
		return __( 'Player Rank Tab', 'zocker' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'zocker' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'player_rank_tab_section',
			[
				'label' 	=> __( 'Player Rank Tab', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'first_tab_text', [
				'label' 		=> __( 'First Tab Text', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Games' , 'zocker' ),
				'label_block' 	=> true,
			]
        );

		$repeater = new Repeater();

		$repeater->add_control(
			'game_image', [
				'label' 		=> __( 'Game Image', 'zocker' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
        );

		$repeater->add_control(
			'game_name', [
				'label' 		=> __( 'Game Name', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'ANGRY POWER' , 'zocker' ),
				'label_block' 	=> true,
			]
        );

		$repeater->add_control(
			'game_rank', [
				'label' 		=> __( 'Game Rank', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( '17th Rank' , 'zocker' ),
				'label_block' 	=> true,
			]
        );

		$repeater->add_control(
			'wins_width',
			[
				'label' 		=> __( 'Wins Width', 'zocker' ),
				'type' 			=> Controls_Manager::SLIDER,
				'size_units' 	=> [ '%' ],
				'range' 		=> [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 55,
				],
			]
		);

		$repeater->add_control(
			'draws_width',
			[
				'label' 		=> __( 'Draws Width', 'zocker' ),
				'type' 			=> Controls_Manager::SLIDER,
				'size_units' 	=> [ '%' ],
				'range' 		=> [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 15,
				],
			]
		);

		$repeater->add_control(
			'lose_width',
			[
				'label' 		=> __( 'Lose Width', 'zocker' ),
				'type' 			=> Controls_Manager::SLIDER,
				'size_units' 	=> [ '%' ],
				'range' 		=> [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 30,
				],
			]
		);

		$repeater->add_control(
			'wins_text', [
				'label' 		=> __( 'Win Text', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'WINS 55%' , 'zocker' ),
				'label_block' 	=> true,
			]
        );

		$repeater->add_control(
			'draws_text', [
				'label' 		=> __( 'Draws Text', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'DRAWS 15%' , 'zocker' ),
				'label_block' 	=> true,
			]
        );

		$repeater->add_control(
			'lose_text', [
				'label' 		=> __( 'Lose Text', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'LOSSES 30%' , 'zocker' ),
				'label_block' 	=> true,
			]
        );

		$this->add_control(
			'slides',
			[
				'label' 		=> __( 'First Tab Content', 'zocker' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'game_name' 		=> __( 'ANGRY POWER', 'zocker' ),
					],
					[
						'game_name' 		=> __( 'DRIVE WORLD', 'zocker' ),
					],
				],
				'title_field' 	=> '{{{ game_name }}}',
			]
		);

		$this->add_control(
			'second_tab_text', [
				'label' 		=> __( 'Second Tab Text', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'TWITCH' , 'zocker' ),
				'label_block' 	=> true,
			]
        );

		$twitch_repeater = new Repeater();

		$twitch_repeater->add_control(
			'video_thumb_image', [
				'label' 		=> __( 'Video Thumb Image', 'zocker' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
        );

		$twitch_repeater->add_control(
			'streaming_url', [
				'label' 		=> __( 'Streaming Url?', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'https://www.youtube.com/watch?v=_sI_Ps7JSEk' , 'zocker' ),
				'label_block' 	=> true,
			]
        );

		$twitch_repeater->add_control(
			'twitch_game_name', [
				'label' 		=> __( 'Game Name', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Pubg', 'zocker' ),
				'label_block' 	=> true,
			]
        );

		$twitch_repeater->add_control(
			'two_team_name', [
				'label' 		=> __( 'Two Team Name?', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'uniqueG VS Plumber', 'zocker' ),
				'label_block' 	=> true,
			]
        );

		$twitch_repeater->add_control(
			'views_count_text', [
				'label' 		=> __( 'Views Count Text', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( '389k Views', 'zocker' ),
				'label_block' 	=> true,
			]
        );

		$this->add_control(
			'twitch_info_slides',
			[
				'label' 		=> __( 'Stream Info Slide', 'zocker' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $twitch_repeater->get_controls(),
				'default' 		=> [
					[
						'streaming_url' 		=> __( 'https://www.youtube.com/watch?v=_sI_Ps7JSEk', 'zocker' ),
						'two_team_name' 		=> __( 'uniqueG VS Plumber', 'zocker' ),
					],
					[
						'streaming_url' 		=> __( 'https://www.youtube.com/watch?v=_sI_Ps7JSEk', 'zocker' ),
						'two_team_name' 		=> __( 'uniqueG VS Plumber', 'zocker' ),
					],
					[
						'streaming_url' 		=> __( 'https://www.youtube.com/watch?v=_sI_Ps7JSEk', 'zocker' ),
						'two_team_name' 		=> __( 'uniqueG VS Plumber', 'zocker' ),
					],
					[
						'streaming_url' 		=> __( 'https://www.youtube.com/watch?v=_sI_Ps7JSEk', 'zocker' ),
						'two_team_name' 		=> __( 'uniqueG VS Plumber', 'zocker' ),
					],
					[
						'streaming_url' 		=> __( 'https://www.youtube.com/watch?v=_sI_Ps7JSEk', 'zocker' ),
						'two_team_name' 		=> __( 'uniqueG VS Plumber', 'zocker' ),
					],
					[
						'streaming_url' 		=> __( 'https://www.youtube.com/watch?v=_sI_Ps7JSEk', 'zocker' ),
						'two_team_name' 		=> __( 'uniqueG VS Plumber', 'zocker' ),
					],
				],
				'title_field' 	=> '{{{ two_team_name }}}',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'tab_style_section',
			[
				'label' 	=> __( 'Tab Style', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

		$this->add_control(
			'tab_bg_color',
			[
				'label' 		=> __( 'Tab Background Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .tab-menu1 .indicator:after' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'tab_color',
			[
				'label' 		=> __( 'Tab Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .tab-menu1 a' => 'color: {{VALUE}}',
				],
			]
        );

        $this->add_control(
			'tab_color_hover',
			[
				'label' 		=> __( 'Tab Color Hover', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .tab-menu1 a:hover' => 'color: {{VALUE}}',
				],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'tab_typography',
				'label' 	=> __( 'Tab Typography', 'zocker' ),
				'selector' 	=> '{{WRAPPER}} .tab-menu1 a',
			]
        );

        $this->add_responsive_control(
			'tab_margin',
			[
				'label' 		=> __( 'Tab Margin', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .tab-menu1 a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'tab_padding',
			[
				'label' 		=> __( 'Tab Padding', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .tab-menu1 a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

        $this->end_controls_section();

		$this->start_controls_section(
			'game_tab_style',
			[
				'label' 	=> __( 'Game Tab Style', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

		$this->add_control(
			'game_text_color',
			[
				'label' 		=> __( 'Game Text Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .media-body h5' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'game_rank_text_color',
			[
				'label' 		=> __( 'Game Rank Text Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .media-body span' => 'color: {{VALUE}}!important',
				],
			]
		);
		$this->add_control(
			'wins_color',
			[
				'label' 		=> __( 'Wins Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .bar-list .wins,{{WRAPPER}} .progress.style1 .wins' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'draws_color',
			[
				'label' 		=> __( 'Draws Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .bar-list .draws,{{WRAPPER}} .progress.style1 .draws' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'lose_color',
			[
				'label' 		=> __( 'Lose Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .bar-list .losses,{{WRAPPER}} .progress.style1 .losses' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'bar_list_text_color',
			[
				'label' 		=> __( 'Bar List Text Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .bar-list li' => 'color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'streaming_info_section',
			[
				'label' 	=> __( 'Streaming Info Style', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

		$this->add_control(
			'video_icon_color',
			[
				'label' 		=> __( 'Video Icon Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .team-video-thumb .play-btn i' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'game_name_color',
			[
				'label' 		=> __( 'Game Text Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .team-video-thumb .tag' => 'color: {{VALUE}}',
				],
			]
        );

        $this->add_control(
			'team_text_color',
			[
				'label' 		=> __( 'Team Text Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .team-video-thumb .thumb-title' => 'color: {{VALUE}}',
				],
			]
        );

        $this->add_control(
			'views_count_text_color',
			[
				'label' 		=> __( 'Views Count Text Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .team-video-thumb .total-views' => 'color: {{VALUE}}',
				],
			]
        );

        $this->end_controls_section();
	}


	protected function render() {

		$settings = $this->get_settings_for_display();

		echo '<!-- Skill Area -->';
		echo '<div class="vs-box1 p-0 mb-30">';
			echo '<div class="nav  tab-menu1 tab-indicator justify-content-center justify-content-sm-start" role="tablist">';
				if( ! empty( $settings['first_tab_text'] ) ){
					echo '<a class="nav-link active" id="skill1-tab" data-bs-toggle="tab" href="#skill1" role="tab" aria-controls="skill1" aria-selected="true">'.esc_html( $settings['first_tab_text'] ).'</a>';
				}
				if( ! empty( $settings['second_tab_text'] ) ){
					echo '<a class="nav-link" id="skill3-tab" data-bs-toggle="tab" href="#skill3" role="tab" aria-controls="skill3" aria-selected="false">'.esc_html( $settings['second_tab_text'] ).'</a>';
				}
			echo '</div>';
			echo '<div class="tab-content mt-30">';
				if( ! empty( $settings['slides'] ) ){
					echo '<div class="tab-pane show active" id="skill1" role="tabpanel" aria-labelledby="skill1-tab">';
						foreach( $settings['slides'] as $data ){
							echo '<div class="skill-box1 d-sm-flex px-30 pb-30 text-center text-sm-start">';
								if( ! empty( $data['game_image']['url'] ) ){
									echo '<div class="media-img position-relative">';
										echo playrex_img_tag( array(
											'url'	=> esc_url( $data['game_image']['url'] ),
										) );
									echo '</div>';
								}
								echo '<div class="media-body align-self-center ml-lg-30">';
									if( ! empty( $data['game_name'] ) ){
										echo '<h5 class="fs-20 mb-0 font-theme">'.esc_html( $data['game_name'] ).'</h5>';
									}
									if( ! empty( $data['game_rank'] ) ){
										echo '<span class="text-theme2 fs-xs">'.esc_html( $data['game_rank'] ).'</span>';
									}
									echo '<div class="progress style1 mt-10">';
										if( ! empty( $data['wins_width']['size'] ) ){
											echo '<div class="progress-bar wins" role="progressbar" style="width: '.esc_attr( $data['wins_width']['size'] ).'%;" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>';
										}
										if( ! empty( $data['draws_width']['size'] ) ){
											echo '<div class="progress-bar draws" role="progressbar" style="width: '.esc_attr( $data['draws_width']['size'] ).'%;" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>';
										}
										if( ! empty( $data['lose_width']['size'] ) ){
											echo '<div class="progress-bar losses" role="progressbar" style="width: '.esc_attr( $data['lose_width']['size'] ).'%;" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>';
										}
									echo '</div>';
									echo '<ul class="bar-list list-style-none small">';
										if( ! empty( $data['wins_text'] ) ){
											echo '<li>';
												echo '<span class="dot wins"></span>';
												echo esc_html( $data['wins_text'] );
											echo '</li>';
										}
										if( ! empty( $data['draws_text'] ) ){
											echo '<li>';
												echo '<span class="dot draws"></span>';
												echo esc_html( $data['draws_text'] );
											echo '</li>';
										}
										if( ! empty( $data['lose_text'] ) ){
											echo '<li>';
												echo '<span class="dot losses"></span>';
												echo esc_html( $data['lose_text'] );
											echo '</li>';
										}
									echo '</ul>';
								echo '</div>';
							echo '</div>';
						}
					echo '</div>';
				}
				if( ! empty( $settings['twitch_info_slides'] ) ){
					echo '<div class="tab-pane" id="skill3" role="tabpanel" aria-labelledby="skill3-tab">';
						echo '<!-- Team Video Area -->';
						echo '<div class="team-video-area px-30">';
							echo '<div class="row">';
								foreach( $settings['twitch_info_slides'] as $twitch_data ){
									echo '<div class="col-sm-6 col-xl-4">';
										echo '<div class="team-video-thumb">';
											echo '<div class="thumb-img">';
												if( ! empty( $twitch_data['video_thumb_image']['url'] ) ){
													echo playrex_img_tag( array(
														'url'	=> esc_url( $twitch_data['video_thumb_image']['url'] ),
													) );
												}
												if( ! empty( $twitch_data['twitch_game_name'] ) ){
													echo '<div class="tag">'.esc_html( $twitch_data['twitch_game_name'] ).'</div>';
												}
												if( ! empty( $twitch_data['streaming_url'] ) ){
													echo '<a href="'.esc_url( $twitch_data['streaming_url'] ).'" class="play-btn popup-video"><i class="fas fa-play"></i></a>';
												}
											echo '</div>';
											echo '<div class="thumb-content">';
												if( ! empty( $twitch_data['two_team_name'] ) ){
													echo '<h5 class="thumb-title">'.esc_html( $twitch_data['two_team_name'] ).'</h5>';
												}
												if( ! empty( $twitch_data['views_count_text'] ) ){
													echo '<span class="total-views">'.esc_html( $twitch_data['views_count_text'] ).'</span>';
												}
											echo '</div>';
										echo '</div>';
									echo '</div>';
								}
							echo '</div>';
						echo '</div>';
					echo '</div>';
				}
			echo '</div>';
		echo '</div> <!-- Video Area -->';
	}

}