<?php
    use \Elementor\Widget_Base;
    use \Elementor\Controls_Manager;
    use \Elementor\Group_Control_Typography;
    use \Elementor\Group_Control_Background;
    use \Elementor\Group_Control_Text_Shadow;
    use \Elementor\Group_Control_Box_Shadow;
    use \Elementor\Group_Control_Border;
    use \Elementor\Utils;
    /**
     *
     * Player Widget .
     *
     */
class Zocker_Player extends Widget_Base {

	public function get_name() {
		return 'zockerplayer';
	}

	public function get_title() {
		return __( 'Players', 'zocker' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'zocker' ];
	}

	// Add The Input For User
	protected function register_controls(){
		$this->start_controls_section(
			'players_content',
			[
				'label'		=> __( 'Player Content','zocker' ),
				'tab'		=> Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'player_style',
			[
				'label' 	=> __( 'Player Style', 'zocker' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  	    => __( 'Slider', 'zocker' ),
					'2'  		=> __( 'Grid', 'zocker' ),
				],
			]
		);
		$this->add_control(
			'slider_style',
			[
				'label' 	=> __( 'Slider Style', 'zocker' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  		=> __( 'Style One', 'zocker' ),
					'2'  		=> __( 'Style Two', 'zocker' ),
				],
				'condition'		=> [ 'player_style' => '1' ]
			]
		);
		$this->add_control(
			'section_title',
			[
				'label' 		=> __( 'Section Title', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'placeholder'	=> __( 'Write Section Title', 'zocker' ),
				'condition'		=> [ 'slider_style' => '2' ],
			]
		);
		$this->add_control(
			'player_column',
			[
				'label' 	=> __( 'Player Column', 'zocker' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> 'three',
				'options' 	=> [
					'full'  	=> __( 'Full Width', 'zocker' ),
					'two'  		=> __( 'Two Column', 'zocker' ),
					'three' 	=> __( 'Three Column', 'zocker' ),
					'four' 		=> __( 'Four Column', 'zocker' ),
					'six' 		=> __( 'Six Column', 'zocker' ),
				],
				'condition'		=> [ 'player_style' => '2' ]
			]
		);
		$this->add_control(
			'post_from',
			[
				'label' 		=> __( 'Post From', 'zocker' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'all',
				'options' 		=> [
					'all'  			=> __( 'All', 'zocker' ),
					'categories' 	=> __( 'Categories', 'zocker' ),
				],
			]
		);
		$this->add_control(
			'categories',
			[
				'label' 		=> __( 'Post From', 'zocker' ),
				'type' 			=> Controls_Manager::SELECT,
				'options' 		=> zocker_players_category(),
				'condition' 	=> ['post_from' => 'categories'],
			]
		);
		$this->add_control(
			'post_limit',
			[
				'label' 		=> __( 'Post Limit', 'zocker' ),
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> __( 'Only Number Work. Like 4 or 6', 'zocker' ),
			]
		);
		$this->add_control(
			'order',
			[
				'label' 		=> __( 'Order', 'zocker' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'ASC',
				'options' 		=> [
					'ASC'  			=> __( 'Ascending', 'zocker' ),
					'DESC' 			=> __( 'Descending', 'zocker' ),
				],
			]
		);
		$this->add_control(
			'order_by',
			[
				'label' 		=> __( 'Order By', 'zocker' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'name',
				'options' 		=> [
					'none'  		=> __( 'None', 'zocker' ),
					'type' 			=> __( 'Type', 'zocker' ),
					'title' 		=> __( 'Title', 'zocker' ),
					'name' 			=> __( 'Name', 'zocker' ),
					'name' 			=> __( 'Name', 'zocker' ),
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'slider_control_section',
			[
				'label' 		=> __( 'Slider Control', 'zocker' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
			'desktop_items',
			[
				'label' 		=> __( 'Desktop Items', 'zocker' ),
				'type' 			=> Controls_Manager::SLIDER,
				'size_units' 	=> [ '%' ],
				'range' 		=> [
					'%' 	=> [
						'min' 	=> 0,
						'step' 	=> 1,
						'max' 	=> 10,
					],
				],
				'default' 	=> [
					'unit' 		=> '%',
					'size' 		=> 2,
				],
			]
		);

		$this->add_control(
			'slider_autoplay',
			[
				'label' 		=> __( 'Autoplay', 'zocker' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'zocker' ),
				'label_off' 	=> __( 'No', 'zocker' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);

		$this->add_control(
			'slider_arrows',
			[
				'label' 		=> __( 'Arrows', 'zocker' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'zocker' ),
				'label_off' 	=> __( 'No', 'zocker' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'player_design_style',
            [
                'label'			=> __( 'Style','zocker' ),
                'tab' 			=> Controls_Manager::TAB_STYLE,
            ]
        );
		$this->add_control(
			'name_color',
			[
				'label' 		=> __( 'Name Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .member-name' => 'color: {{VALUE}} !important',
				],
			]
		);
		$this->add_control(
			'name_hover_color',
			[
				'label' 		=> __( 'Name Hover Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .member-name a:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'player_name_typography',
				'label' 		=> __( 'Player Name Typography', 'zocker' ),
                'selector' 	    => '{{WRAPPER}} .member-name',
			]
		);
		$this->add_control(
			'player_designation_color',
			[
				'label' 		=> __( 'Player Designation Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .degi' => 'color: {{VALUE}}!important',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'player_designation_typography',
				'label' 		=> __( 'Player Designation Typography', 'zocker' ),
                'selector' 	    => '{{WRAPPER}} .degi',
			]
		);
		$this->add_control(
			'social_icon_color',
			[
				'label' 		=> __( 'Social Icon Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .icon-btn3 i' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();


	}

	// Output For User
	protected function render(){
		$settings = $this->get_settings_for_display();

        if( $settings['player_column'] == 'two' ){
            $this->add_render_attribute( 'column','class','col-sm-8 col-md-6 col-lg-4 col-xl-6');
        }elseif( $settings['player_column'] == 'three' ){
            $this->add_render_attribute( 'column','class','col-sm-8 col-md-6 col-lg-4 col-xl-4');
        }elseif( $settings['player_column'] == 'four' ){
            $this->add_render_attribute( 'column','class','col-sm-8 col-md-6 col-lg-4 col-xl-3');
        }elseif( $settings['player_column'] == 'full' ){
            $this->add_render_attribute( 'column','class','col-sm-8 col-md-6 col-lg-4 col-xl-12');
        }else{
            $this->add_render_attribute( 'column','class','col-sm-8 col-md-6 col-lg-4 col-xl-2');
        }

        $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;

		echo '<!-- player style one -->';
			if( $settings['post_from'] == "categories" ){
			   $player = array(
				   'post_type'         => 'zocker_player',
				   'posts_per_page'    => esc_attr( $settings['post_limit'] ),
				   'order'             => esc_attr( $settings['order'] ),
				   'orderby'           => esc_attr( $settings['order_by'] ),
				   'tax_query'         => array(
						    array(
							   'taxonomy'  => 'player_category',
							   'field'     => 'slug',
							   'terms'     => esc_attr( $settings['categories'] ),
						    )
					),
                    'paged'             => $paged,
			   );
		    }else{
				$player = array(
				   'post_type'         => 'zocker_player',
				   'posts_per_page'    => esc_attr( $settings['post_limit'] ),
				   'order'             => esc_attr( $settings['order'] ),
				   'orderby'           => esc_attr( $settings['order_by'] ),
                   'paged'             => $paged,
			   );
		    }

		$zocker_player = new WP_Query( $player );

        $this->add_render_attribute( 'wrapper', 'data-slide-to-show', $settings['desktop_items']['size'] );

		if( $settings['slider_style'] == 1  ){
			$this->add_render_attribute( 'wrapper', 'class', 'row vs-carousel arrow-white' );
            $this->add_render_attribute( 'wrapper', 'data-lg-slide-to-show', '3' );
            $this->add_render_attribute( 'wrapper', 'data-md-slide-to-show', '2' );
            $this->add_render_attribute( 'wrapper', 'data-sm-slide-to-show', '1' );
		}else{
			$this->add_render_attribute( 'wrapper', 'class', 'row link-inherit vs-carousel' );
			$this->add_render_attribute( 'wrapper', 'id', 'memberslide3' );
            $this->add_render_attribute( 'wrapper', 'data-lg-slide-to-show', '3' );
            $this->add_render_attribute( 'wrapper', 'data-md-slide-to-show', '2' );
            $this->add_render_attribute( 'wrapper', 'data-sm-slide-to-show', '2' );
		}



		if( $settings['slider_autoplay'] == 'yes' ){
			$this->add_render_attribute( 'wrapper', 'data-autoplay', 'true' );
		}else{
			$this->add_render_attribute( 'wrapper', 'data-autoplay', 'false' );
		}
		if( $settings['slider_style'] == '1' ){
			if( $settings['slider_arrows'] == 'yes' ){
				$this->add_render_attribute( 'wrapper', 'data-slick-arrows', 'true' );
			}else{
				$this->add_render_attribute( 'wrapper', 'data-slick-arrows', 'false' );
			}
		}else{
			$this->add_render_attribute( 'wrapper', 'data-slick-arrows', 'false' );
		}
		if( $settings['player_style'] == '1' ){
    		if( $zocker_player->have_posts() ){
				if( $settings['slider_style'] == 1 ){
	    			echo '<section class="vs-member-area vs-member-layout1 arrow-wrap">';
	    				echo '<div class="container">';
	    					echo '<div '.$this->get_render_attribute_string('wrapper').'>';
	    						while( $zocker_player->have_posts() ):
	    							$zocker_player->the_post();
									echo '<div class="col-lg-3">';
					                    echo '<div class="vs-member">';
											if( has_post_thumbnail( ) ){
						                        echo '<div class="member-img">';
						                            echo '<a href="'.esc_url( get_permalink() ).'">';
														the_post_thumbnail( 'full', [ 'class' => 'w-100' ]  );
													echo '</a>';
						                        echo '</div>';
											}
					                        echo '<div class="member-content">';
												if( ! empty( playrex_meta( 'zocker_player_designation' ) ) ){
						                            echo '<span class="degi">'.esc_html( playrex_meta( 'zocker_player_designation' ) ).'</span>';
												}
					                            echo '<h3 class="member-name fs-20"><a href="'.esc_url( get_permalink() ).'">'.esc_html( get_the_title() ).'</a></h3>';
					                        echo '</div>';
					                    echo '</div>';
					                echo '</div>';
	    						endwhile;
	    						wp_reset_postdata();
	    					echo '</div><!-- .row END -->';
	    				echo '</div><!-- .container END -->';
	    			echo '</section>';
				}else{
					echo '<div class="vs-member mb-20-layout3">';
						echo '<div class="row">';
							echo '<div class="col-sm-6">';
								if( ! empty( $settings['section_title'] ) ){
									echo '<h3 class="h4">'.esc_html( $settings['section_title'] ).'</h3>';
								}
							echo '</div>';
							echo '<div class="col-sm-6 pt-2 text-end d-none d-sm-block">';
							if( $settings['slider_arrows'] == 'yes' ){
								echo '<button class="icon1 mr-10 text-theme-hover" type="button" data-slick-prev="#memberslide3"><i class="far fa-angle-left"></i></button>';
								echo '<button class="icon1 text-theme-hover" type="button" data-slick-next="#memberslide3"><i class="far fa-angle-right"></i></button>';
							}
							echo '</div>';
						echo '</div>';
						echo '<div '.$this->get_render_attribute_string('wrapper').'>';
							while( $zocker_player->have_posts() ):
								$zocker_player->the_post();
								echo '<div class="col-xl-3">';
									echo '<div class="vs-member mb-25">';
										if( has_post_thumbnail( ) ){
											echo '<div class="member-img image-scale-hover mb-15">';
												echo '<a href="'.esc_url( get_permalink() ).'">';
													the_post_thumbnail( 'player-details-image-size' );
												echo '</a>';
											echo '</div>';
										}
										if( get_the_title() ){
											echo '<h4 class="member-name font-theme mb-0 text-normal h5"><a href="'.esc_url( get_permalink() ).'">'.esc_html( get_the_title() ).'</a></h4>';
										}
										if( ! empty( playrex_meta( 'zocker_player_designation' ) ) ){
				                            echo '<span class="degi fs-xs">'.esc_html( playrex_meta( 'zocker_player_designation' ) ).'</span>';
										}
									echo '</div>';
								echo '</div>';
							endwhile;
							wp_reset_postdata();
						echo '</div>';
					echo '</div> <!-- Skill Area -->';
				}
    		}
        }else{
            if( $zocker_player->have_posts() ){
				echo '<section class="vs-member-area vs-member-layout2">';
			        echo '<div class="container">';
			            echo '<div class="row justify-content-center">';
							while( $zocker_player->have_posts() ):
								$zocker_player->the_post();
				                echo '<div '.$this->get_render_attribute_string('column').'>';
				                    echo '<div class="vs-member image-scale-hover">';
										if( has_post_thumbnail( ) ){
					                        echo '<div class="member-img">';
					                            echo '<a href="'.esc_url( get_permalink() ).'">';
													the_post_thumbnail( 'full', array( 'class' => 'w-100' ) );
												echo '</a>';
					                        echo '</div>';
										}
				                        echo '<div class="member-content">';
				                            echo '<div class="links-wrap text-start position-relative mb-30">';
											$social_link = get_post_meta( get_the_ID(), '_zocker_player_social_group', true );
												if( ! empty( $social_link ) ){
					                                echo '<span class="icon-btn3 style-white plus-icon"><i class="far fa-plus text-white"></i></span>';
					                                echo '<div class="member-links">';
														foreach( $social_link as $single_icon ){
						                                    echo '<a href="'.esc_url( $single_icon['_zocker_player_social_profile_link'] ).'" class="icon-btn3"><i class="fab '.esc_attr( $single_icon['_zocker_player_social_profile_icon'] ).'"></i></a>';
														}
					                                echo '</div>';
												}
				                            echo '</div>';
											if( get_the_title() ){
					                            echo '<h3 class="member-name h5 mb-0 text-white"><a href="'.esc_url( get_permalink() ).'">'.esc_html( get_the_title() ).'</a></h3>';
											}
											if( ! empty( playrex_meta( 'zocker_player_designation' ) ) ){
					                            echo '<span class="degi text-white">'.esc_html( playrex_meta( 'zocker_player_designation' ) ).'</span>';
											}
				                        echo '</div>';
				                    echo '</div>';
				                echo '</div>';
							endwhile;
							wp_reset_postdata();
			            echo '</div>';

						$total_pages = $zocker_player->max_num_pages;
                        if ( $total_pages > 1 ){
				            echo '<div class="pagination-wrapper pagination-layout1 mt-lg-30 mb-30">';
								$current_page = max( 1, get_query_var( 'paged' ) );

								echo paginate_links(array(
									'base'          => get_pagenum_link(1) . '%_%',
									'format'        => '/page/%#%',
									'current'       => $current_page,
									'total'         => $total_pages,
									'prev_text'     => '<i class="fas fa-chevron-left"></i>',
									'next_text'     => '<i class="fas fa-chevron-right"></i>',
									'type'          => 'list',
								));
				            echo '</div>';
						}
			        echo '</div>';
			    echo '</section>';
            }
        }
	}
}