<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
/**
 *
 * Blog Post Widget .
 *
 */
class Zocker_Popular_News extends Widget_Base {

	public function get_name() {
		return 'zockerpopularnews';
	}

	public function get_title() {
		return __( 'Popular News', 'zocker' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'zocker' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'blog_post_section',
			[
				'label' 	=> __( 'Popular News', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
			'blog_post_count',
			[
				'label' 	=> __( 'No of Post to show', 'zocker' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( '4', 'zocker' ),
			]
        );

		$this->add_control(
			'title_count',
			[
				'label' 	=> __( 'Title Length', 'zocker' ),
				'type' 		=> Controls_Manager::TEXT,
				'default'  	=> __( '4', 'zocker' ),
			]
		);

		$this->add_control(
			'excerpt_count',
			[
				'label' 	=> __( 'Excerpt Length', 'zocker' ),
				'type' 		=> Controls_Manager::TEXT,
				'default'  	=> __( '35', 'zocker' ),
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
			'post_title_style_section',
			[
				'label' 	=> __( 'Title', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'post_title_color',
			[
				'label' 		=> __( 'Title Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .blog-title' => 'color: {{VALUE}} !important',
				],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'post_title_typography',
				'label' 	=> __( 'Title Typography', 'zocker' ),
				'selector' 	=> '{{WRAPPER}} .blog-title',
			]
        );

        $this->add_responsive_control(
			'post_title_margin',
			[
				'label' 		=> __( 'Title Margin', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .blog-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'post_title_padding',
			[
				'label' 		=> __( 'Title Padding', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .blog-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
			'post_excerpt_style_section',
			[
				'label' 	=> __( 'Title', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'post_excerpt_color',
			[
				'label' 		=> __( 'Excerpt Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} p.text-on-dark1' => 'color: {{VALUE}} !important',
				],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'post_excerpt_typography',
				'label' 	=> __( 'Excerpt Typography', 'zocker' ),
				'selector' 	=> '{{WRAPPER}} p.text-on-dark1',
			]
        );

        $this->add_responsive_control(
			'post_excerpt_margin',
			[
				'label' 		=> __( 'Excerpt Margin', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} p.text-on-dark1' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'post_excerpt_padding',
			[
				'label' 		=> __( 'Excerpt Padding', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} p.text-on-dark1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

        $this->end_controls_section();

		$this->start_controls_section(
			'meta_style',
			[
				'label' 	=> __( 'Meta', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'meta_color',
			[
				'label' 		=> __( 'Meta Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .blog-meta a' => 'color: {{VALUE}}!important',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'meta_typography',
				'label' 	=> __( 'Meta Typography', 'zocker' ),
				'selector' 	=> '{{WRAPPER}} .blog-meta a',
			]
		);
		$this->end_controls_section();

    }


	protected function render() {

        $settings = $this->get_settings_for_display();

		$args = array(
			"post_type"             => "post",
			"posts_per_page"        => esc_attr( $settings['blog_post_count'] ),
			"post_status"           => "publish",
			"orderby"               => "comment_count",
			"ignore_sticky_posts"   => true
		);

        $mostviews = new WP_Query( $args );

		if( $mostviews->have_posts() ) {
			echo '<!-- blog Area -->';
			echo '<div class="vs-popular-news blog-demo-layout2">';
				echo '<div class="container">';
					echo '<div class="row">';
						while( $mostviews->have_posts() ) {
							$mostviews->the_post();
							echo '<div class="vs-blog d-md-flex gap-4 mb-20">';
								if( has_post_thumbnail( ) ){
			                        echo '<div class="media-img mb-10 mb-md-0">';
			                            echo '<a href="'.esc_url( get_permalink() ).'">';
											the_post_thumbnail( 'home-slider-blog-image-eight', array( 'class' => 'w-100' ) );
										echo '</a>';
			                        echo '</div>';
								}
		                        echo '<div class="media-body align-self-center">';
		                            echo '<div class="blog-meta text-light fs-xs mb-1">';
										echo '<a href="'.esc_url( playrex_blog_date_permalink() ).'"><i class="fal fa-calendar-alt"></i>';
											echo '<time datetime="'.esc_attr( get_the_date( DATE_W3C ) ).'">'.esc_html( get_the_date() ).'</time>';
										echo '</a>';
										echo '<a href="'.esc_url( get_author_posts_url( get_the_author_meta('ID') ) ).'"><i class="fal fa-user"></i>'.esc_html( ucwords( get_the_author() ) ).'</a>';
		                            echo '</div>';
									if( get_the_title() ){
			                            echo '<h3 class="blog-title text-white font-theme fs-20-ls mb-2"><a href="'.esc_url( get_permalink() ).'">'.esc_html( wp_trim_words( get_the_title( ), $settings['title_count'], '' ) ).'</a></h3>';
									}
		                            echo '<p class="mb-0 text-on-dark1">'.wp_kses_post( wp_trim_words( get_the_content( ), $settings['excerpt_count'], '' ) ).'</p>';
		                        echo '</div>';
		                    echo '</div>';
						}
						wp_reset_postdata();
					echo '</div>';
				echo '</div>';
			echo '</div>';
			echo '<!-- blog Area end -->';
		}
	}
}