<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
/**
 *
 * Product Slider Widget .
 *
 */
class Zocker_Product_Slider extends Widget_Base {

	public function get_name() {
		return 'zockerproductslider';
	}

	public function get_title() {
		return __( 'Product Slider', 'zocker' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'zocker' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'product_slider_section',
			[
				'label' => __( 'Product Slider', 'zocker' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
			'product_count',
			[
				'label' 		=> __( 'Product Count', 'zocker' ),
				'type' 			=> Controls_Manager::NUMBER,
				'min' 			=> 1,
				'max' 			=> 50,
				'step' 			=> 1,
				'default' 		=> 6,
			]
		);

		$this->add_control(
			'product_type',
			[
				'label' 		=> __( 'Product Type', 'zocker' ),
                'type' 			=> Controls_Manager::SELECT,
                'label_block'   => true,
				'options' 		=> [
					''				=> __('Select Product Type','zocker'),
					'recent-items' 	=> __('Recent','zocker'),
					'top-rated'  	=> __('Top Rated','zocker'),
					'featured' 		=> __('Featured','zocker'),
					'on-sale' 		=> __('On Sale','zocker'),
					'best-selling' 	=> __('Best Selling','zocker'),
				],
				'default'			=> 'recent-items'
			]
        );

        $this->add_control(
			'product_cats',
			[
				'label'	 		=> __( 'Product Categories', 'zocker' ),
                'type' 			=> Controls_Manager::SELECT2,
                'multiple' 		=> true,
                'label_block'   => true,
                'options' 		=> $this->product_cats_get(),
			]
        );

		$this->end_controls_section();

		$this->start_controls_section(
			'slider_control_section',
			[
				'label' 		=> __( 'Slider Control', 'zocker' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
			'desktop_items',
			[
				'label' 		=> __( 'Desktop Items', 'zocker' ),
				'type' 			=> Controls_Manager::SLIDER,
				'size_units' 	=> [ '%' ],
				'range' 		=> [
					'%' 		=> [
						'min' 	=> 0,
						'step' 	=> 1,
						'max' 	=> 10,
					],
				],
				'default' 		=> [
					'unit' 		=> '%',
					'size' 		=> 3,
				],
			]
		);

		$this->add_control(
			'slider_autoplay',
			[
				'label' 		=> __( 'Autoplay', 'zocker' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'zocker' ),
				'label_off' 	=> __( 'No', 'zocker' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
			'product_title_style_section',
			[
				'label' 	=> __( 'Product Title Style', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'product_title_color',
			[
				'label' 		=> __( 'Product Title Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .vs-product-layout1 .category' => 'color: {{VALUE}}',
                ],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'product_title_typography',
				'label' 	=> __( 'Product Title Typography', 'zocker' ),
                'selector' 	=> '{{WRAPPER}} .vs-product-layout1 .category',
			]
        );

        $this->add_responsive_control(
			'product_title_margin',
			[
				'label' 		=> __( 'Product Title Margin', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .vs-product-layout1 .category' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'product_title_padding',
			[
				'label' 		=> __( 'Product Title Padding', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .vs-product-layout1 .category' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'product_price_style_section',
			[
				'label' 	=> __( 'Product Price Style', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

		$this->add_control(
			'product_price_color',
			[
				'label' 	=> __( 'Product Price Color', 'zocker' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .vs-product-layout1 .product-content .price' => 'color: {{VALUE}}',
                ]
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'product_price_typography',
				'label' 	=> __( 'Product Price Typography', 'zocker' ),
                'selector' 	=> '{{WRAPPER}} .vs-product-layout1 .product-content .price',
			]
        );

        $this->add_responsive_control(
			'product_price_margin',
			[
				'label' 		=> __( 'Product Price Margin', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .vs-product-layout1 .product-content .price' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'product_price_padding',
			[
				'label' 		=> __( 'Product Price Padding', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}}.vs-product-layout1 .product-content .price' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

		$this->end_controls_section();

    }

    protected function product_cats_get() {
        $terms = get_terms( array( 'taxonomy' => 'product_cat' ) );
        $term_array = array();
        if ( ! empty( $terms ) && ! is_wp_error( $terms ) ){
            foreach ( $terms as $term ) {
                $term_array[$term->slug] = $term->name;
            }
        }

        return $term_array;
    }

	protected function render() {

        $settings = $this->get_settings_for_display();

		$this->add_render_attribute('wrapper','class','row vs-carousel arrow-white arrow-margin arrow-wrap');

		$this->add_render_attribute( 'wrapper', 'data-slide-to-show', $settings['desktop_items']['size'] );

		if( $settings['slider_autoplay'] == 'yes' ) {
			$this->add_render_attribute('wrapper','data-slick-autoplay','true');
		} else {
			$this->add_render_attribute('wrapper','data-slick-autoplay','false');
		}

		$this->add_render_attribute( 'wrapper', 'data-slick-arrows', 'true' );

        $args = array(
            "post_type" => "product",
            "posts_per_page"    => esc_attr( $settings['product_count'] )
		);

		if( !empty( $settings['product_type'] ) ) {
			if( $settings['product_type'] == 'top-rated' ) {
				$args['meta_key'] = '_wc_average_rating';
				$args['order'] = 'DESC';
				$args['orderby'] = 'meta_value_num';
			} elseif( $settings['product_type']== 'featured' ) {
				$args['order'] = 'DESC';
				$args['orderby'] = 'date';
				$args['post__in'] = wc_get_featured_product_ids();
			} elseif( $settings['product_type'] == 'on-sale' ) {
				$args['post__in'] = wc_get_product_ids_on_sale();
				$args['order'] = 'ASC';
				$args['orderby'] = 'title';
			} elseif( $settings['product_type'] == 'best-selling' ) {
				$args['meta_key'] = 'total_sales';
				$args['order'] = 'DESC';
				$args['orderby'] = 'meta_value_num';
			} elseif( $settings['product_type'] == 'recent-items' ) {
				$args['order'] = 'DESC';
				$args['orderby'] = 'date';
			}
		}

        if( !empty( $settings['product_cats'] ) ) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'product_cat',
                    'field'    => 'slug',
                    'terms'    => $settings['product_cats'],
                ),
            );
        }

        $prods = new WP_Query($args);

		echo '<section class="vs-product-wrapper vs-product-layout1 arrow-wrap">';
		    echo '<div class="container">';
		        echo '<div '.$this->get_render_attribute_string('wrapper').'>';
		            while( $prods->have_posts() ) {
		                $prods->the_post();
						echo '<div class="col-xl-3">';
		                	wc_get_template( 'content-product-three.php' );
						echo '</div>';
		            }
		            wp_reset_postdata();
		        echo '</div>';
		    echo '</div>';
		echo '</section>';
	}
}