<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
/**
 *
 * Blog Post Widget .
 *
 */
class Zocker_Recent_News extends Widget_Base {

	public function get_name() {
		return 'zockerrecentnews';
	}

	public function get_title() {
		return __( 'Recent News', 'zocker' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'zocker' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'blog_post_section',
			[
				'label' 	=> __( 'Recent News', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'blog_style',
			[
				'label' 	=> __( 'Blog Style', 'zocker' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  		=> __( 'Style One', 'zocker' ),
					'2' 		=> __( 'Style Two', 'zocker' ),
				],
			]
		);

		$this->add_control(
			'section_title',
			[
				'label' 	=> __( 'Section Title', 'zocker' ),
				'type' 		=> Controls_Manager::TEXTAREA,
				'default'  	=> __( 'Recent Viewed', 'zocker' ),
				'condition' => [ 'blog_style' => '2' ],
			]
		);

		$this->add_control(
			'blog_post_count',
			[
				'label' 	=> __( 'No of Post to show', 'zocker' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( '4', 'zocker' ),
			]
        );

		$this->add_control(
			'title_count',
			[
				'label' 	=> __( 'Title Length', 'zocker' ),
				'type' 		=> Controls_Manager::TEXT,
				'default'  	=> __( '4', 'zocker' ),
			]
		);

        $this->add_control(
			'blog_post_order',
			[
				'label' 	=> __( 'Order', 'zocker' ),
                'type' 		=> Controls_Manager::SELECT,
                'options'   => [
                    'ASC'   	=> __('ASC','zocker'),
                    'DESC'   	=> __('DESC','zocker'),
                ],
                'default'  	=> 'DESC'
			]
        );

        $this->add_control(
			'blog_post_order_by',
			[
				'label' 	=> __( 'Order By', 'zocker' ),
                'type' 		=> Controls_Manager::SELECT,
                'options'   => [
                    'ID'    	=> __( 'ID', 'zocker' ),
                    'author'    => __( 'Author', 'zocker' ),
                    'title'    	=> __( 'Title', 'zocker' ),
                    'date'    	=> __( 'Date', 'zocker' ),
                    'rand'    	=> __( 'Random', 'zocker' ),
                ],
                'default'  	=> 'ID'
			]
        );

        $this->add_control(
			'exclude_cats',
			[
				'label' 		=> __( 'Exclude Categories', 'zocker' ),
                'type' 			=> Controls_Manager::SELECT2,
                'multiple' 		=> true,
				'options' 		=> $this->zocker_get_categories(),
			]
        );

        $this->add_control(
			'exclude_tags',
			[
				'label' 		=> __( 'Exclude Tags', 'zocker' ),
                'type' 			=> Controls_Manager::SELECT2,
                'multiple' 		=> true,
				'options' 		=> $this->zocker_get_tags(),
			]
        );

        $this->add_control(
			'exclude_post_id',
			[
				'label'         => __( 'Exclude Post', 'zocker' ),
                'type'          => Controls_Manager::SELECT2,
                'multiple'      => true,
				'options'       => $this->zocker_post_id(),
			]
        );

        $this->end_controls_section();

		$this->start_controls_section(
			'category_style',
			[
				'label' 	=> __( 'Category', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
				'condition'	=> [ 'blog_style' => '1' ]
			]
		);

		$this->add_control(
			'category_color',
			[
				'label' 		=> __( 'Category Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .blog-category a' => 'color: {{VALUE}}!important',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'category_typography',
				'label' 	=> __( 'Category Typography', 'zocker' ),
				'selector' 	=> '{{WRAPPER}} .blog-category a',
			]
		);
		$this->end_controls_section();

        $this->start_controls_section(
			'post_title_style_section',
			[
				'label' 	=> __( 'Title', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'post_title_color',
			[
				'label' 		=> __( 'Title Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .vs-blog .blog-title.h5' => 'color: {{VALUE}} !important',
				],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'post_title_typography',
				'label' 	=> __( 'Title Typography', 'zocker' ),
				'selector' 	=> '{{WRAPPER}} .vs-blog .blog-title.h5',
			]
        );

        $this->add_responsive_control(
			'post_title_margin',
			[
				'label' 		=> __( 'Title Margin', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .vs-blog .blog-title.h5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'post_title_padding',
			[
				'label' 		=> __( 'Title Padding', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .vs-blog .blog-title.h5' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

        $this->end_controls_section();

		$this->start_controls_section(
			'meta_style',
			[
				'label' 	=> __( 'Meta', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'meta_color',
			[
				'label' 		=> __( 'Meta Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .blog-meta a' => 'color: {{VALUE}}!important',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'meta_typography',
				'label' 	=> __( 'Meta Typography', 'zocker' ),
				'selector' 	=> '{{WRAPPER}} .blog-meta a',
			]
		);
		$this->end_controls_section();

    }

	public function zocker_get_categories() {
		$cats = get_terms(array(
			'taxonomy' => 'category',
			'hide_empty' => true,
		));

		$catarr = [];

		foreach( $cats as $singlecat ) {
			$catarr[$singlecat->term_id] = __($singlecat->name,'zocker');
		}

		return $catarr;
	}

	public function zocker_get_tags() {
		$cats = get_terms(array(
			'taxonomy' => 'post_tag',
			'hide_empty' => true,
		));

		$catarr = [];

		foreach( $cats as $singlecat ) {
			$catarr[$singlecat->term_id] = __($singlecat->name,'zocker');
		}

		return $catarr;
	}

	// Get Specific Post
	public function zocker_post_id(){
		$args = array(
			'post_type'         => 'post',
			'posts_per_page'    => -1,
		);

		$zocker_post = new WP_Query( $args );

		$postarray = [];

		while( $zocker_post->have_posts() ){
			$zocker_post->the_post();
			$postarray[get_the_Id()] = get_the_title();
		}
		wp_reset_postdata();
		return $postarray;
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		$exclude_post = $settings['exclude_post_id'];

        if( !empty( $settings['exclude_cats'] ) && empty( $settings['exclude_tags'] ) && empty( $settings['exclude_post_id'] ) ) {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true,
                'category__not_in'      => $settings['exclude_cats']
            );
        } elseif( !empty( $settings['exclude_cats'] ) && !empty( $settings['exclude_tags'] ) && empty( $settings['exclude_post_id'] ) ) {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true,
                'category__not_in'      => $settings['exclude_cats'],
                'tag__not_in'           => $settings['exclude_tags']
            );
        }elseif( !empty( $settings['exclude_cats'] ) && !empty( $settings['exclude_tags'] ) && !empty( $settings['exclude_post_id'] ) ) {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true,
                'category__not_in'      => $settings['exclude_cats'],
                'tag__not_in'           => $settings['exclude_tags'],
                'post__not_in'          => $exclude_post
            );
        } elseif( !empty( $settings['exclude_cats'] ) && empty( $settings['exclude_tags'] ) && !empty( $settings['exclude_post_id'] ) ) {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true,
                'category__not_in'      => $settings['exclude_cats'],
                'post__not_in'          => $exclude_post
            );
        } elseif( empty( $settings['exclude_cats'] ) && !empty( $settings['exclude_tags'] ) && !empty( $settings['exclude_post_id'] ) ) {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true,
                'tag__not_in'           => $settings['exclude_tags'],
                'post__not_in'          => $exclude_post
            );
        } elseif( empty( $settings['exclude_cats'] ) && !empty( $settings['exclude_tags'] ) && empty( $settings['exclude_post_id'] ) ) {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true,
                'tag__not_in'           => $settings['exclude_tags'],
            );
        } elseif( empty( $settings['exclude_cats'] ) && empty( $settings['exclude_tags'] ) && !empty( $settings['exclude_post_id'] ) ) {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true,
                'post__not_in'          => $exclude_post
            );
        } else {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true
            );
        }

        $recentnews = new WP_Query( $args );

		if( $recentnews->have_posts() ) {
			if( $settings['blog_style'] == '1' ){
				echo '<!-- blog Area -->';
				echo '<div class="post-thumb-style1 row">';
					while( $recentnews->have_posts() ) {
						$recentnews->the_post();
						echo '<div class="col-md-6 vs-blog">';
							echo '<div class="d-flex gap-3">';
								if( has_post_thumbnail( ) ){
									echo '<div class="media-img">';
										echo '<a href="'.esc_url( get_permalink() ).'">';
											the_post_thumbnail( 'home-slider-blog-image-seven' );
										echo '</a>';
									echo '</div>';
								}
								echo '<div class="media-body align-self-center">';
									echo '<div class="blog-category">';
										$category = get_the_category();
										if( $category && ! empty( $category ) ){
											echo '<a href="'.esc_url( get_term_link( $category[0]->term_id ) ).'">'.esc_html( $category[0]->name ).'</a>';
										}
									echo '</div>';
									if( get_the_title() ){
										echo '<h4 class="h5 blog-title font-theme lh-base text-white mb-0"><a href="'.esc_url( get_permalink() ).'">'.esc_html( wp_trim_words( get_the_title( ), $settings['title_count'], '' ) ).'</a></h4>';
									}
									echo '<div class="blog-meta text-light fs-xs mt-1">';
										echo '<a href="'.esc_url( playrex_blog_date_permalink() ).'"><i class="fal fa-calendar-alt"></i>';
											echo '<time datetime="'.esc_attr( get_the_date( DATE_W3C ) ).'">'.esc_html( get_the_date() ).'</time>';
										echo '</a>';
									echo '</div>';
								echo '</div>';
							echo '</div>';
						echo '</div>';
					}
					wp_reset_postdata();
				echo '</div>';
				echo '<!-- blog Area end -->';
			}else{
				echo '<div class="vs-sidebox bg-major-black">';
					if( ! empty( $settings['section_title'] ) ){
	                    echo '<h3 class="sidebox-title text-white h5">'.esc_html( $settings['section_title'] ).'</h3>';
					}
                    echo '<div class="post-thumb-style1">';
						while( $recentnews->have_posts() ) {
							$recentnews->the_post();
	                        echo '<div class="vs-blog d-flex gap-3">';
								if( has_post_thumbnail( ) ){
		                            echo '<div class="media-img">';
										echo '<a href="'.esc_url( get_permalink() ).'">';
											the_post_thumbnail( 'blog-sidebar-size' );
										echo '</a>';
		                            echo '</div>';
								}
	                            echo '<div class="media-body align-self-center">';
									if( get_the_title() ){
		                                echo '<h4 class="h5 blog-title font-theme lh-base text-white mb-0"><a href="'.esc_url( get_permalink() ).'">'.esc_html( wp_trim_words( get_the_title( ), $settings['title_count'], '' ) ).'</a></h4>';
									}
	                                echo '<div class="blog-meta text-light fs-xs mt-1">';
										echo '<a href="'.esc_url( playrex_blog_date_permalink() ).'"><i class="fal fa-calendar-alt"></i>';
											echo '<time datetime="'.esc_attr( get_the_date( DATE_W3C ) ).'">'.esc_html( get_the_date() ).'</time>';
										echo '</a>';
	                                echo '</div>';
	                            echo '</div>';
	                        echo '</div>';
						}
						wp_reset_postdata();
                    echo '</div>';
                echo '</div>';
			}
		}
	}
}