<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
/**
 *
 * Social Icon Widget .
 *
 */
class Zocker_Social_Icon extends Widget_Base {

	public function get_name() {
		return 'zockersocialicon';
	}

	public function get_title() {
		return __( 'Social Icon', 'zocker' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'zocker' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'social_icon_section',
			[
				'label' 	=> __( 'Social Icon', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'section_title',
			[
				'label' 		=> __( 'Section Title', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Social Connect', 'zocker' ),
				'placeholder' 	=> __( 'Type your title here', 'zocker' ),
			]
		);

        $repeater = new Repeater();

		$repeater->add_control(
			'social_icon',
			[
				'label' 	=> __( 'Icon', 'zocker' ),
				'type' 		=> Controls_Manager::ICONS,
				'default' 	=> [
					'value' 	=> 'fas fa-star',
					'library' 	=> 'solid',
				],
			]
		);
		$repeater->add_control(
			'social_text',
			[
				'label' 		=> __( 'Social Text', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Facebook', 'zocker' ),
				'placeholder' 	=> __( 'Type your description here', 'zocker' ),
			]
		);
		$repeater->add_control(
			'icon_link',
			[
				'label' 		=> __( 'Link', 'zocker' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'zocker' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
			]
		);

		$this->add_control(
			'icons',
			[
				'label' 		=> __( 'Social Icons', 'zocker' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'social_text' => __( 'Facebook', 'zocker' ),
					],
					[
						'social_text' => __( 'Twitter', 'zocker' ),
					],
				]
			]
		);

        $this->end_controls_section();

		$this->start_controls_section(
			'style_section',
			[
				'label' 	=> __( 'Style', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'title_color',
			[
				'label' 		=> __( 'Title Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .sidebox-title' => 'color: {{VALUE}} !important',
                ],
			]
        );
        $this->add_control(
			'title_shape_color',
			[
				'label' 		=> __( 'Title Shaper Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .sidebox-title:before' => 'color: {{VALUE}}',
                ],
			]
        );

        $this->add_control(
			'title_border_bottom_color',
			[
				'label' 		=> __( 'Title Border Bottom Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .sidebox-title' => 'border-bottom-color: {{VALUE}}',
                ],
			]
        );

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'title_typography',
				'label' 	=> __( 'Title Typography', 'zocker' ),
                'selector' 	=> '{{WRAPPER}} .sidebox-title',
			]
        );
		$this->add_control(
			'social_icon_color',
			[
				'label' 		=> __( 'Social Icon Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .blog-social-links .nav span,{{WRAPPER}} .links-stretch span' => 'color: {{VALUE}}',
                ],
			]
        );
		$this->end_controls_section();

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		echo '<div class="vs-sidebox bg-major-black">';
			if( ! empty( $settings['section_title'] ) ){
	            echo '<h3 class="sidebox-title text-white h5">'.esc_html( $settings['section_title'] ).'</h3>';
			}
			if( ! empty( $settings['icons'] ) ){
	            echo '<ul class="links-stretch">';
					foreach( $settings['icons'] as $singleicon ) {
						$target = $singleicon['icon_link']['is_external'] ? ' target="_blank"' : '';
						$nofollow = $singleicon['icon_link']['nofollow'] ? ' rel="nofollow"' : '';
		                echo '<li><a '.wp_kses_post( $nofollow.$target ).' href="'.esc_url( $singleicon['icon_link']['url'] ).'"><span class="'.esc_attr( $singleicon['social_icon']['value'] ).'"> '.esc_html( $singleicon['social_text'] ).'</span></a></li>';
					}
	            echo '</ul>';
			}
        echo '</div>';
	}
}