<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Background;
use \Elementor\Utils;
use \Elementor\Repeater;
/**
 *
 * Stream Time Table Widget .
 *
 */
class Zocker_Stream_Time_Table extends Widget_Base {

	public function get_name() {
		return 'zockerstreamtimetable';
	}

	public function get_title() {
		return __( 'Stream Time Table', 'zocker' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'zocker' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'stream_time_table_section',
			[
				'label'     => __( 'Stream Time Table', 'zocker' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );

		$repeater = new Repeater();

		$repeater->add_control(
			'stream_time', [
				'label' 		=> __( 'Stream Time', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( '2:00 AM - 9:00 AM cet' , 'zocker' ),
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'stream_date', [
				'label' 		=> __( 'Stream Date', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Tuesday' , 'zocker' ),
				'label_block' 	=> true,
			]
		);

		$repeater->add_control(
			'game_name', [
				'label' 		=> __( 'Game Name', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Call Of Duty' , 'zocker' ),
				'label_block' 	=> true,
			]
		);

		$repeater->add_control(
			'make_it_active',
			[
				'label' 		=> __( 'Make It Active?', 'zocker' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'zocker' ),
				'label_off' 	=> __( 'No', 'zocker' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);

		$this->add_control(
			'list',
			[
				'label' 			=> __( 'Repeater List', 'zocker' ),
				'type' 				=> Controls_Manager::REPEATER,
				'fields' 			=> $repeater->get_controls(),
				'default' 			=> [
					[
						'game_name' 		=> __( 'Free Fire', 'zocker' ),
					],
					[
						'game_name' 		=> __( 'Pubg', 'zocker' ),
					],
				],
				'title_field' 				=> '{{{ game_name }}}',
			]
		);

        $this->end_controls_section();


		$this->start_controls_section(
			'time_table_style_option',
			[
				'label' 	=> __( 'Style', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'box_background_color',
			[
				'label' 		=> __( 'Box Background Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .timetable-style1 .timetable-box' => 'background-color: {{VALUE}}',
                ],
			]
        );
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' 			=> 'box_hover_background',
				'label' 		=> __( 'Background', 'zocker' ),
				'types' 		=> [ 'gradient' ],
				'selector' 		=> '{{WRAPPER}} .timetable-style1 .timetable-box:before,{{WRAPPER}} .timetable-style1 .timetable-box:after',
			]
		);

		$this->add_control(
			'time_table_time_color',
			[
				'label' 		=> __( 'Time Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .timetable-style1 .time' => 'color: {{VALUE}}',
                ],
				'separator'		=> 'before',
			]
        );

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'          => 'time_table_time_typography',
				'label'         => __( 'Time Typography', 'zocker' ),
                'selector'      => '{{WRAPPER}} .timetable-style1 .time',
			]
		);
		$this->add_control(
			'time_table_day_color',
			[
				'label' 		=> __( 'Day Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .timetable-style1 .day' => 'color: {{VALUE}}',
                ],
				'separator'		=> 'before',
			]
        );
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'          => 'time_table_day_typography',
				'label'         => __( 'Day Typography', 'zocker' ),
                'selector'      => '{{WRAPPER}} .timetable-style1 .day',
			]
		);
        $this->add_responsive_control(
			'time_table_day_margin',
			[
				'label'         => __( 'Day Margin', 'zocker' ),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
					'{{WRAPPER}} .timetable-style1 .day' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->add_responsive_control(
			'time_table_day_padding',
			[
				'label'         => __( 'Day Padding', 'zocker' ),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
					'{{WRAPPER}} .timetable-style1 .day' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
				'separator'		=> 'after',
			]
		);
		$this->add_control(
			'game_name_color',
			[
				'label' 		=> __( 'Game Name Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .timetable-style1 .name' => 'color: {{VALUE}}',
                ]
			]
        );
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'          => 'game_name_typography',
				'label'         => __( 'Game Name Typography', 'zocker' ),
                'selector'      => '{{WRAPPER}} .timetable-style1 .name',
			]
		);
        $this->add_responsive_control(
			'game_name_margin',
			[
				'label'         => __( 'Game Name Margin', 'zocker' ),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
					'{{WRAPPER}} .timetable-style1 .name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->add_responsive_control(
			'game_name_padding',
			[
				'label'         => __( 'Game Name Padding', 'zocker' ),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
					'{{WRAPPER}} .timetable-style1 .name' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
		);
		$this->end_controls_section();

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		if( ! empty( $settings['list'] ) ){
			echo '<div class="timetable-style1">';
				foreach( $settings['list'] as $gaming_data ){
					if( $gaming_data['make_it_active'] == 'yes' ){
						$active = 'active';
					}else{
						$active = '';
					}
					echo '<div class="timetable-mark '.esc_attr( $active ).'">';
						echo '<div class="timetable-box">';
							if( ! empty( $gaming_data['stream_time'] ) ){
								echo '<p class="time mb-0">'.esc_html( $gaming_data['stream_time'] ).'</p>';
							}
							if( ! empty( $gaming_data['stream_date'] ) ){
								echo '<p class="day mb-0">'.esc_html( $gaming_data['stream_date'] ).'</p>';
							}
							if( ! empty( $gaming_data['game_name'] ) ){
								echo '<p class="name mb-0">'.esc_html( $gaming_data['game_name'] ).'</p>';
							}
						echo '</div>';
					echo '</div>';
				}
			echo '</div>';
		}
	}
}