<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Team Widget .
 *
 */
class Zocker_Team_Member extends Widget_Base {

	public function get_name() {
		return 'zockerteammember';
	}

	public function get_title() {
		return __( 'Team Member', 'zocker' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'zocker' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'image_section',
			[
				'label'     => __( 'Team Member', 'zocker' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'team_slider_grid_style',
			[
				'label' 		=> __( 'Slider Grid Style', 'zocker' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'slider',
				'options' 		=> [
					'slider'  			=> __( 'Slider Style', 'zocker' ),
					'grid' 				=> __( 'Grid Style', 'zocker' ),
				],
			]
		);

		$this->add_control(
			'team_member_image_grid',
			[
				'label'     => __( 'Team Member Image', 'zocker' ),
				'type'      => Controls_Manager::MEDIA,
				'dynamic'   => [
					'active' => true,
				],
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'condition'		=> [ 'team_slider_grid_style' => 'grid' ],
			]
		);

		$this->add_control(
			'person_name_grid',
            [
				'label'         => __( 'Person Name', 'zocker' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'John Steven' , 'zocker' ),
				'label_block'   => true,
				'condition'		=> [ 'team_slider_grid_style' => 'grid' ],
			]
		);
		$this->add_control(
			'person_details_url_grid',
			[
				'label' 		=> __( 'Person Details Url', 'zocker' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'zocker' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
				'condition'		=> [ 'team_slider_grid_style' => 'grid' ],
			]
		);
        $this->add_control(
			'person_designation_grid',
            [
				'label'         => __( 'Person Designation', 'zocker' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Founder' , 'zocker' ),
				'label_block'   => true,
				'condition'		=> [ 'team_slider_grid_style' => 'grid' ],
			]
		);

		$icon_repeater = new Repeater();

		$icon_repeater->add_control(
			'social_icon_for_grid',
			[
				'label' 		=> __( 'Social Icon One', 'zocker' ),
				'type' 			=> Controls_Manager::ICONS,
				'default' 		=> [
					'value' 		=> 'fab fa-facebook-f',
					'library' 		=> 'solid',
				],
			]
		);
		$icon_repeater->add_control(
			'social_icon_for_grid_link',
			[
				'label' 		=> __( 'Social Icon Link', 'zocker' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'zocker' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> 'www.facebook.com',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
			]
		);
		$this->add_control(
			'social_icon_grid_slide',
			[
				'label' 		=> __( 'Social Icon', 'zocker' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $icon_repeater->get_controls(),
				'title_field' 	=> '{{social_icon_for_grid.value}}',
				'condition'		=> [ 'team_slider_grid_style' => 'grid' ],
			]
		);


		$repeater = new Repeater();

        $repeater->add_control(
			'team_member_image',
			[
				'label'     => __( 'Team Member Image', 'zocker' ),
				'type'      => Controls_Manager::MEDIA,
				'dynamic'   => [
					'active' => true,
				],
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
        $repeater->add_control(
			'person_name',
            [
				'label'         => __( 'Person Name', 'zocker' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'John Steven' , 'zocker' ),
				'label_block'   => true,
			]
		);
		$repeater->add_control(
			'person_details_url',
			[
				'label' 		=> __( 'Person Details Url', 'zocker' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'zocker' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
			]
		);
        $repeater->add_control(
			'person_designation',
            [
				'label'         => __( 'Person Designation', 'zocker' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Founder' , 'zocker' ),
				'label_block'   => true,
			]
		);
		$repeater->add_control(
			'social_icon_one',
			[
				'label' 		=> __( 'Social Icon One', 'zocker' ),
				'type' 			=> Controls_Manager::ICONS,
				'default' 		=> [
					'value' 		=> 'fab fa-facebook-f',
					'library' 		=> 'solid',
				],
			]
		);
		$repeater->add_control(
			'social_icon_one_link',
			[
				'label' 		=> __( 'Social Icon Link One', 'zocker' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'zocker' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> 'www.facebook.com',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
			]
		);
		$repeater->add_control(
			'social_icon_two',
			[
				'label' 		=> __( 'Social Icon Two', 'zocker' ),
				'type' 			=> Controls_Manager::ICONS,
				'default' 		=> [
					'value' 		=> 'fab fa-twitter',
					'library' 		=> 'solid',
				],
			]
		);
		$repeater->add_control(
			'social_icon_two_link',
			[
				'label' 		=> __( 'Social Icon Link Two', 'zocker' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'zocker' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> 'www.twitter.com',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
			]
		);
		$repeater->add_control(
			'social_icon_three',
			[
				'label' 		=> __( 'Social Icon Three', 'zocker' ),
				'type' 			=> Controls_Manager::ICONS,
				'default' 		=> [
					'value' 		=> 'fab fa-instagram',
					'library' 		=> 'solid',
				],
			]
		);
		$repeater->add_control(
			'social_icon_three_link',
			[
				'label' 		=> __( 'Social Icon Link Three', 'zocker' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'zocker' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> 'www.instagram.com',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
			]
		);

		$this->add_control(
			'slides',
			[
				'label' 		=> __( 'Team Member', 'zocker' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'image' 	=> Utils::get_placeholder_image_src(),
					],
					[
						'image' 	=> Utils::get_placeholder_image_src(),
					],
				],
				'title_field' 	=> '{{person_name}}',
				'condition'		=> [ 'team_slider_grid_style' => 'slider' ],
			]
		);

        $this->end_controls_section();

		$this->start_controls_section(
			'slider_control_section',
			[
				'label' 		=> __( 'Slider Control', 'zocker' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
				'condition'		=> [ 'team_slider_grid_style' => 'slider' ],
			]
        );

		$this->add_control(
			'slider_nav',
			[
				'label' 		=> __( 'Navigation', 'zocker' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'zocker' ),
				'label_off' 	=> __( 'No', 'zocker' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);
		$this->add_control(
			'slide_to_show',
			[
				'label' 		=> __( 'Slide To Show', 'zocker' ),
				'type' 			=> Controls_Manager::SLIDER,
				'size_units' 	=> [ 'px' ],
				'range' 		=> [
					'px' 			=> [
						'min' 			=> 0,
						'max' 			=> 10,
						'step'			=> 1,
					],
				],
				'default' 	=> [
					'unit' 		=> 'px',
					'size' 		=> 3,
				],
			]
		);
        $this->end_controls_section();

		$this->start_controls_section(
			'team_member_style_option',
			[
				'label' 	=> __( 'Team Member Style', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'person_name_color',
			[
				'label' 		=> __( 'Person Name Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .vs-member-box .member-name a' => 'color: {{VALUE}}',
                ]
			]
        );
		$this->add_control(
			'person_name_color_hover',
			[
				'label' 		=> __( 'Person Name Color Hover', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .vs-member-box .member-name a:hover' => 'color: {{VALUE}}',
                ]
			]
        );
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'          => 'person_name_typography',
				'label'         => __( 'Person Name Typography', 'zocker' ),
                'selector'      => '{{WRAPPER}} .vs-member-box .member-name',
			]
		);
        $this->add_responsive_control(
			'person_name_margin',
			[
				'label'         => __( 'Person Name Margin', 'zocker' ),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
					'{{WRAPPER}} .vs-member-box .member-name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->add_responsive_control(
			'person_name_padding',
			[
				'label'         => __( 'Person Name Padding', 'zocker' ),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
					'{{WRAPPER}} .vs-member-box .member-name' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
				'separator'		=> 'after',
			]
		);
		$this->add_control(
			'person_designation_color',
			[
				'label' 		=> __( 'Person Designation Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .vs-member-box .degi' => 'color: {{VALUE}}',
                ]
			]
        );
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'          => 'person_designation_typography',
				'label'         => __( 'Person Designation Typography', 'zocker' ),
                'selector'      => '{{WRAPPER}} .vs-member-box .degi',
			]
		);
        $this->add_responsive_control(
			'person_designation_margin',
			[
				'label'         => __( 'Person Designation Margin', 'zocker' ),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
					'{{WRAPPER}} .vs-member-box .degi' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->add_responsive_control(
			'person_designation_padding',
			[
				'label'         => __( 'Person Designation Padding', 'zocker' ),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
					'{{WRAPPER}} .vs-member-box .degi' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
		);
		$this->end_controls_section();

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		if( $settings['team_slider_grid_style'] == 'slider' ){
			$this->add_render_attribute( 'wrapper', 'class', 'row vs-carousel' );
			$this->add_render_attribute( 'wrapper', 'data-slick-arrows', 'false' );
			$this->add_render_attribute( 'wrapper', 'data-slick-autoplay', 'true' );
			$this->add_render_attribute( 'wrapper', 'data-slide-to-show', $settings['slide_to_show']['size'] );
		}

		if( $settings['team_slider_grid_style'] == 'slider' ){
			if( ! empty( $settings['slides'] ) ){
				echo '<section class="vs-team-wrapper">';
			        echo '<div class="container">';
						echo '<div '.$this->get_render_attribute_string('wrapper').'>';
							foreach( $settings['slides'] as $team_member ){
								echo '<div class="col-xl-3">';
				                    echo '<div class="vs-member-box">';
				                        echo '<div class="member-img">';
											if( ! empty( $team_member['team_member_image']['url'] ) ){
												echo playrex_img_tag( array(
													'url'	=> esc_url( $team_member['team_member_image']['url'] ),
												) );
											}
											echo '<div class="member-links">';
												if( !empty( $team_member['social_icon_one']['value'] ) ){
													$target_social_one 		= $team_member['social_icon_one_link']['is_external'] ? ' target="_blank"' : '';
													$nofollow_social_one 	= $team_member['social_icon_one_link']['nofollow'] ? ' rel="nofollow"' : '';
													echo '<a '.wp_kses_post( $target_social_one.$nofollow_social_one ).' href="'.esc_url( $team_member['social_icon_one_link']['url'] ).'"><i class="'.esc_attr( $team_member['social_icon_one']['value'] ).'"></i></a>';
												}
												if( !empty( $team_member['social_icon_two']['value'] ) ){
													$target_social_two 		= $team_member['social_icon_two_link']['is_external'] ? ' target="_blank"' : '';
													$nofollow_social_two 	= $team_member['social_icon_two_link']['nofollow'] ? ' rel="nofollow"' : '';
													echo '<a '.wp_kses_post( $target_social_two.$nofollow_social_two ).' href="'.esc_url( $team_member['social_icon_two_link']['url'] ).'"><i class="'.esc_attr( $team_member['social_icon_two']['value'] ).'"></i></a>';
												}
												if( !empty( $team_member['social_icon_three']['value'] ) ){
													$target_social_three 	= $team_member['social_icon_three_link']['is_external'] ? ' target="_blank"' : '';
													$nofollow_social_three 	= $team_member['social_icon_three_link']['nofollow'] ? ' rel="nofollow"' : '';
													echo '<a '.wp_kses_post( $target_social_three.$nofollow_social_three ).' href="'.esc_url( $team_member['social_icon_three_link']['url'] ).'"><i class="'.esc_attr( $team_member['social_icon_three']['value'] ).'"></i></a>';
												}
				                            echo '</div>';
				                        echo '</div>';
				                        echo '<div class="member-content">';
											$target_team 	= $team_member['person_details_url']['is_external'] ? ' target="_blank"' : '';
											$nofollow_team 	= $team_member['person_details_url']['nofollow'] ? ' rel="nofollow"' : '';
											if( ! empty( $team_member['person_name'] ) ){
					                            echo '<h3 class="member-name fw-semibold"><a '.wp_kses_post( $target_team.$nofollow_team ).' href="'.esc_url( $team_member['person_details_url']['url'] ).'">'.esc_html( $team_member['person_name'] ).'</a></h3>';
											}
											if( ! empty( $team_member['person_designation'] ) ){
												echo '<span class="text-theme degi">'.esc_html( $team_member['person_designation'] ).'</span>';
											}
				                        echo '</div>';
				                    echo '</div>';
				                echo '</div>';
							}
			            echo '</div>';
			        echo '</div>';
				echo '</section>';
			}
		}else{
			echo '<div class="vs-team-wrapper">';
				echo '<div class="vs-team">';
					echo '<div class="vs-member-box">';
						echo '<div class="member-img">';
							if( ! empty( $settings['team_member_image_grid']['url'] ) ){
								echo playrex_img_tag( array(
									'url'	=> esc_url( $settings['team_member_image_grid']['url'] ),
								) );
							}
							echo '<div class="member-links">';
								foreach( $settings['social_icon_grid_slide'] as $social_icon ){
									$target_social_icon 	= $social_icon['social_icon_for_grid_link']['is_external'] ? ' target="_blank"' : '';
									$nofollow_social_icon 	= $social_icon['social_icon_for_grid_link']['nofollow'] ? ' rel="nofollow"' : '';
									echo '<a '.wp_kses_post( $target_social_icon.$nofollow_social_icon ).' href="'.esc_url( $social_icon['social_icon_for_grid_link']['url'] ).'"><i class="'.esc_attr( $social_icon['social_icon_for_grid']['value'] ).'"></i></a>';
								}
							echo '</div>';
						echo '</div>';
						echo '<div class="member-content">';
							$target_team 	= $settings['person_details_url_grid']['is_external'] ? ' target="_blank"' : '';
							$nofollow_team 	= $settings['person_details_url_grid']['nofollow'] ? ' rel="nofollow"' : '';
							if( ! empty( $settings['person_name_grid'] ) ){
								echo '<h3 class="member-name fw-semibold"><a '.wp_kses_post( $target_team.$nofollow_team ).' href="'.esc_url( $settings['person_details_url_grid']['url'] ).'">'.esc_html( $settings['person_name_grid'] ).'</a></h3>';
							}
							if( ! empty( $settings['person_designation_grid'] ) ){
								echo '<span class="text-theme degi">'.esc_html( $settings['person_designation_grid'] ).'</span>';
							}
						echo '</div>';
					echo '</div>';
				echo '</div>';
			echo '</div>';
		}
	}

}