<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
/**
 *
 * Testimonial Slider Widget .
 *
 */
class Zocker_Testimonial_Slider extends Widget_Base{

	public function get_name() {
		return 'zockertestimonialslider';
	}

	public function get_title() {
		return __( 'Testimonial Slider', 'zocker' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'zocker' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'testimonial_slider_section',
			[
				'label' 	=> __( 'Testimonial Slider', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'testimonial_style',
			[
				'label' 		=> __( 'Testimonial Style', 'zocker' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'one',
				'options'		=> [
					'one'  			=> __( 'Style One', 'zocker' ),
					'two' 			=> __( 'Style Two', 'zocker' ),
				],
			]
		);

		$this->add_control(
			'quote_image_one',
			[
				'label' 		=> __( 'Quote Or Bg Image One', 'zocker' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'quote_image_two',
			[
				'label' 		=> __( 'Quote Or Bg Image Two', 'zocker' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'section_subtitle', [
				'label' 		=> __( 'Section Subtitle', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Client' , 'zocker' ),
				'label_block' 	=> true,
				'condition'		=> [ 'testimonial_style' => 'two' ]
			]
        );

		$this->add_control(
			'section_title', [
				'label' 		=> __( 'Section Title', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Best Feedback' , 'zocker' ),
				'label_block' 	=> true,
				'condition'		=> [ 'testimonial_style' => 'two' ]
			]
        );

		$repeater = new Repeater();

		$repeater->add_control(
			'client_image',
			[
				'label' 		=> __( 'Client Image', 'zocker' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'quote_image',
			[
				'label' 		=> __( 'Quote Image', 'zocker' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'client_name', [
				'label' 		=> __( 'Client Name', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Rubaida Kanom' , 'zocker' ),
				'label_block' 	=> true,
			]
        );
		$repeater->add_control(
			'client_designation', [
				'label' 		=> __( 'Client Designation', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Chef Leader' , 'zocker' ),
				'label_block' 	=> true,
			]
        );
        $repeater->add_control(
			'client_feedback', [
				'label' 		=> __( 'Client Feedback', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco ' , 'zocker' ),
				'label_block' 	=> true,
			]
		);

		$this->add_control(
			'slides',
			[
				'label' 		=> __( 'Slides', 'zocker' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'client_name' 		=> __( 'Rubaida Kanom', 'zocker' ),
						'client_feedback' 	=> __( 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco ', 'zocker' ),
						'client_image' 		=> Utils::get_placeholder_image_src(),
					],
					[
						'client_name' 		=> __( 'Rubaida Kanom', 'zocker' ),
						'client_feedback' 	=> __( 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco ', 'zocker' ),
						'client_image' 		=> Utils::get_placeholder_image_src(),
					],
					[
						'client_name' 		=> __( 'Rubaida Kanom', 'zocker' ),
						'client_feedback' 	=> __( 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco ', 'zocker' ),
						'client_image' 		=> Utils::get_placeholder_image_src(),
					],
				],
				'title_field' 	=> '{{{ client_name }}}',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'slider_control_section',
			[
				'label' 		=> __( 'Slider Control', 'zocker' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'slider_arrows',
			[
				'label' 		=> __( 'Show Arrows?', 'zocker' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'zocker' ),
				'label_off' 	=> __( 'Hide', 'zocker' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'testimonial_general',
			[
				'label' 	=> __( 'General', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

		$this->add_control(
			'testimonial_box_bg_color',
			[
				'label' 		=> __( 'Testimonial Box Background Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .testimonial-layout1 .author-area:before,{{WRAPPER}} .testimonial-layout2 .vs-testimonial' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'testimonial_arrow_color',
			[
				'label' 		=> __( 'Testimonial Arrow Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .icon-btn4 i' => 'color: {{VALUE}}!important',
				],
			]
		);
		$this->add_control(
			'testimonial_arrow_hover_color',
			[
				'label' 		=> __( 'Testimonial Arrow Hover Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .icon-btn4:hover' => 'color: {{VALUE}}!important',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' 			=> 'icon_background',
				'label' 		=> __( 'Background', 'zocker' ),
				'types' 		=> [ 'gradient' ],
				'selector' 		=> '{{WRAPPER}} .icon-btn4',
				'condition'		=> [ 'testimonial_style' =>  'one' ],
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' 			=> 'icon_background_hover',
				'label' 		=> __( 'Background', 'zocker' ),
				'types' 		=> [ 'classic', 'gradient' ],
				'selector' 		=> '{{WRAPPER}} .icon-btn4:before',
				'condition'		=> [ 'testimonial_style' =>  'one' ],
			]
		);


		$this->end_controls_section();

        $this->start_controls_section(
			'testimonial_slider_client_name_style_section',
			[
				'label' 	=> __( 'Client Name', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'testimonial_slider_client_name_color',
			[
				'label' 		=> __( 'Client Name Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .author-name,{{WRAPPER}} .author-name h3' => 'color: {{VALUE}}',
				],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'testimonial_slider_client_name_typography',
				'label' 	=> __( 'Client Name Typography', 'zocker' ),
				'selector' 	=> '{{WRAPPER}} .author-name,{{WRAPPER}} .author-name h3',
			]
        );

        $this->add_responsive_control(
			'testimonial_slider_client_name_margin',
			[
				'label' 		=> __( 'Client Name Margin', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .author-name,{{WRAPPER}} .author-name h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'testimonial_slider_client_name_padding',
			[
				'label' 		=> __( 'Client Name Padding', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .author-name,{{WRAPPER}} .author-name h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
			'testimonial_slider_client_feedback_style_section',
			[
				'label' 	=> __( 'Client Feedback', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'testimonial_slider_client_feedback_color',
			[
				'label' 	=> __( 'Client Feedback Color', 'zocker' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .testimonial-layout1 .testi-text, {{WRAPPER}} .testimonial-layout2 .testi-text' => 'color: {{VALUE}} !important',
				],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'testimonial_slider_client_feedback_typography',
				'label' 	=> __( 'Client Feedback Typography', 'zocker' ),
				'selector' 	=> '{{WRAPPER}} .testimonial-layout1 .testi-text, {{WRAPPER}} .testimonial-layout2 .testi-text',
			]
        );

        $this->add_responsive_control(
			'testimonial_slider_client_feedback_margin',
			[
				'label' 		=> __( 'Client Feedback Margin', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .testimonial-layout1 .testi-text, {{WRAPPER}} .testimonial-layout2 .testi-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'testimonial_slider_client_feedback_padding',
			[
				'label' 		=> __( 'Client Feedback Padding', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .testimonial-layout1 .testi-text, {{WRAPPER}} .testimonial-layout2 .testi-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
			'testimonial_slider_designation_style_section',
			[
				'label' 	=> __( 'Designation', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'testimonial_slider_designation_color',
			[
				'label' 	=> __( 'Client Designation Color', 'zocker' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .author-name span,{{WRAPPER}} .vs-testimonial .degi' => 'color: {{VALUE}}!important',
				],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'testimonial_slider_designation_typography',
				'label' 	=> __( 'Client Designation Typography', 'zocker' ),
				'selector' 	=> '{{WRAPPER}} .author-name span,{{WRAPPER}} .vs-testimonial .degi',
			]
        );

        $this->add_responsive_control(
			'testimonial_slider_designation_margin',
			[
				'label' 		=> __( 'Client Designation Margin', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .author-name span,{{WRAPPER}} .vs-testimonial .degi' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'testimonial_slider_designation_padding',
			[
				'label' 		=> __( 'Client Designation Padding', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .author-name span,{{WRAPPER}} .vs-testimonial .degi' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

        $this->end_controls_section();


	}

	protected function render() {

		$settings = $this->get_settings_for_display();

		if( $settings['testimonial_style'] == 'one' ){
			if( ! empty( $settings['slides'] ) ){
				echo '<section class="vs-testimonial testimonial-layout1">';
			        echo '<div class="container position-relative">';
			            echo '<div class="row justify-content-center">';
			                echo '<div class="col-lg-11 position-relative">';
								if( ! empty( $settings['quote_image_one']['url'] ) ){
									echo playrex_img_tag( array(
										'url'	=> esc_url( $settings['quote_image_one']['url'] ),
										'class' => 'position-absolute d-none d-xxl-inline-block start-0 top-100 translate-middle mb-xl-4'
									) );
								}
								if( ! empty( $settings['quote_image_two']['url'] ) ){
									echo playrex_img_tag( array(
										'url'	=> esc_url( $settings['quote_image_two']['url'] ),
										'class' => 'position-absolute d-none d-xxl-inline-block start-100 top-100 translate-middle mb-xl-4'
									) );
								}
			                    echo '<div class="testimonial-content text-center px-lg-4 mb-40 vs-carousel" id="slide1" data-asnavfor="#slide2, #slide3">';
									foreach( $settings['slides'] as $singleslide ){
														echo '<div>';
														echo '<h2 class="testi-text">'.esc_html( $singleslide['client_feedback'] ).'</h2>';
														echo '</div>';
									}
			                    echo '</div>';
			                echo '</div>';
			                echo '<div class="col-xl-5">';
			                    echo '<div class="author-area pb-40">';
									if( $settings['slider_arrows'] == 'yes' ){
				                        echo '<button class="icon-btn4 d-none d-sm-inline-block position-absolute start-100 top-50 translate-middle-x" data-slick-next="#slide2"><i class="fas fa-caret-right"></i></button>';
				                        echo '<button class="icon-btn4 d-none d-sm-inline-block position-absolute start-0 top-50 translate-middle-x" data-slick-prev="#slide2"><i class="fas fa-caret-left"></i></button>';
									}
			                        echo '<div class="avater-slide1 vs-carousel mb-30" id="slide2" data-asnavfor="#slide1, #slide3">';
			                            foreach( $settings['slides'] as $singleslide ){
											if( ! empty( $singleslide['client_image']['url'] ) ){
												echo '<div class="avater">';
					                                echo playrex_img_tag( array(
														'url'	=> esc_url( $singleslide['client_image']['url'] ),
													) );
					                            echo '</div>';
											}
										}
			                        echo '</div>';
			                        echo '<div class="author-name text-center vs-carousel" id="slide3" data-asnavfor="#slide2, #slide1">';
			                            foreach( $settings['slides'] as $singleslide ){
											echo '<div>';
												if( ! empty( $singleslide['client_name'] ) ){
					                                echo '<h3 class="h5 mb-0">'.esc_html( $singleslide['client_name'] ).'</h3>';
												}
												if( ! empty( $singleslide['client_designation'] ) ){
					                                echo '<span>'.esc_html( $singleslide['client_designation'] ).'</span>';
												}
				                            echo '</div>';
										}
			                        echo '</div>';
			                    echo '</div>';
			                echo '</div>';
			            echo '</div>';
			        echo '</div>';
			    echo '</section>';
			}
		}else{
			if( ! empty( $settings['slides'] ) ){
				echo '<section class="vs-testimonial testimonial-layout2 position-relative space-top space-md-bottom" >';
					if( ! empty( $settings['quote_image_one']['url'] ) ){
				        echo '<div class="testimonial-shape" data-bg-src="'.esc_url( $settings['quote_image_one']['url'] ).'">';
						echo '</div>';
					}
			        echo '<div class="container z-index-common">';
			            echo '<div class="row">';
			                echo '<div class="col-sm-8">';
			                    echo '<div class="section-title">';
									if( ! empty( $settings['section_subtitle'] ) ){
				                        echo '<span class="sub-title2 mb-30">'.esc_html( $settings['section_subtitle'] ).'</span>';
									}
									if( ! empty( $settings['section_title'] ) ){
				                        echo '<h2 class="text-white sec-title3">'.esc_html( $settings['section_title'] ).'</h2>';
									}
			                    echo '</div>';
			                echo '</div>';
			                echo '<div class="col-sm-4 align-self-center text-end mb-5 d-none d-sm-block">';
								if( $settings['slider_arrows'] == 'yes' ){
				                    echo '<button class="icon1 text-white me-4" data-slick-prev="#testislide1"><i class="far fa-chevron-left fa-2x"></i></button>';
				                    echo '<button class="icon1 text-white" data-slick-next="#testislide1"><i class="far fa-chevron-right fa-2x"></i></button>';
								}
			                echo '</div>';
			            echo '</div>';
			        echo '</div>';
			        echo '<div class="container-fluid px-xl-0 overflow-hidden">';
			            echo '<div class="testimonial-slider-two row gx-0 vs-carousel" id="testislide1">';
			                foreach( $settings['slides'] as $singleslide ){
								echo '<div class="col-xl-7">';
				                    echo '<div class="vs-testimonial">';
										if( ! empty( $singleslide['quote_image']['url'] ) ){
					                        echo '<div class="quote position-absolute">';
												echo playrex_img_tag( array(
													'url'	=> esc_url( $singleslide['quote_image']['url'] ),
												));
											echo '</div>';
										}
										if( ! empty( $singleslide['client_feedback'] ) ){
					                        echo '<p class="testi-text fs-20 text-light2 mb-35">'.esc_html( $singleslide['client_feedback'] ).'</p>';
										}
										if( ! empty( $singleslide['client_image']['url'] ) ){
					                        echo '<div class="author-img mx-auto mb-15">';
												echo playrex_img_tag( array(
													'url'	=> esc_url( $singleslide['client_image']['url'] ),
												) );
					                        echo '</div>';
										}
										if( ! empty( $singleslide['client_name'] ) ){
					                        echo '<h3 class="h4 text-white author-name font-theme text-normal mb-0">'.esc_html( $singleslide['client_name'] ).'</h3>';
										}
										if( ! empty( $singleslide['client_designation'] ) ){
					                        echo '<span class="degi text-light2">'.esc_html( $singleslide['client_designation'] ).'</span>';
										}
				                    echo '</div>';
				                echo '</div>';
							}
			            echo '</div>';
			        echo '</div>';
			    echo '</section>';
			}
		}
	}
}