<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
/**
 *
 * Top Games Widget .
 *
 */
class Zocker_Top_Games extends Widget_Base {

	public function get_name() {
		return 'zockertopgames';
	}

	public function get_title() {
		return __( 'Top Games', 'zocker' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'zocker' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'top_games_section',
			[
				'label' 	=> __( 'Top Games', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'section_title',
			[
				'label' 		=> __( 'Section Title', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Top Games', 'zocker' ),
				'placeholder' 	=> __( 'Type your title here', 'zocker' ),
			]
		);

        $repeater = new Repeater();

		$repeater->add_control(
			'game_image',
			[
				'label' 	=> __( 'Choose Image', 'zocker' ),
				'type' 		=> Controls_Manager::MEDIA,
				'default' 	=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'image_link',
			[
				'label' 		=> __( 'Link', 'zocker' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'zocker' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
			]
		);

		$this->add_control(
			'top_games_reapeter',
			[
				'label' 		=> __( 'Top Gamess', 'zocker' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'image_link' => __( 'www.game.com', 'zocker' ),
					],
					[
						'image_link' => __( 'www.game.com', 'zocker' ),
					],
				]
			]
		);

        $this->end_controls_section();

		$this->start_controls_section(
			'style_section',
			[
				'label' 	=> __( 'Style', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'title_color',
			[
				'label' 		=> __( 'Title Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .sidebox-title' => 'color: {{VALUE}} !important',
                ],
			]
        );
        $this->add_control(
			'title_shape_color',
			[
				'label' 		=> __( 'Title Shaper Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .sidebox-title:before' => 'color: {{VALUE}}',
                ],
			]
        );

        $this->add_control(
			'title_border_bottom_color',
			[
				'label' 		=> __( 'Title Border Bottom Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .sidebox-title' => 'border-bottom-color: {{VALUE}}',
                ],
			]
        );

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'title_typography',
				'label' 	=> __( 'Title Typography', 'zocker' ),
                'selector' 	=> '{{WRAPPER}} .sidebox-title',
			]
        );
		$this->end_controls_section();

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		echo '<div class="vs-sidebox bg-major-black">';
			if( ! empty( $settings['section_title'] ) ){
	            echo '<h3 class="sidebox-title text-white h5">'.esc_html( $settings['section_title'] ).'</h3>';
			}
			if( ! empty( $settings['top_games_reapeter'] ) ){
	            echo '<div class="row no-gutters g-2">';
					foreach( $settings['top_games_reapeter'] as $singleimage ) {
						$target = $singleimage['image_link']['is_external'] ? ' target="_blank"' : '';
						$nofollow = $singleimage['image_link']['nofollow'] ? ' rel="nofollow"' : '';
						echo '<div class="col-6">';
							if( ! empty( $singleimage['game_image']['url'] ) ){
	                            echo '<div class="image-scale-hover"><a '.wp_kses_post( $nofollow.$target ).' href="'.esc_url( $singleimage['image_link']['url'] ).'">';
									echo playrex_img_tag( array(
										'url'	=> esc_url( $singleimage['game_image']['url'] ),
										'class' => 'w-100',
									) );
								echo '</a></div>';
							}
                        echo '</div>';
					}
	            echo '</div>';
			}
        echo '</div>';
	}
}