<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
/**
 *
 * Blog Post Widget .
 *
 */
class Zocker_Trending_News_List extends Widget_Base {

	public function get_name() {
		return 'zockertrendingnewslist';
	}

	public function get_title() {
		return __( 'Tredning News List', 'zocker' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'zocker' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'blog_post_section',
			[
				'label' 	=> __( 'Trending News List', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
			'blog_post_count',
			[
				'label' 	=> __( 'No of Post to show', 'zocker' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( '4', 'zocker' ),
			]
        );

		$this->add_control(
			'title_count',
			[
				'label' 	=> __( 'Title Length', 'zocker' ),
				'type' 		=> Controls_Manager::TEXT,
				'default'  	=> __( '4', 'zocker' ),
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
			'post_title_style_section',
			[
				'label' 	=> __( 'Title', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'post_title_color',
			[
				'label' 		=> __( 'Title Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .vs-blog .blog-title.h5' => 'color: {{VALUE}} !important',
				],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'post_title_typography',
				'label' 	=> __( 'Title Typography', 'zocker' ),
				'selector' 	=> '{{WRAPPER}} .vs-blog .blog-title.h5',
			]
        );

        $this->add_responsive_control(
			'post_title_margin',
			[
				'label' 		=> __( 'Title Margin', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .vs-blog .blog-title.h5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'post_title_padding',
			[
				'label' 		=> __( 'Title Padding', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .vs-blog .blog-title.h5' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

        $this->end_controls_section();

		$this->start_controls_section(
			'category_style',
			[
				'label' 	=> __( 'Category', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'category_color',
			[
				'label' 		=> __( 'Category Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .blog-category a' => 'color: {{VALUE}}!important',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'category_typography',
				'label' 	=> __( 'Category Typography', 'zocker' ),
				'selector' 	=> '{{WRAPPER}} .blog-category a',
			]
		);
		$this->end_controls_section();
    }


	protected function render() {

        $settings = $this->get_settings_for_display();

		$args = array(
			"post_type"             => "post",
			"posts_per_page"        => esc_attr( $settings['blog_post_count'] ),
			"post_status"           => "publish",
			"orderby"               => "comment_count",
			"ignore_sticky_posts"   => true
		);

	    $this->add_render_attribute( 'wrapper', 'class', 'multibg-color-cat vs-carousel arrow-wrap' );

        $trendingnews = new WP_Query( $args );

		if( $trendingnews->have_posts() ) {
			echo '<!-- blog Area -->';
			echo '<div class="post-thumb-style1">';
				while( $trendingnews->have_posts() ) {
					$trendingnews->the_post();
					echo '<div class="vs-blog d-flex gap-3">';
						if( has_post_thumbnail( ) ){
							echo '<div class="media-img">';
								echo '<a href="'.esc_url( get_permalink() ).'">';
									the_post_thumbnail( 'home-slider-blog-image-five' );
								echo '</a>';
							echo '</div>';
						}
						echo '<div class="media-body align-self-center">';
							echo '<div class="blog-category">';
								$category = get_the_category();
								if( $category && ! empty( $category ) ){
									echo '<a href="'.esc_url( get_term_link( $category[0]->term_id ) ).'">'.esc_html( $category[0]->name ).'</a>';
								}
							echo '</div>';
							if( get_the_title() ){
								echo '<h4 class="h5 blog-title font-theme lh-base text-white mb-0"><a href="'.esc_url( get_permalink() ).'">'.esc_html( wp_trim_words( get_the_title( ), $settings['title_count'], '' ) ).'</a></h4>';
							}
						echo '</div>';
					echo '</div>';
				}
				wp_reset_postdata();
			echo '</div>';
			echo '<!-- blog Area end -->';
		}
	}
}