<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
/**
 *
 * Blog Post Widget .
 *
 */
class Zocker_Trending_News extends Widget_Base {

	public function get_name() {
		return 'zockertrendingnews';
	}

	public function get_title() {
		return __( 'Tredning News', 'zocker' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'zocker' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'blog_post_section',
			[
				'label' 	=> __( 'Trending News', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
			'blog_post_count',
			[
				'label' 	=> __( 'No of Post to show', 'zocker' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( '4', 'zocker' ),
			]
        );

		$this->add_control(
			'title_count',
			[
				'label' 	=> __( 'Title Length', 'zocker' ),
				'type' 		=> Controls_Manager::TEXT,
				'default'  	=> __( '4', 'zocker' ),
			]
		);

        $this->end_controls_section();

		$this->start_controls_section(
			'slider_control_section',
			[
				'label' 		=> __( 'Slider Control', 'zocker' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'show_arrows',
			[
				'label' 		=> __( 'Show Arrows?', 'zocker' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'zocker' ),
				'label_off' 	=> __( 'Hide', 'zocker' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);

		$this->add_control(
			'slide_to_show',
			[
				'label' 		=> __( 'Slide To Show', 'zocker' ),
				'type' 			=> Controls_Manager::SLIDER,
				'size_units' 	=> [ 'px' ],
				'range' 		=> [
					'px' 			=> [
						'min' 			=> 0,
						'max' 			=> 10,
						'step'			=> 1,
					],
				],
				'default' 	=> [
					'unit' 		=> 'px',
					'size' 		=> 3,
				],
			]
		);
		$this->end_controls_section();

        $this->start_controls_section(
			'post_title_style_section',
			[
				'label' 	=> __( 'Title', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'post_title_color',
			[
				'label' 		=> __( 'Title Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .vs-blog .blog-title.h5 a' => 'color: {{VALUE}} !important',
				],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'post_title_typography',
				'label' 	=> __( 'Title Typography', 'zocker' ),
				'selector' 	=> '{{WRAPPER}} .vs-blog .blog-title.h5 a',
			]
        );

        $this->add_responsive_control(
			'post_title_margin',
			[
				'label' 		=> __( 'Title Margin', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .vs-blog .blog-title.h5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'post_title_padding',
			[
				'label' 		=> __( 'Title Padding', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .vs-blog .blog-title.h5' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

        $this->end_controls_section();

		$this->start_controls_section(
			'meta_style',
			[
				'label' 	=> __( 'Meta', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'meta_color',
			[
				'label' 		=> __( 'Meta Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .blog-meta a' => 'color: {{VALUE}}!important',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'meta_typography',
				'label' 	=> __( 'Meta Typography', 'zocker' ),
				'selector' 	=> '{{WRAPPER}} .blog-meta a',
			]
		);
		$this->end_controls_section();
    }


	protected function render() {

        $settings = $this->get_settings_for_display();

		$args = array(
			"post_type"             => "post",
			"posts_per_page"        => esc_attr( $settings['blog_post_count'] ),
			"post_status"           => "publish",
			"orderby"               => "comment_count",
			"ignore_sticky_posts"   => true
		);

	    $this->add_render_attribute( 'wrapper', 'class', 'multibg-color-cat vs-carousel arrow-wrap' );

		if( $settings['show_arrows'] == 'yes' ){
	        $this->add_render_attribute( 'wrapper', 'data-slick-arrows', 'true' );
		}else{
			$this->add_render_attribute( 'wrapper', 'data-slick-arrows', 'false' );
		}

        $this->add_render_attribute( 'wrapper', 'data-slide-to-show', $settings['slide_to_show']['size'] );
        $this->add_render_attribute( 'wrapper', 'data-slick-autoplay', 'true' );

        $trendingnews = new WP_Query( $args );

		if( $trendingnews->have_posts() ) {
			echo '<!-- blog Area -->';
			echo '<section class="vs-news-area">';
				echo '<div class="container">';
					echo '<div '.$this->get_render_attribute_string('wrapper').'>';
						while( $trendingnews->have_posts() ) {
							$trendingnews->the_post();
							echo '<div class="position-relative vs-blog">';
								if( has_post_thumbnail() ){
									echo '<a href="'.esc_url( get_permalink() ).'" class="overlay overlay-lg"></a>';
									echo '<div class="blog-image">';
										the_post_thumbnail( 'home-slider-blog-image-four', array( 'class' => 'w-100' ) );
									echo '</div>';
								}
								echo '<div class="blog-content pos-bottom">';
									$category = get_the_category();
									if( $category && ! empty( $category ) ){
										echo '<div class="blog-category mb-1">';
											echo '<a href="'.esc_url( get_term_link( $category[0]->term_id ) ).'">'.esc_html( $category[0]->name ).'</a>';
										echo '</div>';
									}
									if( get_the_title() ){
										echo '<h3 class="blog-title h5 text-white font-theme lh-base mb-2"><a href="'.esc_url( get_permalink() ).'">'.esc_html( wp_trim_words( get_the_title( ), $settings['title_count'], '' ) ).'</a></h3>';
									}
									echo '<div class="blog-meta text-light-white fs-xs">';
										echo '<a href="'.esc_url( playrex_blog_date_permalink() ).'"><i class="fal fa-calendar-alt"></i>';
											echo '<time datetime="'.esc_attr( get_the_date( DATE_W3C ) ).'">'.esc_html( get_the_date() ).'</time>';
										echo '</a>';
										echo '<a href="'.esc_url( get_author_posts_url( get_the_author_meta('ID') ) ).'"><i class="fal fa-user"></i>'.esc_html( ucwords( get_the_author() ) ).'</a>';
									echo '</div>';
								echo '</div>';
							echo '</div>';
						}
						wp_reset_postdata();
					echo '</div><!-- .row END -->';
				echo '</div><!-- .container END -->';
			echo '</section>';
			echo '<!-- blog Area end -->';
		}
	}
}