<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
/**
 *
 * Video Slider Widget .
 *
 */
class Zocker_Video_Slider extends Widget_Base{

	public function get_name() {
		return 'zockervideoslider';
	}

	public function get_title() {
		return __( 'Video Slider', 'zocker' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'zocker' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'video_slider_section',
			[
				'label' 	=> __( 'Video Slider', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'video_image',
			[
				'label' 		=> __( 'Image', 'zocker' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$repeater->add_control(
			'video_url', [
				'label' 		=> __( 'Video Url?', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'https://www.youtube.com/watch?v=_sI_Ps7JSEk' , 'zocker' ),
				'label_block' 	=> true,
			]
        );

		$this->add_control(
			'slides',
			[
				'label' 		=> __( 'Slides', 'zocker' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'video_image' 		=> Utils::get_placeholder_image_src(),
					],
					[
						'video_image' 		=> Utils::get_placeholder_image_src(),
					],
					[
						'video_image' 		=> Utils::get_placeholder_image_src(),
					],
				],
				'title_field' 	=> __( 'Add Video', 'zocker' ),
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'slider_control_section',
			[
				'label' 		=> __( 'Slider Control', 'zocker' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
			'desktop_items',
			[
				'label' 		=> __( 'Desktop Items', 'zocker' ),
				'type' 			=> Controls_Manager::SLIDER,
				'size_units' 	=> [ '%' ],
				'range' 		=> [
					'%' 	=> [
						'min' 	=> 0,
						'step' 	=> 1,
						'max' 	=> 10,
					],
				],
				'default' 	=> [
					'unit' 		=> '%',
					'size' 		=> 2,
				],
			]
		);

		$this->add_control(
			'slider_autoplay',
			[
				'label' 		=> __( 'Autoplay', 'zocker' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'zocker' ),
				'label_off' 	=> __( 'No', 'zocker' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);

		$this->add_control(
			'slider_arrows',
			[
				'label' 		=> __( 'Arrows', 'zocker' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'zocker' ),
				'label_off' 	=> __( 'No', 'zocker' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);

        $this->end_controls_section();


	}

	protected function render() {

		$settings = $this->get_settings_for_display();

		$this->add_render_attribute( 'wrapper', 'class', 'row align-items-center gx-xl-0 arrow-white vs-carousel' );
		$this->add_render_attribute( 'wrapper', 'data-slide-to-show', $settings['desktop_items']['size'] );

		if( $settings['slider_autoplay'] == 'yes' ){
			$this->add_render_attribute( 'wrapper', 'data-autoplay', 'true' );
		}else{
			$this->add_render_attribute( 'wrapper', 'data-autoplay', 'false' );
		}

		if( $settings['slider_arrows'] == 'yes' ){
			$this->add_render_attribute( 'wrapper', 'data-slick-arrows', 'true' );
		}else{
			$this->add_render_attribute( 'wrapper', 'data-slick-arrows', 'false' );
		}

		if( ! empty( $settings['slides'] ) ){
			echo '<section class="vs-video-area arrow-wrap">';
				echo '<div class="container">';
                    echo '<div '.$this->get_render_attribute_string('wrapper').'>';
                        foreach( $settings['slides'] as $singleslide ) {
							echo '<div class="col-lg-4">';
		                        echo '<div class="video-box1">';
		                            echo '<a href="'.esc_url( $singleslide['video_url'] ).'" class="popup-video">';
										echo playrex_img_tag( array(
											'url'	=>	esc_url( $singleslide['video_image']['url'] ),
											'class' => 'w-100',
										) );
		                            echo '</a>';
		                            echo '<a href="'.esc_url( $singleslide['video_url'] ).'" class="play-btn popup-video position-center"><i class="fas fa-play"></i></a>';
		                        echo '</div>';
		                    echo '</div>';
                        }
                    echo '</div>';
	            echo '</div>';
		    echo '</section>';
		}
	}

}