<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
/**
 *
 * Video Streaming Tab Widget .
 *
 */
class Zocker_Video_Streaming_Tab extends Widget_Base{

	public function get_name() {
		return 'zockervideostreamingtab';
	}

	public function get_title() {
		return __( 'Video Streaming Tab', 'zocker' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'zocker' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'video_streaming_tab_section',
			[
				'label' 	=> __( 'Video Streaming Tab', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
		);


		$repeater = new Repeater();

		$repeater->add_control(
			'tab_text', [
				'label' 		=> __( 'Tab Text', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'CSGO' , 'zocker' ),
				'label_block' 	=> true,
			]
        );

		$this->add_control(
			'slides',
			[
				'label' 		=> __( 'Slides', 'zocker' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'tab_text' 		=> __( 'CSGO', 'zocker' ),
					],
					[
						'tab_text' 		=> __( 'DOTA2', 'zocker' ),
					],
					[
						'tab_text' 		=> __( 'PUBG', 'zocker' ),
					],
				],
				'title_field' 	=> '{{{ tab_text }}}',
			]
		);

		$match_repeater = new Repeater();

		$match_repeater->add_control(
			'player_image', [
				'label' 		=> __( 'Player Image', 'zocker' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
        );

		$match_repeater->add_control(
			'streaming_url', [
				'label' 		=> __( 'Streaming Url?', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'https://www.youtube.com/watch?v=_sI_Ps7JSEk' , 'zocker' ),
				'label_block' 	=> true,
			]
        );

		$this->add_control(
			'stream_info_slides',
			[
				'label' 		=> __( 'Stream Info Slide', 'zocker' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $match_repeater->get_controls(),
				'default' 		=> [
					[
						'streaming_url' 		=> __( 'https://www.youtube.com/watch?v=_sI_Ps7JSEk', 'zocker' ),
					],
					[
						'streaming_url' 		=> __( 'https://www.youtube.com/watch?v=_sI_Ps7JSEk', 'zocker' ),
					],
					[
						'streaming_url' 		=> __( 'https://www.youtube.com/watch?v=_sI_Ps7JSEk', 'zocker' ),
					],
				],
				'title_field' 	=> '{{{ streaming_url }}}',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'tab_style_section',
			[
				'label' 	=> __( 'Tab Style', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

		$this->add_control(
			'tab_bg_color',
			[
				'label' 		=> __( 'Tab Background Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .filter-menu-style1:before' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'tab_color',
			[
				'label' 		=> __( 'Tab Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .filter-menu-style1 a' => 'color: {{VALUE}}',
				],
			]
        );

        $this->add_control(
			'tab_color_hover',
			[
				'label' 		=> __( 'Tab Color Hover', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .filter-menu-style1 a:hover' => 'color: {{VALUE}}',
				],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'tab_typography',
				'label' 	=> __( 'Tab Typography', 'zocker' ),
				'selector' 	=> '{{WRAPPER}} .filter-menu-style1 a',
			]
        );

        $this->add_responsive_control(
			'tab_margin',
			[
				'label' 		=> __( 'Tab Margin', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .filter-menu-style1 a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'tab_padding',
			[
				'label' 		=> __( 'Tab Padding', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .filter-menu-style1 a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

        $this->end_controls_section();

		$this->start_controls_section(
			'streaming_info_section',
			[
				'label' 	=> __( 'Streaming Info Style', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

		$this->add_control(
			'video_icon_color',
			[
				'label' 		=> __( 'Video Icon Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .play-btn > i' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'prev_next_icon_color',
			[
				'label' 		=> __( 'Prev Next Icon Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .arrow-white .slick-arrow' => 'color: {{VALUE}}!important',
				],
			]
        );

        $this->end_controls_section();


	}


	protected function render() {

		$settings = $this->get_settings_for_display();

		$this->add_render_attribute( 'wrapper', 'class', 'strem-video1 vs-carousel arrow-white' );
		$this->add_render_attribute( 'wrapper', 'id', 'slideStrem' );

		if( ! empty( $settings['slides'] ) || ! empty( $settings['stream_info_slides'] ) ){
			echo '<div class="text-center">';
				echo '<div class="filter-menu-style1 mb-40 vs-slider-tab redwan" data-asnavfor="#slideStrem">';
					$x = 1;
					foreach( $settings['slides'] as $tab_data ) {
						if( $x == 1 ){
							$class = "active";
						}else{
							$class = "";
						}
						echo '<a href="#" class="tab-btn '.esc_attr( $class ).'">'.esc_html( $tab_data['tab_text'] ).'</a>';
						$x++;
					}
				echo '</div>';
				echo '<div class="position-relative arrow-wrap">';
					echo '<div '.$this->get_render_attribute_string('wrapper').'>';
						foreach( $settings['stream_info_slides'] as $singleslide ) {
							echo '<div class="position-relative image-scale-hover">';
									echo '<a class="popup-video" href="'.esc_url( $singleslide['streaming_url'] ).'">';
										echo playrex_img_tag( array (
											'url'	=> esc_url( $singleslide['player_image']['url'] ),
											'class' => 'w-100',
										));
										echo '</a>';
									echo '<a class="popup-video play-btn position-center" href="'.esc_url( $singleslide['streaming_url'] ).'"><i class="fas fa-play"></i></a>';
							echo '</div>';
						}
					echo '</div>';
				echo '</div>';
			echo '</div>';
		}
	}
}