<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
/**
 *
 * Categories Widget .
 *
 */
class Zocker_Categories extends Widget_Base {

	public function get_name() {
		return 'zockercategories';
	}

	public function get_title() {
		return __( 'Categories', 'zocker' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'zocker' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'categories_section',
			[
				'label' 	=> __( 'Categories', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'section_title',
			[
				'label' 		=> __( 'Section Title', 'zcker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Caategories', 'zcker' ),
				'placeholder' 	=> __( 'Type your title here', 'zcker' ),
			]
		);

        $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();

		echo '<div class="vs-sidebox bg-major-black">';
			$variable = wp_list_categories( array(
			    'echo' 			=> false,
			    'show_count' 	=> true,
			    'title_li' 		=> '<h3 class="sidebox-title text-white h5">' . __( 'Categories', 'textdomain' ) . '</h3>'
			) );
			$variable = preg_replace( '~\((\d+)\)(?=\s*+<)~', '$1', $variable );
			echo '<ul class="vs-cat-list1 list-style-none">';
				echo $variable;
			echo '</ul>';
		echo '</div>';

	}
}