<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Repeater;
/**
 *
 * Faq Widget .
 *
 */
class Zocker_Faq extends Widget_Base {

	public function get_name() {
		return 'zockerfaq';
	}

	public function get_title() {
		return __( 'Faq', 'zocker' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'zocker' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'faq_section',
			[
				'label'		 	=> __( 'Faq', 'zocker' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'faq_style',
			[
				'label' 		=> __( 'Faq Style', 'zocker' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> '1',
				'options' 		=> [
					'1'  			=> __( 'Style One', 'zocker' ),
					'2' 			=> __( 'Style Two', 'zocker' ),
				],
			]
		);

        $repeater = new Repeater();

        $repeater->add_control(
			'faq_question',
			[
				'label' 	=> __( 'Faq Question', 'zocker' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Ut fermentum massa justo', 'zocker' )
			]
        );

        $repeater->add_control(
			'faq_answer',
			[
				'label' 	=> __( 'Faq Answer', 'zocker' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna .', 'zocker' )
			]
        );

		$this->add_control(
			'faq_repeater',
			[
				'label' 		=> __( 'Faq', 'zocker' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'faq_question'    => __( 'Ut fermentum massa justo', 'zocker' ),
						'faq_answer'      => __( 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna .', 'zocker' ),
					],
					[
						'faq_question'    => __( 'labore et dolore magna', 'zocker' ),
                        'faq_answer'      => __( 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna .', 'zocker' ),
					],
					[
						'faq_question'    => __( 'incididunt ut labore et dolore', 'zocker' ),
                        'faq_answer'      => __( 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna .', 'zocker' ),
					],
				],
				'title_field' 	=> '{{{ faq_question }}}',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
			'faq_style_section',
			[
				'label' => __( 'Faq Question Style', 'zocker' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_control(
			'faq_question_color',
			[
				'label' 	=> __( 'Faq Question Color', 'zocker' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .accordion-style1 .accordion-button,{{WRAPPER}} .accordion-style2 .accordion-header .accordion-title' => 'color: {{VALUE}}',
                ],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'faq_question_typography',
				'label' 	=> __( 'Faq Question Typography', 'zocker' ),
                'selector' 	=> '{{WRAPPER}} .accordion-style1 .accordion-button,{{WRAPPER}} .accordion-style2 .accordion-header .accordion-title',
			]
		);

        $this->add_responsive_control(
			'faq_question_margin',
			[
				'label' 		=> __( 'Faq Question Margin', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .accordion-style1 .accordion-button,{{WRAPPER}} .accordion-style2 .accordion-header .accordion-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'faq_question_padding',
			[
				'label' 		=> __( 'Faq Question Padding', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .accordion-style1 .accordion-button,{{WRAPPER}} .accordion-style2 .accordion-header .accordion-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
		);

		$this->add_control(
			'faq_answer_color',
			[
				'label' 		=> __( 'Faq Answer Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .accordion-body p' => 'color: {{VALUE}}',
                ],
				'separator'		=> 'before'
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'faq_answer_typography',
				'label' 	=> __( 'Faq Answer Typography', 'zocker' ),
                'selector' 	=> '{{WRAPPER}} .accordion-body p',
			]
        );

        $this->add_responsive_control(
			'faq_answer_margin',
			[
				'label' 		=> __( 'Faq Answer Margin', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .accordion-body p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'faq_answer_padding',
			[
				'label' 		=> __( 'Faq Answer Padding', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .accordion-body p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->end_controls_section();

	}

	protected function render() {

        $settings = $this->get_settings_for_display();


        if( ! empty( $settings['faq_repeater'] ) ){
			if( $settings['faq_style'] == '1' ){
	            echo '<div class="vs-accordion accordion-style1 accordion mb-30" id="accordionLayout1">';
					$x = 1;
	                foreach( $settings['faq_repeater'] as $single_data ){
						if( $x == '1' ){
							$ariaexpanded 	= 'true';
							$class 			= 'show';
							$collesed 		= '';
						}else{
							$ariaexpanded 	= 'false';
							$class 			= '';
							$collesed 		= 'collapsed';
						}
	                    echo '<div class="accordion-item">';
	                        if( ! empty( $single_data['faq_question'] ) ){
	                            echo '<div class="accordion-header" id="heading'.esc_attr( $x ).'">';
	                                echo '<button class="accordion-button '.esc_attr( $collesed ).'" type="button" data-bs-toggle="collapse" data-bs-target="#collapse'.esc_attr( $x ).'" aria-expanded="'.esc_attr( $ariaexpanded ).'" aria-controls="collapse'.esc_attr( $x ).'">';
	                                    echo esc_html( $single_data['faq_question'] );
	                                echo '</button>';
	                            echo '</div>';
	                        }
	                        if( ! empty( $single_data['faq_answer'] ) ){
	                            echo '<div id="collapse'.esc_attr( $x ).'" class="accordion-collapse collapse '.esc_attr( $class ).'" aria-labelledby="heading'.esc_attr( $x ).'" data-bs-parent="#accordionLayout1">';
	                                echo '<div class="accordion-body">';
	                                    echo '<p>'.esc_html( $single_data['faq_answer'] ).'</p>';
	                                echo '</div>';
	                            echo '</div>';
	                        }
	                    echo '</div>';
						$x++;
	                }
	            echo '</div>';
			}else{
				echo '<div class="vs-accordion accordion-style2">';
					foreach( $settings['faq_repeater'] as $single_data ){
						echo '<div class="accordion-item">';
							if( ! empty( $single_data['faq_question'] ) ){
								echo '<div class="accordion-header">';
									echo '<h3 class="accordion-title fw-semibold">'.esc_html( $single_data['faq_question'] ).'</h3>';
								echo '</div>';
							}
							if( ! empty( $single_data['faq_answer'] ) ){
								echo '<div class="accordion-body">';
									echo '<p class="accordion-text">'.esc_html( $single_data['faq_answer'] ).'</p>';
								echo '</div>';
							}
						echo '</div>';
					}
				echo '</div>';
			}
        }

	}
}