<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
/**
 *
 * Match Tab Widget .
 *
 */
class Zocker_Match_Tab extends Widget_Base{

	public function get_name() {
		return 'zockermatchtab';
	}

	public function get_title() {
		return __( 'Match Tab', 'zocker' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'zocker' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'video_slider_section',
			[
				'label' 	=> __( 'Match Tab', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'section_subtitle', [
				'label' 		=> __( 'Section Subtitle', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Treaing Match' , 'zocker' ),
				'label_block' 	=> true,
			]
		);

		$this->add_control(
			'section_title', [
				'label' 		=> __( 'Section Tab', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Matchs' , 'zocker' ),
				'label_block' 	=> true,
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'tab_text', [
				'label' 		=> __( 'Tab Text', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'CSGO' , 'zocker' ),
				'label_block' 	=> true,
			]
        );

		$this->add_control(
			'slides',
			[
				'label' 		=> __( 'Slides', 'zocker' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'tab_text' 		=> __( 'CSGO', 'zocker' ),
					],
					[
						'tab_text' 		=> __( 'DOTA2', 'zocker' ),
					],
					[
						'tab_text' 		=> __( 'PUBG', 'zocker' ),
					],
				],
				'title_field' 	=> '{{{ tab_text }}}',
			]
		);

		$match_repeater = new Repeater();

		$match_repeater->add_control(
			'home_team_image', [
				'label' 		=> __( 'Home Team Image', 'zocker' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
        );

		$match_repeater->add_control(
			'home_team_name', [
				'label' 		=> __( 'Home Team Name?', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'ESPORTS MIRAX' , 'zocker' ),
				'label_block' 	=> true,
			]
        );

		$match_repeater->add_control(
			'home_team_url', [
				'label' 		=> __( 'Home Team Url?', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( '#' , 'zocker' ),
				'label_block' 	=> true,
			]
        );

		$match_repeater->add_control(
			'opponent_team_image', [
				'label' 		=> __( 'Opponent Team Image', 'zocker' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
        );
		$match_repeater->add_control(
			'opponent_team_name', [
				'label' 		=> __( 'Opponent Team Name?', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'ESPORTS MIRAX' , 'zocker' ),
				'label_block' 	=> true,
			]
        );
		$match_repeater->add_control(
			'opponent_team_url', [
				'label' 		=> __( 'Opponent Team Url?', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( '#' , 'zocker' ),
				'label_block' 	=> true,
			]
        );
		$match_repeater->add_control(
			'match_time',
			[
				'label' 	=> __( 'Match Time?', 'zocker' ),
				'type' 		=> Controls_Manager::DATE_TIME,
			]
		);

		$match_repeater->add_control(
			'match_info', [
				'label' 		=> __( 'Match Info', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( '3 : 8' , 'zocker' ),
				'label_block' 	=> true,
			]
		);

		$match_repeater->add_control(
			'twitch_live_string_url', [
				'label' 		=> __( 'Twitch Live String Url?', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'https://www.youtube.com/watch?v=_sI_Ps7JSEk' , 'zocker' ),
				'label_block' 	=> true,
			]
		);

		$match_repeater->add_control(
			'youtube_live_string_url', [
				'label' 		=> __( 'Youtube Live String Url?', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'https://www.youtube.com/watch?v=_sI_Ps7JSEk' , 'zocker' ),
				'label_block' 	=> true,
			]
		);

		$match_repeater->add_control(
			'category_one',
			[
				'label' 		=> __( 'Write Category', 'zocker' ),
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> __( 'pubg', 'zocker' ),
				'placeholder' 	=> __( 'Type Your Tab Text Here', 'zocker' ),
				'description' 	=> __( 'Please Write The Same Name As You Write In Tab Text.' )
			]
		);
		$match_repeater->add_control(
			'category_two',
			[
				'label' 		=> __( 'Write Category', 'zocker' ),
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> __( 'csgo', 'zocker' ),
				'placeholder' 	=> __( 'Type Your Tab Text Here', 'zocker' ),
				'description' 	=> __( 'Please Write The Same Name As You Write In Tab Text.' )
			]
		);
		$match_repeater->add_control(
			'category_three',
			[
				'label' 		=> __( 'Write Category', 'zocker' ),
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> __( 'dota2', 'zocker' ),
				'placeholder' 	=> __( 'Type Your Tab Text Here', 'zocker' ),
				'description' 	=> __( 'Please Write The Same Name As You Write In Tab Text.' )
			]
		);

		$this->add_control(
			'match_slides',
			[
				'label' 		=> __( 'Match Slides', 'zocker' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $match_repeater->get_controls(),
				'default' 		=> [
					[
						'home_team_name' 		=> __( 'Esports Mirax', 'zocker' ),
						'opponent_team_name' 	=> __( 'Werewolf', 'zocker' ),
					],
					[
						'home_team_name' 		=> __( 'Kronton', 'zocker' ),
						'opponent_team_name' 	=> __( 'Eclipse', 'zocker' ),
					],
					[
						'home_team_name' 		=> __( 'Warhorns', 'zocker' ),
						'opponent_team_name' 	=> __( 'Lingtingo', 'zocker' ),
					],
				],
				'title_field' 	=> '{{{ home_team_name }}}',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_title_style',
			[
				'label' 	=> __( 'Section Title Style', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'subtitle_color',
			[
				'label' 		=> __( 'Subtitle Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .sub-title1' => 'color: {{VALUE}}',
				],
			]
        );

		$this->add_control(
			'title_color',
			[
				'label' 		=> __( 'Title Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .sec-title1' => 'color: {{VALUE}}!important',
				],
			]
        );

		$this->end_controls_section();

		$this->start_controls_section(
			'tab_style_section',
			[
				'label' 	=> __( 'Tab Style', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

		$this->add_control(
			'tab_bg_color',
			[
				'label' 		=> __( 'Tab Background Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .filter-menu-style1:before' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'tab_color',
			[
				'label' 		=> __( 'Tab Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .filter-menu-style1 button' => 'color: {{VALUE}}',
				],
			]
        );

        $this->add_control(
			'tab_color_hover',
			[
				'label' 		=> __( 'Tab Color Hover', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .filter-menu-style1 button:hover' => 'color: {{VALUE}}',
				],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'tab_typography',
				'label' 	=> __( 'Tab Typography', 'zocker' ),
				'selector' 	=> '{{WRAPPER}} .filter-menu-style1 button',
			]
        );

        $this->add_responsive_control(
			'tab_margin',
			[
				'label' 		=> __( 'Tab Margin', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .filter-menu-style1 button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'tab_padding',
			[
				'label' 		=> __( 'Tab Padding', 'zocker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .filter-menu-style1 button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

        $this->end_controls_section();

		$this->start_controls_section(
			'match_style_section',
			[
				'label' 	=> __( 'Match Style', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

		$this->add_control(
			'match_bg_color',
			[
				'label' 		=> __( 'Match Background Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .vs-match-layout1 .vs-match' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'team_name_color',
			[
				'label' 		=> __( 'Team Name Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .vs-match-layout1 .team-name a' => 'color: {{VALUE}}',
				],
			]
        );

        $this->add_control(
			'match_date_color',
			[
				'label' 		=> __( 'Match Date Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .vs-match-layout1 .match-date' => 'color: {{VALUE}}',
				],
			]
        );

        $this->add_control(
			'match_info_color',
			[
				'label' 		=> __( 'Match Info Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .vs-match-layout1 .match-time' => 'color: {{VALUE}}!important',
				],
			]
        );
        $this->add_control(
			'stream_icon_color',
			[
				'label' 		=> __( 'Stream Icon Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .vs-match-layout1 .icon-btn1' => 'color: {{VALUE}}',
				],
			]
        );
        $this->add_control(
			'twitch_bg_color',
			[
				'label' 		=> __( 'Twitch Background Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .icon-btn1 .fa-twitch:after' => 'background-color: {{VALUE}}',
				],
			]
        );
        $this->add_control(
			'youtube_bg_color',
			[
				'label' 		=> __( 'Youtube Background Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .icon-btn1 .fa-youtube:after' => 'background-color: {{VALUE}}',
				],
			]
        );

        $this->end_controls_section();


	}


	protected function render() {

		$settings = $this->get_settings_for_display();

		$this->add_render_attribute( 'wrapper', 'class', 'mb-15 filter-active row' );

		if( ! empty( $settings['slides'] ) || ! empty( $settings['match_slides'] ) ){

			echo '<section class="vs-match-wrapper vs-match-layout1">';
				echo '<div class="container">';
					echo '<div class="row align-items-center ">';
						echo '<div class="col-lg-5 col-xl-6 text-center text-lg-start">';
							echo '<div class="section-title">';
								if( ! empty( $settings['section_subtitle'] ) ){
									echo '<span class="sub-title1">'.esc_html( $settings['section_subtitle'] ).'</span>';
								}
								if( ! empty( $settings['section_title'] ) ){
									echo '<h2 class="sec-title1 text-white">'.esc_html( $settings['section_title'] ).'</h2>';
								}
							echo '</div>';
						echo '</div>';
						echo '<div class="col-lg-7 col-xl-6 text-center text-lg-end">';
							echo '<div class="filter-menu-style1 filter-menu-active mb-70">';
								echo '<button data-filter="*" class="active">'.esc_html__( 'All', 'zocker' ).'</button>';
								foreach( $settings['slides'] as $tab_data ) {
									$data 			= strtolower( $tab_data['tab_text'] );
									$replace 		= array(' ','-',' - ');
									$with 			= array('','','');
									$final_data 	= str_replace( $replace, $with, $data );
									echo '<button data-filter=".'.esc_attr( $final_data ).'">'.esc_html( $tab_data['tab_text'] ).'</button>';
								}
							echo '</div>';
						echo '</div>';
					echo '</div>';
                    echo '<div '.$this->get_render_attribute_string('wrapper').'>';

                        foreach( $settings['match_slides'] as $singleslide ) {
							$cat_one 			= strtolower( $singleslide['category_one'] );
							$cat_two 			= strtolower( $singleslide['category_two'] );
							$cat_three 			= strtolower( $singleslide['category_three'] );
							$replace 			= array(' ','-',' - ');
							$with 				= array('','','');
							$cat_one_final 		= str_replace( $replace, $with, $cat_one );
							$cat_two_final 		= str_replace( $replace, $with, $cat_two );
							$cat_three_final 	= str_replace( $replace, $with, $cat_three );
							echo '<div class="col-md-6 col-lg-12 grid-item filter-item '.esc_attr( $cat_one_final.' '.$cat_two_final.' '.$cat_three_final ).'">';
		                        echo '<div class="vs-match">';
		                            echo '<div class="row align-items-center justify-content-center justify-content-lg-start">';
		                                echo '<div class="col-lg-3">';
		                                    echo '<div class="match-logo">';
												if( ! empty( $singleslide['home_team_image']['url'] ) ){
			                                        echo '<a href="'.esc_url( $singleslide['home_team_url'] ).'">';
														echo playrex_img_tag( array(
															'url'	=> esc_url( $singleslide['home_team_image']['url'] ),
														) );
													echo '</a>';
												}

		                                        echo '<span class="versus">'.esc_html__( 'vs', 'zocker' ).'</span>';
												if( ! empty( $singleslide['opponent_team_image']['url'] ) ){
			                                        echo '<a href="'.esc_url( $singleslide['opponent_team_url'] ).'">';
														echo playrex_img_tag( array(
															'url'	=> esc_url( $singleslide['opponent_team_image']['url'] ),
														) );
													echo '</a>';
												}
		                                    echo '</div>';
		                                echo '</div>';
		                                echo '<div class="col-lg">';
		                                    echo '<div class="match-about pl-35">';
		                                        echo '<h3 class="team-name h5 text-white mb-1 mb-lg-2"><a href="'.esc_url( $singleslide['home_team_url'] ).'">'.esc_html( $singleslide['home_team_name'] ).'</a> <span class="text-theme">'.esc_html__( 'vs', 'zocker' ).'</span> <a href="'.esc_url( $singleslide['opponent_team_url'] ).'">'.esc_html( $singleslide['opponent_team_name'] ).'</a></h3>';
												$match_date = $singleslide['match_time'];
		                                        echo '<p class="match-date mb-0">'.esc_html( $match_date ).'</p>';
		                                    echo '</div>';
		                                echo '</div>';
		                                echo '<div class="col-auto col-xl-2">';
											if( ! empty( $singleslide['match_info'] ) ){
			                                    echo '<div class="match-time text-white">'.esc_html( $singleslide['match_info'] ).'</div>';
											}
		                                echo '</div>';
		                                echo '<div class="col-auto col-xl-2 text-end ">';
											if( ! empty( $singleslide['twitch_live_string_url'] ) ){
			                                    echo '<a href="'.esc_url( $singleslide['twitch_live_string_url'] ).'" class="icon-btn1 popup-video"><i class="fab fa-twitch"></i></a>';
											}
											if( ! empty( $singleslide['youtube_live_string_url'] ) ){
			                                    echo '<a href="'.esc_url( $singleslide['youtube_live_string_url'] ).'" class="icon-btn1 popup-video"><i class="fab fa-youtube"></i></a>';
											}
		                                echo '</div>';
		                            echo '</div>';
		                        echo '</div>';
		                    echo '</div>';
                        }
                    echo '</div>';
	            echo '</div>';
		    echo '</section>';
		}
	}

}