<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Background;
/**
 *
 * Newsletter Widget .
 *
 */
class Zocker_Newsletter extends Widget_Base {

	public function get_name() {
		return 'zockernewsletterform';
	}

	public function get_title() {
		return __( 'Newsletter', 'zocker' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'zocker' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'newsletter_content',
			[
				'label' 	=> __( 'Newsletter', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'newsletter_style',
			[
				'label' 		=> __( 'Newsletter Style', 'zocker' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'one',
				'options' 		=> [
					'one'  			=> __( 'Style One', 'zocker' ),
					'two' 			=> __( 'Style Two', 'zocker' ),
				],
			]
		);

		$this->add_control(
			'image',
			[
				'label' 		=> __( 'Set Image', 'zocker' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' 	=> Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'section_title',
			[
				'label' 		=> __( 'Section Title', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'SUBSCRIBE TO NEWSLETTER', 'zocker' ),
			]
		);

		$this->add_control(
			'newsletter_placeholder',
			[
				'label' 		=> __( 'Newsletter Placeholder Text', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Enter Your Email', 'zocker' ),
			]
		);

		$this->add_control(
			'newsletter_button',
			[
				'label' 		=> __( 'Newsletter Button Text', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Subscribe', 'zocker' ),
			]
		);

        $this->end_controls_section();

		$this->start_controls_section(
			'faq_section_style',
			[
				'label' 	=> __( 'Newsletter Style', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

		$this->add_control(
			'title_color',
			[
				'label' 		=> __( 'Title Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .sidebox-newsletter h4,{{WRAPPER}} .vs-newsletter-wrapper h2' => 'color: {{VALUE}}!important',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'title_typography',
				'label' 		=> __( 'Title Typography', 'zocker' ),
				'selector' 		=> '{{WRAPPER}} .sidebox-newsletter h4,{{WRAPPER}} .vs-newsletter-wrapper h2',
			]
		);

		$this->add_control(
			'button_color',
			[
				'label' 		=> __( 'Button Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .sidebox-newsletter button,{{WRAPPER}} .vs-btn.style1' => 'color: {{VALUE}}!important',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'button_typography',
				'label' 		=> __( 'Button Typography', 'zocker' ),
				'selector' 		=> '{{WRAPPER}} .sidebox-newsletter button,{{WRAPPER}} .vs-btn.style1',
			]
		);

		$this->end_controls_section();
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		if( $settings['newsletter_style'] == 'one' ){
			echo '<div class="vs-sidebox" data-overlay="dark" data-opacity="8">';
                echo '<form action="#" class="sidebox-newsletter text-center z-index-common newsletter-form">';
					if( ! empty( $settings['image']['url'] ) ){
	                    echo '<div class="form-icon mb-15">';
							echo playrex_img_tag( array(
								'url'	=> esc_url( $settings['image']['url'] ),
							) );
	                    echo '</div>';
					}
					if( ! empty( $settings['section_title'] ) ){
	                    echo '<h4 class="h5 text-white font-theme3 mb-3">'.esc_html( $settings['section_title'] ).'</h4>';
					}
                    echo '<input required type="email" class="form-control" placeholder="'.esc_attr( $settings['newsletter_placeholder'] ).'">';
                    echo '<button type="submit">'.esc_html( $settings['newsletter_button'] ).'</button>';
                echo '</form>';
            echo '</div>';
		}else{
			echo '<section class="vs-newsletter-wrapper  ">';
		        echo '<div class="container">';
		            echo '<div class="position-relative">';
		                echo '<div class="inner-wrapper position-absolute top-50 start-0 end-0 translate-middle-y px-50 py-50">';
		                    echo '<div class="row align-items-center justify-content-center justify-content-xl-start">';
		                        echo '<div class="text-center text-xl-start col-xl-6 mb-4 mb-xl-0">';
		                            echo '<h2 class="mb-0 text-white h3 font-theme3">';
										if( ! empty( $settings['image']['url'] ) ){
											echo playrex_img_tag( array(
												'url'	=> esc_url( $settings['image']['url'] ),
												'class' => 'align-middle',
											) );
										}
										if( ! empty( $settings['section_title'] ) ){
											echo esc_html( $settings['section_title'] );
										}
									echo '</h2>';
		                        echo '</div>';
		                        echo '<div class="col-sm-11 col-lg-7 col-xl-6 text-center text-md-end">';
		                            echo '<form action="#" class="newsletter-style2 newsletter-form">';
										echo '<div class="newsletter-wrapper d-md-flex">';
			                                echo '<input type="email" class="form-control" placeholder="'.esc_attr( $settings['newsletter_placeholder'] ).'">';
			                                echo '<button class="vs-btn style1 mt-3 mt-md-0">'.esc_html( $settings['newsletter_button'] ).'</button>';
										echo '</div>';
		                            echo '</form>';
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</section>';
		}
	}
}