<?php
    use \Elementor\Widget_Base;
    use \Elementor\Controls_Manager;
    use \Elementor\Group_Control_Typography;
    use \Elementor\Group_Control_Background;
    use \Elementor\Group_Control_Text_Shadow;
    use \Elementor\Group_Control_Box_Shadow;
    use \Elementor\Group_Control_Border;
    use \Elementor\Utils;
    /**
     *
     * Team Widget .
     *
     */
class Zocker_Team extends Widget_Base {

	public function get_name() {
		return 'zockerteam';
	}

	public function get_title() {
		return __( 'Teams', 'zocker' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'zocker' ];
	}

	// Add The Input For User
	protected function register_controls(){
		$this->start_controls_section(
			'teams_content',
			[
				'label'		=> __( 'Team Content','zocker' ),
				'tab'		=> Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'team_column',
			[
				'label' 	=> __( 'Team Column', 'zocker' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> 'three',
				'options' 	=> [
					'full'  	=> __( 'Full Width', 'zocker' ),
					'two'  		=> __( 'Two Column', 'zocker' ),
					'three' 	=> __( 'Three Column', 'zocker' ),
					'four' 		=> __( 'Four Column', 'zocker' ),
					'six' 		=> __( 'Six Column', 'zocker' ),
				],
			]
		);
		$this->add_control(
			'post_from',
			[
				'label' 		=> __( 'Post From', 'zocker' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'all',
				'options' 		=> [
					'all'  			=> __( 'All', 'zocker' ),
					'categories' 	=> __( 'Categories', 'zocker' ),
				],
			]
		);
		$this->add_control(
			'categories',
			[
				'label' 		=> __( 'Post From', 'zocker' ),
				'type' 			=> Controls_Manager::SELECT,
				'options' 		=> zocker_teams_category(),
				'condition' 	=> ['post_from' => 'categories'],
			]
		);
		$this->add_control(
			'post_limit',
			[
				'label' 		=> __( 'Post Limit', 'zocker' ),
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> __( 'Only Number Work. Like 4 or 6', 'zocker' ),
			]
		);
		$this->add_control(
			'order',
			[
				'label' 		=> __( 'Order', 'zocker' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'ASC',
				'options' 		=> [
					'ASC'  			=> __( 'Ascending', 'zocker' ),
					'DESC' 			=> __( 'Descending', 'zocker' ),
				],
			]
		);
		$this->add_control(
			'order_by',
			[
				'label' 		=> __( 'Order By', 'zocker' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'name',
				'options' 		=> [
					'none'  		=> __( 'None', 'zocker' ),
					'type' 			=> __( 'Type', 'zocker' ),
					'title' 		=> __( 'Title', 'zocker' ),
					'name' 			=> __( 'Name', 'zocker' ),
					'name' 			=> __( 'Name', 'zocker' ),
				],
			]
		);

		$this->end_controls_section();

        $this->start_controls_section(
            'team_design_style',
            [
                'label'			=> __( 'Style','zocker' ),
                'tab' 			=> Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' 		=> 'background',
				'label' 	=> __( 'Background', 'zocker' ),
				'types' 	=> [ 'classic', 'gradient', 'video' ],
				'selector' 	=> '{{WRAPPER}} .vs-team',
			]
		);

		$this->add_control(
			'name_color',
			[
				'label' 		=> __( 'Team Name Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .team-name' => 'color: {{VALUE}} !important',
				],
				'separator'		=> 'before',
			]
		);

		$this->add_control(
			'name_hover_color',
			[
				'label' 		=> __( 'Team Name Hover Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .team-name a:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'team_name_typography',
				'label' 		=> __( 'Team Name Typography', 'zocker' ),
                'selector' 	    => '{{WRAPPER}} .team-name',
			]
		);

		$this->add_control(
			'player_number_color',
			[
				'label' 		=> __( 'Player Number Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .team-degi' => 'color: {{VALUE}}!important',
				],
				'separator'		=> 'before'
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'player_number_typography',
				'label' 		=> __( 'Player Number Typography', 'zocker' ),
                'selector' 	    => '{{WRAPPER}} .team-degi',
			]
		);

		$this->end_controls_section();


	}

	// Output For User
	protected function render(){
		$settings = $this->get_settings_for_display();

        if( $settings['team_column'] == 'two' ){
            $this->add_render_attribute( 'column','class','col-sm-6 col-md-6 col-lg-6 col-xl-6');
        }elseif( $settings['team_column'] == 'three' ){
            $this->add_render_attribute( 'column','class','col-sm-6 col-md-6 col-lg-4 col-xl-4');
        }elseif( $settings['team_column'] == 'four' ){
            $this->add_render_attribute( 'column','class','col-sm-6 col-md-6 col-lg-4 col-xl-3');
        }elseif( $settings['team_column'] == 'full' ){
            $this->add_render_attribute( 'column','class','col-sm-6 col-md-6 col-lg-12 col-xl-12');
        }else{
            $this->add_render_attribute( 'column','class','col-sm-6 col-md-6 col-lg-2 col-xl-2');
        }

        $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;

		echo '<!-- team style one -->';
			if( $settings['post_from'] == "categories" ){
			   $team = array(
				   'post_type'         => 'zocker_team',
				   'posts_per_page'    => esc_attr( $settings['post_limit'] ),
				   'order'             => esc_attr( $settings['order'] ),
				   'orderby'           => esc_attr( $settings['order_by'] ),
				   'tax_query'         => array(
						    array(
							   'taxonomy'  => 'team_category',
							   'field'     => 'slug',
							   'terms'     => esc_attr( $settings['categories'] ),
						    )
					),
                    'paged'             => $paged,
			   );
		    }else{
				$team = array(
				   'post_type'         => 'zocker_team',
				   'posts_per_page'    => esc_attr( $settings['post_limit'] ),
				   'order'             => esc_attr( $settings['order'] ),
				   'orderby'           => esc_attr( $settings['order_by'] ),
                   'paged'             => $paged,
			   );
		    }

		$zocker_team = new WP_Query( $team );

		$this->add_render_attribute( 'wrapper', 'class', 'row justify-content-center' );

		if( $zocker_team->have_posts() ){
			echo '<div class="vs-team-wrapper vs-team-layout1">';
				echo '<div class="container">';
					echo '<div '.$this->get_render_attribute_string('wrapper').'>';
						while( $zocker_team->have_posts() ):
							$zocker_team->the_post();
							echo '<div '.$this->get_render_attribute_string('column').'>';
								echo '<div class="vs-team bg-fluid">';
			                        if( has_post_thumbnail( ) ){
										echo '<div class="team-img mb-35">';
				                            echo '<a href="'.esc_url( get_permalink() ).'">';
												the_post_thumbnail();
											echo '</a>';
				                        echo '</div>';
									}
									if( get_the_title() ){
				                        echo '<h3 class="team-name h5 text-white mb-0"><a href="'.esc_url( get_permalink() ).'">'.esc_html( get_the_title() ).'</a></h3>';
									}
									if( ! empty( zocker_meta( 'zocker_team_player' ) ) ){
			                            echo '<span class="team-team-degi text-light-white fs-xs">'.esc_html( zocker_meta( 'zocker_team_player' ) ).'</span>';
									}
			                    echo '</div>';
							echo '</div>';
						endwhile;
						wp_reset_postdata();
					echo '</div>';

					$total_pages = $zocker_team->max_num_pages;
					if ( $total_pages > 1 ){
						echo '<div class="pagination-wrapper pagination-layout1 mt-lg-30 mb-30">';
							$current_page = max( 1, get_query_var( 'paged' ) );

							echo paginate_links(array(
								'base'          => get_pagenum_link(1) . '%_%',
								'format'        => '/page/%#%',
								'current'       => $current_page,
								'total'         => $total_pages,
								'prev_text'     => '<i class="fas fa-chevron-left"></i>',
								'next_text'     => '<i class="fas fa-chevron-right"></i>',
								'type'          => 'list',
							));
						echo '</div>';
					}
				echo '</div>';
			echo '</div> <!-- Skill Area -->';
		}
	}
}