<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
/**
 *
 * Tournaments Widget .
 *
 */
class Zocker_Tournaments extends Widget_Base {

	public function get_name() {
		return 'zockertournaments';
	}

	public function get_title() {
		return __( 'Tournaments', 'zocker' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'zocker' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'tournaments_section',
			[
				'label' 	=> __( 'Tournaments', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'game_image',
			[
				'label' 	=> __( 'Choose Image', 'zocker' ),
				'type' 		=> Controls_Manager::MEDIA,
				'default' 	=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'tournament_name',
			[
				'label' 		=> __( 'Tournament Name', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( '2021 WORLD CHAMPIONSHIP', 'zocker' ),
				'placeholder' 	=> __( 'Type your title here', 'zocker' ),
			]
		);

        $repeater = new Repeater();

		$repeater->add_control(
			'info_head',
			[
				'label' 		=> __( 'Info Head', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Date', 'zocker' ),
				'placeholder' 	=> __( 'Type your title here', 'zocker' ),
			]
		);
		$repeater->add_control(
			'info_description',
			[
				'label' 		=> __( 'Info Description', 'zocker' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'June 1 - October 31, 2021', 'zocker' ),
				'placeholder' 	=> __( 'Type your description here', 'zocker' ),
			]
		);

		$this->add_control(
			'tournaments_reapeter',
			[
				'label' 		=> __( 'Tournaments', 'zocker' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'info_head' 		=> __( 'Date:', 'zocker' ),
						'info_description' 	=> __( 'June 1 - October 31, 2021', 'zocker' ),
					],
					[
						'info_head' 		=> __( 'Game:', 'zocker' ),
						'info_description' 	=> __( 'Dota2', 'zocker' ),
					],
					[
						'info_head' 		=> __( 'Teams:', 'zocker' ),
						'info_description' 	=> __( '280', 'zocker' ),
					],
					[
						'info_head' 		=> __( 'Prize Pool:', 'zocker' ),
						'info_description' 	=> __( '$120,000', 'zocker' ),
					],
				]
			]
		);

        $this->end_controls_section();

		$this->start_controls_section(
			'style_section',
			[
				'label' 	=> __( 'Style', 'zocker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'title_color',
			[
				'label' 		=> __( 'Title Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .events-name' => 'color: {{VALUE}} !important',
                ],
			]
        );

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'title_typography',
				'label' 	=> __( 'Title Typography', 'zocker' ),
                'selector' 	=> '{{WRAPPER}} .events-name',
			]
        );

		$this->add_control(
			'event_head_color',
			[
				'label' 		=> __( 'Event Head Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .events-list span.text-white' => 'color: {{VALUE}} !important',
                ],
				'separator'		=> 'before'
			]
        );

		$this->add_control(
			'event_description_color',
			[
				'label' 		=> __( 'Event Description Color', 'zocker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .events-list li.text-light2' => 'color: {{VALUE}} !important',
                ],
			]
        );

		$this->end_controls_section();

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		echo '<div class="vs-events-wrapper events-layout1">';
			echo '<div class="vs-events d-lg-flex">';
				if( ! empty( $settings['game_image']['url'] ) ){
					echo '<div class="media-img">';
						echo playrex_img_tag( array(
							'url'	=> esc_url( $settings['game_image']['url'] )
						) );
					echo '</div>';
				}
				echo '<div class="media-body align-self-center">';
					if( ! empty( $settings['tournament_name'] ) ){
						echo '<h3 class="events-name h5 text-white">'.esc_html( $settings['tournament_name'] ).'</h3>';
					}
					if( ! empty( $settings['tournaments_reapeter'] ) ){
						echo '<ul class="events-list list-style-none">';
							foreach( $settings['tournaments_reapeter'] as $single_date ){
								echo '<li class="text-light2"><span class="text-white">';
								if( ! empty( $single_date['info_head'] ) ){
									echo esc_html( $single_date['info_head'] );
								}
								echo '</span>';
								if( ! empty( $single_date['info_description'] ) ){
									echo esc_html( $single_date['info_description'] );
								}
								echo '</li>';
							}
						echo '</ul>';
					}
				echo '</div>';
			echo '</div>';
		echo '</div>';
	}
}