<?php
/**
* @version  1.0
* @package  Zocker
* @author   Vecurosoft <support@vecurosoft.com>
*
* Websites: http://www.vecurosoft.com
*
*/

/**************************************
* Creating Recent Post Widget
***************************************/

class zocker_blog_post_tab extends WP_Widget {

        function __construct() {

            parent::__construct(
                // Base ID of your widget
                'zocker_blog_post_tab',

                // Widget name will appear in UI
                esc_html__( 'Zocker :: Blog Post Tab', 'zocker' ),

                // Widget description
                array(
                    'classname'                     => '',
                    'customize_selective_refresh'   => true,
                    'description'                   => esc_html__( 'Add Recent Posts Widget', 'zocker' ),
                )
            );
        }

        // This is where the action happens
        public function widget( $args, $instance ) {

            $title      = apply_filters( 'widget_title', $instance['title'] );
            $show_date  = isset( $instance['show_date'] ) ? $instance['show_date'] : false;
            //Post Count
            if ( isset( $instance[ 'post_count' ] ) ) {
                $post_count = $instance[ 'post_count' ];
            }else {
                $post_count = '2';
            }

            //before and after widget arguments are defined by themes
            echo $args['before_widget'];

                if( !empty( $title  ) ){
                    echo $args['before_title'];
                        echo esc_html( $title );
                    echo $args['after_title'];
                }

                $query_args = array(
                    "post_type"             => "post",
                    "posts_per_page"        => esc_attr( $post_count ),
                    "post_status"           => "publish",
                    "ignore_sticky_posts"   => true
                );
                $query_args2 = array(
                    "post_type"             => "post",
                    "posts_per_page"        => esc_attr( $post_count ),
                    "post_status"           => "publish",
                    "orderby"               => "comment_count",
                    "ignore_sticky_posts"   => true
                );
                $query_args3 = array(
                    "post_type"             => "post",
                    "posts_per_page"        => esc_attr( $post_count ),
                    "post_status"           => "publish",
                    "meta_key"              => "post_views_count",
                    "orderby"               => "meta_value_num",
                    "ignore_sticky_posts"   => true
                );
                
                $recentposts        = new WP_Query( $query_args );
                $mostcommentedposts = new WP_Query( $query_args2 );
                $popularposts       = new WP_Query( $query_args3 );
                
                echo '<div class="vs-sidebox-v2 px-0 pb-0 pt-20 mb-0">';
                    echo '<div class="nav nav-fill  tab-menu1 tab-indicator bg-white" role="tablist">';
                        if( $recentposts->have_posts(  ) ) {
                            echo '<a class="nav-link active" id="recent-tab" data-bs-toggle="tab" href="#recent" role="tab" aria-controls="recent" aria-selected="true">'.esc_html__( 'Recent', 'zocker' ).'</a>';
                        }
                        if( $mostcommentedposts->have_posts(  ) ) {
                            echo '<a class="nav-link" id="popular-tab" data-bs-toggle="tab" href="#popular" role="tab" aria-controls="popular" aria-selected="false">'.esc_html__( 'Most Commented', 'zocker' ).'</a>';
                        }
                        if( $popularposts->have_posts(  ) ) {
                            echo '<a class="nav-link" id="latest-tab" data-bs-toggle="tab" href="#latest" role="tab" aria-controls="latest" aria-selected="false">'.esc_html__( 'Popular', 'zocker' ).'</a>';
                        }
                    echo '</div>';
                echo '</div>';
                echo '<div class="tab-content">';
                    if( $recentposts->have_posts(  ) ) {
                        echo '<div class="tab-pane show active" id="recent" role="tabpanel" aria-labelledby="recent-tab">';
                            echo '<div class="post-thumb-style1 vs-sidebox-v2 pb-1">';
                                while( $recentposts->have_posts(  ) ) {
                                    $recentposts->the_post();
                                    echo '<div class="vs-blog d-flex gap-3">';
                                        echo '<div class="media-img">';
                                            echo '<a href="'.esc_url( get_permalink( ) ).'">';
                                                the_post_thumbnail( 'blog-sidebar-size' );
                                            echo '</a>';
                                        echo '</div>';
                                        echo '<div class="media-body align-self-center">';
                                            echo '<h4 class="h5 blog-title font-theme lh-base mb-0"><a href="'.esc_url( get_permalink( ) ).'">'.wp_kses_post( wp_trim_words( get_the_title(), 5, '' ) ).'</a></h4>';
                                            if( $show_date ){
                                                echo '<div class="blog-meta link-inherit fs-xs mt-1">';
                                                    echo '<a href="'.esc_url( zocker_blog_date_permalink() ).'"><i class="fal fa-calendar-alt text-theme2"></i>'.esc_html( get_the_time( 'd F, Y' ) ).'</a>';
                                                echo '</div>';
                                            }
                                        echo '</div>';
                                    echo '</div>';
                                }
                                wp_reset_postdata();
                            echo '</div>';
                        echo '</div>';
                    }
                    if( $mostcommentedposts->have_posts() ){
                        echo '<div class="tab-pane" id="popular" role="tabpanel" aria-labelledby="popular-tab">';
                            echo '<div class="post-thumb-style1 vs-sidebox-v2 pb-1">';
                                while( $mostcommentedposts->have_posts(  ) ) {
                                    $mostcommentedposts->the_post();
                                    echo '<div class="vs-blog d-flex gap-3">';
                                        echo '<div class="media-img">';
                                            echo '<a href="'.esc_url( get_permalink( ) ).'">';
                                                the_post_thumbnail( 'blog-sidebar-size' );
                                            echo '</a>';
                                        echo '</div>';
                                        echo '<div class="media-body align-self-center">';
                                            echo '<h4 class="h5 blog-title font-theme lh-base mb-0"><a href="'.esc_url( get_permalink( ) ).'">'.wp_kses_post( wp_trim_words( get_the_title(), 5, '' ) ).'</a></h4>';
                                            if( $show_date ){
                                                echo '<div class="blog-meta link-inherit fs-xs mt-1">';
                                                    echo '<a href="'.esc_url( zocker_blog_date_permalink() ).'"><i class="fal fa-calendar-alt text-theme2"></i>'.esc_html( get_the_time( 'd F, Y' ) ).'</a>';
                                                echo '</div>';
                                            }
                                        echo '</div>';
                                    echo '</div>';
                                }
                                wp_reset_postdata();
                            echo '</div>';
                        echo '</div>';
                    }
                    if( $popularposts->have_posts() ){
                        echo '<div class="tab-pane" id="latest" role="tabpanel" aria-labelledby="latest-tab">';
                            echo '<div class="post-thumb-style1 vs-sidebox-v2 pb-1">';
                                while( $popularposts->have_posts(  ) ) {
                                    $popularposts->the_post();
                                    echo '<div class="vs-blog d-flex gap-3">';
                                        echo '<div class="media-img">';
                                            echo '<a href="'.esc_url( get_permalink( ) ).'">';
                                                the_post_thumbnail( 'blog-sidebar-size' );
                                            echo '</a>';
                                        echo '</div>';
                                        echo '<div class="media-body align-self-center">';
                                            echo '<h4 class="h5 blog-title font-theme lh-base mb-0"><a href="'.esc_url( get_permalink( ) ).'">'.wp_kses_post( wp_trim_words( get_the_title(), 5, '' ) ).'</a></h4>';
                                            if( $show_date ){
                                                echo '<div class="blog-meta link-inherit fs-xs mt-1">';
                                                    echo '<a href="'.esc_url( zocker_blog_date_permalink() ).'"><i class="fal fa-calendar-alt text-theme2"></i>'.esc_html( get_the_time( 'd F, Y' ) ).'</a>';
                                                echo '</div>';
                                            }
                                        echo '</div>';
                                    echo '</div>';
                                }
                                wp_reset_postdata();
                            echo '</div>';
                        echo '</div>';
                    }
                echo '</div>';
            echo $args['after_widget'];
        }

        // Widget Backend
        public function form( $instance ) {

            //Title
            if ( isset( $instance[ 'title' ] ) ) {
                $title = $instance[ 'title' ];
            }else {
                $title = '';
            }

            //Post Count
            if ( isset( $instance[ 'post_count' ] ) ) {
                $post_count = $instance[ 'post_count' ];
            }else {
                $post_count = '4';
            }

            // Show Date
            $show_date = isset( $instance['show_date'] ) ? (bool) $instance['show_date'] : false;

            // Widget admin form
            ?>
            <p>
                <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:' ,'zocker'); ?></label>
                <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
            </p>
            <p>
                <label for="<?php echo $this->get_field_id( 'post_count' ); ?>"><?php _e( 'Number of Posts to show:' ,'zocker'); ?></label>
                <input class="widefat" id="<?php echo $this->get_field_id( 'post_count' ); ?>" name="<?php echo $this->get_field_name( 'post_count' ); ?>" type="text" value="<?php echo esc_attr( $post_count ); ?>" />
            </p>
            <p>
                <input class="checkbox" type="checkbox"<?php checked( $show_date ); ?> id="<?php echo $this->get_field_id( 'show_date' ); ?>" name="<?php echo $this->get_field_name( 'show_date' ); ?>" />
    		    <label for="<?php echo $this->get_field_id( 'show_date' ); ?>"><?php _e( 'Display post date?' ); ?></label>
            </p>
            <?php
        }


        // Updating widget replacing old instances with new
        public function update( $new_instance, $old_instance ) {

            $instance = array();
            $instance['title'] 	        = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
            $instance['post_count'] 	= ( ! empty( $new_instance['post_count'] ) ) ? strip_tags( $new_instance['post_count'] ) : '4';
            $instance['show_date']      = isset( $new_instance['show_date'] ) ? (bool) $new_instance['show_date'] : false;

            return $instance;
        }
    } // Class zocker_blog_post_tab ends here


    // Register and load the widget
    function zocker_blog_post_tab() {
        register_widget( 'zocker_blog_post_tab' );
    }
    add_action( 'widgets_init', 'zocker_blog_post_tab' );