<?php
/**
 * @version  1.0
 * @package  zocker
 * @author   Vecurosoft <support@vecurosoft.com>
 *
 * Websites: http://www.vecurosoft.com
 *
 */

/**************************************
*Creating Contact Information Widget
***************************************/

class zocker_contact_info_widget extends WP_Widget {
	function __construct() {
		parent::__construct(
			// Base ID of your widget
			'zocker_contact_info_widget',
			// Widget name will appear in UI
			esc_html__( 'Zocker :: Contact Info', 'zocker' ),
			// Widget description
			array(
				'description'	 => esc_html__( 'Add Contact Info', 'zocker' ),
				'classname'		 => 'widget_contact',
			)
		);
	}

// This is where the action happens
public function widget( $args, $instance ) {
	$title 			= apply_filters( 'widget_title', $instance['title'] );
	$mobile 		= apply_filters( 'widget_mobile', $instance['mobile'] );
	$fax 			= apply_filters( 'widget_fax', $instance['fax'] );
	$email 			= apply_filters( 'widget_email', $instance['email'] );
	$website_text 	= apply_filters( 'widget_website_text', $instance['website_text'] );
	$website_url 	= apply_filters( 'widget_website_url', $instance['website_url'] );
	$address 		= apply_filters( 'widget_address', $instance['address'] );

	//Remove ' ' , '-', ' - ' from email
	$email 			= is_email( $email );
	$replace 		= array(' ','-',' - ');
	$with 			= array('','','');
	$emailurl 		= str_replace( $replace, $with, $email );

	$mobileurl 	    = str_replace( $replace, $with, $mobile );
	$faxurl 	    = str_replace( $replace, $with, $fax );
	//before and after widget arguments are defined by themes
	echo $args['before_widget'];
    echo '<!-- About Widget Start -->';
    	if( !empty( $title ) || !empty( $address ) ||  !empty( $email ) || ! empty( $mobile ) || ! empty( $fax ) ):

			if ( ! empty( $title ) ){
				echo $args['before_title'] . $title . $args['after_title'];
			}
			echo '<div class="vs-widget-about">';
				if( ! empty( $address ) ){
				  	echo '<p class="contact-info">';
				  	echo '<i class="fal fa-map-marker-alt text-white"></i>';
					  echo wp_kses_post( $address );
				  	echo '</p>';
				}
				if( ! empty( $mobile ) ){
					echo '<p class="contact-info">';
						echo '<i class="fal fa-phone text-white"></i>';
						echo '<a href="'.esc_attr( 'tel:'.$mobileurl ).'">'.esc_html( $mobile ).'</a>';
					echo '</p>';
				}
				if( ! empty( $fax ) ){
					echo '<p class="contact-info">';
						echo '<i class="fal fa-fax text-white"></i>';
						echo '<a href="'.esc_attr( 'tel:'.$faxurl ).'">'.esc_html( $fax ).'</a>';
					echo '</p>';
				}
				if( ! empty( $email ) ){
	                echo '<p class="contact-info">';
						echo '<i class="fal fa-envelope text-white"></i>';
	                    echo '<a href="'.esc_attr( 'mailto:'.$emailurl ).'">'.esc_html( $email ).'</a>';
	                echo '</p>';
	            }
				if( ! empty( $website_text ) ){
	                echo '<p class="contact-info">';
						echo '<i class="fal fa-globe text-white"></i>';
	                    echo '<a href="'.esc_url( $website_url ).'">'.esc_html( $website_text ).'</a>';
	                echo '</p>';
	            }
			echo '</div>';
    	endif;
	echo $args['after_widget'];
    echo '<!-- About Widget End -->';


}

// Widget Backend
public function form( $instance ) {
	//Title
	if ( isset( $instance[ 'title' ] ) ) {
		$title = $instance[ 'title' ];
	}else {
		$title = esc_html__( 'Contect Us', 'zocker' );
	}

	// Address
	if ( isset( $instance[ 'address' ] ) ) {
		$address = $instance[ 'address' ];
	}else {
		$address = '';
	}

	// E-mail one
	if ( isset( $instance[ 'email' ] ) ) {
		$email = $instance[ 'email' ];
	}else {
		$email = '';
	}
	// Mobile
    if ( isset( $instance[ 'mobile' ] ) ) {
        $mobile = $instance[ 'mobile' ];
    }else {
        $mobile = '';
    }
	// Fax
    if ( isset( $instance[ 'fax' ] ) ) {
        $fax = $instance[ 'fax' ];
    }else {
        $fax = '';
    }
	// Website Link
    if ( isset( $instance[ 'website_text' ] ) ) {
        $website_text = $instance[ 'website_text' ];
    }else {
        $website_text = '';
    }
	// Website Url
    if ( isset( $instance[ 'website_url' ] ) ) {
        $website_url = $instance[ 'website_url' ];
    }else {
        $website_url = '';
    }
?>
	<p>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>">
			<?php
				_e( 'Title:' ,'zocker');
			?>
		</label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
	</p>
	<p>
        <label for="<?php echo $this->get_field_id( 'address' ); ?>">
            <?php
                _e( 'Address:' ,'zocker');
            ?>
        </label>
        <input class="widefat" id="<?php echo $this->get_field_id( 'address' ); ?>" name="<?php echo $this->get_field_name( 'address' ); ?>" type="text" value="<?php echo esc_attr( $address ); ?>" />
    </p>
	<p>
		<label for="<?php echo $this->get_field_id( 'email' ); ?>">
			<?php
				_e( 'Email :' ,'zocker');
			?>
		</label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'email' ); ?>" name="<?php echo $this->get_field_name( 'email' ); ?>" type="text" value="<?php echo esc_attr( $email ); ?>" />
	</p>
	<p>
		<label for="<?php echo $this->get_field_id( 'mobile' ); ?>">
			<?php
				_e( 'Mobile :' ,'zocker');
			?>
		</label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'mobile' ); ?>" name="<?php echo $this->get_field_name( 'mobile' ); ?>" type="text" value="<?php echo esc_attr( $mobile ); ?>" />
	</p>
	<p>
		<label for="<?php echo $this->get_field_id( 'fax' ); ?>">
			<?php
				_e( 'Fax :' ,'zocker');
			?>
		</label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'fax' ); ?>" name="<?php echo $this->get_field_name( 'fax' ); ?>" type="text" value="<?php echo esc_attr( $fax ); ?>" />
	</p>
	<p>
		<label for="<?php echo $this->get_field_id( 'website_text' ); ?>">
			<?php
				_e( 'Website Text :' ,'zocker');
			?>
		</label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'website_text' ); ?>" name="<?php echo $this->get_field_name( 'website_text' ); ?>" type="text" value="<?php echo esc_attr( $website_text ); ?>" />
	</p>
	<p>
		<label for="<?php echo $this->get_field_id( 'website_url' ); ?>">
			<?php
				_e( 'Website Url :' ,'zocker');
			?>
		</label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'website_url' ); ?>" name="<?php echo $this->get_field_name( 'website_url' ); ?>" type="text" value="<?php echo esc_attr( $website_url ); ?>" />
	</p>


<?php
}
// Updating widget replacing old instances with new
public function update( $new_instance, $old_instance ) {
	$instance = array();

	$instance['title'] 	= ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';

	$instance['address'] 	= ( ! empty( $new_instance['address'] ) ) ? strip_tags( $new_instance['address'] ) : '';

	$instance['email'] 	= ( ! empty( $new_instance['email'] ) ) ? strip_tags( $new_instance['email'] ) : '';

	$instance['mobile']  = ( ! empty( $new_instance['mobile'] ) ) ? strip_tags( $new_instance['mobile'] ) : '';
	
	$instance['fax']  = ( ! empty( $new_instance['fax'] ) ) ? strip_tags( $new_instance['fax'] ) : '';
	
	$instance['website_text']  = ( ! empty( $new_instance['website_text'] ) ) ? strip_tags( $new_instance['website_text'] ) : '';
	
	$instance['website_url']  = ( ! empty( $new_instance['website_url'] ) ) ? strip_tags( $new_instance['website_url'] ) : '';
	
	return $instance;
}
}
// Class zocker_subscribe_widget ends here

// Register and load the widget
function zocker_contact_info_load_widget() {
	register_widget( 'zocker_contact_info_widget' );
}
add_action( 'widgets_init', 'zocker_contact_info_load_widget' );