<?php
/**
* @version  1.0
* @package  zocker
* @author   Vecurosoft <support@vecurosoft.com>
*
* Websites: http://www.vecurosoft.com
*
*/

/**************************************
* Creating Footer About Us Widget
***************************************/

class zocker_footer_aboutus_widget extends WP_Widget {

        function __construct() {

            parent::__construct(
                // Base ID of your widget
                'zocker_footer_aboutus_widget',

                // Widget name will appear in UI
                esc_html__( 'Zocker :: Footer About Us Widget', 'zocker' ),

                // Widget description
                array(
                    'customize_selective_refresh'   => true,
                    'description'                   => esc_html__( 'Add Footer About Us Widget', 'zocker' ),
                    'classname'		                => 'pt-0',
                )
            );

        }

        // This is where the action happens
        public function widget( $args, $instance ) {

            $title        = apply_filters( 'widget_title', $instance['title'] );
			$about_us 	  = apply_filters( 'widget_about_us', $instance['about_us'] );
            $social_icon  = isset( $instance['social_icon'] ) ? $instance['social_icon'] : false;


            // before and after widget arguments are defined by themes
            echo $args['before_widget'];
                if( ! empty( $title  ) ){
                    echo $args['before_title'];
                        echo esc_html( $title );
                    echo $args['after_title'];
                }
                echo '<div class="vs-widget-about">';
    				if( ! empty( $about_us ) ){
    	                echo '<p class="about-text text-footer1 pe-xl-5">'.wp_kses_post( $about_us ).'</p>';
    	            }
                    if( $social_icon ){
                        echo '<div class="d-flex gap-2 text-white mt-45">';
							$zocker_social_icon = zocker_opt( 'zocker_social_links' );
							if( ! empty( $zocker_social_icon ) && isset( $zocker_social_icon ) ){
								foreach( $zocker_social_icon as $social_icon ){
									if( ! empty( $social_icon['title'] ) ){
										echo '<a class="icon-btn1 skew-right" href="'.esc_url( $social_icon['url'] ).'"><i class="'.esc_attr( $social_icon['title'] ).'"></i></a>';
									}
								}
							}
                        echo '</div>';
                    }
                echo '</div>';
            echo $args['after_widget'];
        }

        // Widget Backend
        public function form( $instance ) {

             //Title
             if ( isset( $instance[ 'title' ] ) ) {
                $title = $instance[ 'title' ];
            }else {
                $title = '';
            }
			
			if ( isset( $instance[ 'about_us' ] ) ) {
				$about_us = $instance[ 'about_us' ];
			}else {
				$about_us = '';
			}
			
            // Social Icon
            $social_icon = isset( $instance['social_icon'] ) ? (bool) $instance['social_icon'] : false;
            
            // Widget admin form
            ?>
            <p>
                <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:' ,'zocker'); ?></label>
                <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
            </p>
			<p>
				<label for="<?php echo $this->get_field_id( 'about_us' ); ?>">
					<?php
						_e( 'Footer About Us:' ,'dvpn');
					?>
				</label>
		        <textarea class="widefat" id="<?php echo $this->get_field_id( 'about_us' ); ?>" name="<?php echo $this->get_field_name( 'about_us' ); ?>" rows="8" cols="80"><?php echo esc_html( $about_us ); ?></textarea>
			</p>
            <p>
                <input class="checkbox" type="checkbox"<?php checked( $social_icon ); ?> id="<?php echo $this->get_field_id( 'social_icon' ); ?>" name="<?php echo $this->get_field_name( 'social_icon' ); ?>" />
                <label for="<?php echo $this->get_field_id( 'social_icon' ); ?>"><?php _e( 'Display Social Icon?' ); ?></label>
                <a href="<?php echo esc_url( home_url('/').'wp-admin/admin.php?page=Zocker&tab=17' );?>"><?php _e( 'Edit Social Icon' )?></a>
            </p>
            <?php
        }


         // Updating widget replacing old instances with new
         public function update( $new_instance, $old_instance ) {

            $instance = array();
            $instance['title'] 	        	= ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
            $instance['about_us'] 			= ( ! empty( $new_instance['about_us'] ) ) ? strip_tags( $new_instance['about_us'] ) : '';
            $instance['social_icon']      = isset( $new_instance['social_icon'] ) ? (bool) $new_instance['social_icon'] : false;
			return $instance;
        }
    } // Class zocker_footer_aboutus_widget ends here


    // Register and load the widget
    function zocker_footer_aboutus_load_widget() {
        register_widget( 'zocker_footer_aboutus_widget' );
    }
    add_action( 'widgets_init', 'zocker_footer_aboutus_load_widget' );