<?php
/**
 * @Packge     : Zocker
 * @Version    : 1.0
 * @Author     : Vecurosoft
 * @Author URI : https://www.vecurosoft.com/
 *
 */


// Blocking direct access
if( ! defined( 'ABSPATH' ) ) {
    exit;
}

function zocker_core_essential_scripts( ) {
    wp_enqueue_script('zocker-ajax',ZOCKER_PLUGDIRURI.'assets/js/zocker.ajax.js',array( 'jquery' ),'1.0',true);
    wp_localize_script(
    'zocker-ajax',
    'zockerajax',
        array(
            'action_url' => admin_url( 'admin-ajax.php' ),
            'nonce'	     => wp_create_nonce( 'zocker-nonce' ),
        )
    );
}

add_action('wp_enqueue_scripts','zocker_core_essential_scripts');


// zocker Section subscribe ajax callback function
add_action( 'wp_ajax_zocker_subscribe_ajax', 'zocker_subscribe_ajax' );
add_action( 'wp_ajax_nopriv_zocker_subscribe_ajax', 'zocker_subscribe_ajax' );

function zocker_subscribe_ajax( ){
  $apiKey = zocker_opt('zocker_subscribe_apikey');
  $listid = zocker_opt('zocker_subscribe_listid');
   if( ! wp_verify_nonce($_POST['security'], 'zocker-nonce') ) {
    echo '<div class="alert alert-danger mt-2" role="alert">'.esc_html__('You are not allowed.', 'zocker').'</div>';
   }else{
       if( !empty( $apiKey ) && !empty( $listid )  ){
           $MailChimp = new DrewM\MailChimp\MailChimp( $apiKey );

           $result = $MailChimp->post("lists/{$listid}/members",[
               'email_address'    => esc_attr( $_POST['sectsubscribe_email'] ),
               'status'           => 'subscribed',
           ]);

           if ($MailChimp->success()) {
               if( $result['status'] == 'subscribed' ){
                   echo '<div class="alert alert-success mt-2" role="alert">'.esc_html__('Thank you, you have been added to our mailing list.', 'zocker').'</div>';
               }
           }elseif( $result['status'] == '400' ) {
               echo '<div class="alert alert-danger mt-2" role="alert">'.esc_html__('This Email address is already exists.', 'zocker').'</div>';
           }else{
               echo '<div class="alert alert-danger mt-2" role="alert">'.esc_html__('Sorry something went wrong.', 'zocker').'</div>';
           }
        }else{
           echo '<div class="alert alert-danger mt-2" role="alert">'.esc_html__('Apikey Or Listid Missing.', 'zocker').'</div>';
        }
   }

   wp_die();

}