<?php
/**
 * @Packge     : Zocker
 * @Version    : 1.0
 * @Author     : Vecurosoft
 * @Author URI : https://www.vecurosoft.com/
 *
 */

    // Block direct access
    if( ! defined( 'ABSPATH' ) ){
        exit();
    }
    
    
    add_filter('wpcf7_autop_or_not', '__return_false');
    
    add_image_size( 'blog-sidebar-size', 90, 90, true );
    add_image_size( 'home-slider-blog-image', 370, 240, true );
    add_image_size( 'home-slider-blog-image-two', 370, 356, true );
    add_image_size( 'home-slider-blog-image-three', 269, 372, true );
    add_image_size( 'home-slider-blog-image-four', 370, 490, true );
    add_image_size( 'home-slider-blog-image-five', 100, 100, true );
    add_image_size( 'home-slider-blog-image-six', 360, 226, true );
    add_image_size( 'home-slider-blog-image-seven', 116, 116, true );
    add_image_size( 'home-slider-blog-image-eight', 220, 220, true );
    add_image_size( 'player-details-image-size', 170, 150, true );

    // Player Post Type
    add_action( 'init','zocker_player', 0 );

    function zocker_player(){
        $labels = array(
            'name'               => esc_html__( 'Players', 'post Category general name', 'zocker' ),
            'singular_name'      => esc_html__( 'Player', 'post Category singular name', 'zocker' ),
            'menu_name'          => esc_html__( 'Players', 'admin menu', 'zocker' ),
            'name_admin_bar'     => esc_html__( 'Player', 'add new on admin bar', 'zocker' ),
            'add_new'            => esc_html__( 'Add New', 'Player', 'zocker' ),
            'add_new_item'       => esc_html__( 'Add New Player', 'zocker' ),
            'new_item'           => esc_html__( 'New Player', 'zocker' ),
            'edit_item'          => esc_html__( 'Edit Player', 'zocker' ),
            'view_item'          => esc_html__( 'View Player', 'zocker' ),
            'all_items'          => esc_html__( 'All Players', 'zocker' ),
            'search_items'       => esc_html__( 'Search Players', 'zocker' ),
            'parent_item_colon'  => esc_html__( 'Parent Players:', 'zocker' ),
            'not_found'          => esc_html__( 'No Players found.', 'zocker' ),
            'not_found_in_trash' => esc_html__( 'No Players found in Trash.', 'zocker' ),
        );

        $args = array(
            'labels'             => $labels,
            'description'        => esc_html__( 'Description.', 'zocker' ),
            'public'             => true,
            'publicly_queryable' => true,
            'show_ui'            => true,
            'show_in_menu'       => true,
            'query_var'          => true,
            'has_archive'        => true,
            'hierarchical'       => false,
            'menu_position'      => null,
            'show_in_rest'       => true,
            'menu_icon'          => 'dashicons-index-card',
            'supports'           => array( 'title','thumbnail','editor','excerpt','elementor' ),
            'rewrite'            => array( 'slug' => 'all-players' ),
        );

        register_post_type( 'zocker_player', $args );

        $labels = array(
            'name'                       => esc_html__( 'Categories', 'taxonomy general name', 'zocker' ),
            'singular_name'              => esc_html__( 'Category', 'taxonomy singular name', 'zocker' ),
            'search_items'               => esc_html__( 'Search Categorys', 'zocker' ),
            'popular_items'              => esc_html__( 'Popular Categorys', 'zocker' ),
            'all_items'                  => esc_html__( 'All Categorys', 'zocker' ),
            'parent_item'                => null,
            'parent_item_colon'          => null,
            'edit_item'                  => esc_html__( 'Edit Category', 'zocker' ),
            'update_item'                => esc_html__( 'Update Category', 'zocker' ),
            'add_new_item'               => esc_html__( 'Add New Category', 'zocker' ),
            'new_item_name'              => esc_html__( 'New Category Name', 'zocker' ),
            'separate_items_with_commas' => esc_html__( 'Separate Categorys with commas', 'zocker' ),
            'add_or_remove_items'        => esc_html__( 'Add or remove Categorys', 'zocker' ),
            'choose_from_most_used'      => esc_html__( 'Choose from the most used Categorys', 'zocker' ),
            'not_found'                  => esc_html__( 'No Categorys found.', 'zocker' ),
            'menu_name'                  => esc_html__( 'Categories', 'zocker' ),
        );

        $args = array(
            'hierarchical'          => true,
            'labels'                => $labels,
            'show_ui'               => true,
            'show_admin_column'     => true,
            'update_count_callback' => '_update_post_term_count',
            'query_var'             => true,
            'show_in_rest'          => true,
            'rewrite'               => array( 'slug' => 'player-category' ),
        );

        register_taxonomy( 'player_category', 'zocker_player', $args );

        // Add new taxonomy, NOT hierarchical (like tags)
        $labels = array(
            'name'                       => esc_html__( 'Tags', 'taxonomy general name', 'zocker' ),
            'singular_name'              => esc_html__( 'Tag', 'taxonomy singular name', 'zocker' ),
            'search_items'               => esc_html__( 'Search Tags', 'zocker' ),
            'popular_items'              => esc_html__( 'Popular Tags', 'zocker' ),
            'all_items'                  => esc_html__( 'All Tags', 'zocker' ),
            'parent_item'                => null,
            'parent_item_colon'          => null,
            'edit_item'                  => esc_html__( 'Edit Tag', 'zocker' ),
            'update_item'                => esc_html__( 'Update Tag', 'zocker' ),
            'add_new_item'               => esc_html__( 'Add New Tag', 'zocker' ),
            'new_item_name'              => esc_html__( 'New Tag Name', 'zocker' ),
            'separate_items_with_commas' => esc_html__( 'Separate Tags with commas', 'zocker' ),
            'add_or_remove_items'        => esc_html__( 'Add or remove Tags', 'zocker' ),
            'choose_from_most_used'      => esc_html__( 'Choose from the most used Tags', 'zocker' ),
            'not_found'                  => esc_html__( 'No Tags found.', 'zocker' ),
            'menu_name'                  => esc_html__( 'Tags', 'zocker' ),
        );

        $args = array(
            'hierarchical'          => false,
            'labels'                => $labels,
            'show_ui'               => true,
            'show_admin_column'     => true,
            'update_count_callback' => '_update_post_term_count',
            'query_var'             => true,
            'show_in_rest'          => true,
            'rewrite'               => array( 'slug' => 'player-tag' ),
        );

        register_taxonomy( 'player_tag', 'zocker_player', $args );
    }
    
    // Team Post Type
    add_action( 'init','zocker_team', 0 );

    function zocker_team(){
        $labels = array(
            'name'               => esc_html__( 'Teams', 'post Category general name', 'zocker' ),
            'singular_name'      => esc_html__( 'Team', 'post Category singular name', 'zocker' ),
            'menu_name'          => esc_html__( 'Teams', 'admin menu', 'zocker' ),
            'name_admin_bar'     => esc_html__( 'Team', 'add new on admin bar', 'zocker' ),
            'add_new'            => esc_html__( 'Add New', 'Team', 'zocker' ),
            'add_new_item'       => esc_html__( 'Add New Team', 'zocker' ),
            'new_item'           => esc_html__( 'New Team', 'zocker' ),
            'edit_item'          => esc_html__( 'Edit Team', 'zocker' ),
            'view_item'          => esc_html__( 'View Team', 'zocker' ),
            'all_items'          => esc_html__( 'All Teams', 'zocker' ),
            'search_items'       => esc_html__( 'Search Teams', 'zocker' ),
            'parent_item_colon'  => esc_html__( 'Parent Teams:', 'zocker' ),
            'not_found'          => esc_html__( 'No Teams found.', 'zocker' ),
            'not_found_in_trash' => esc_html__( 'No Teams found in Trash.', 'zocker' ),
        );

        $args = array(
            'labels'             => $labels,
            'description'        => esc_html__( 'Description.', 'zocker' ),
            'public'             => true,
            'publicly_queryable' => true,
            'show_ui'            => true,
            'show_in_menu'       => true,
            'query_var'          => true,
            'has_archive'        => true,
            'hierarchical'       => false,
            'menu_position'      => null,
            'show_in_rest'       => true,
            'menu_icon'          => 'dashicons-index-card',
            'supports'           => array( 'title','thumbnail','editor','excerpt','elementor' ),
            'rewrite'            => array( 'slug' => 'all-teams' ),
        );

        register_post_type( 'zocker_team', $args );

        $labels = array(
            'name'                       => esc_html__( 'Categories', 'taxonomy general name', 'zocker' ),
            'singular_name'              => esc_html__( 'Category', 'taxonomy singular name', 'zocker' ),
            'search_items'               => esc_html__( 'Search Categorys', 'zocker' ),
            'popular_items'              => esc_html__( 'Popular Categorys', 'zocker' ),
            'all_items'                  => esc_html__( 'All Categorys', 'zocker' ),
            'parent_item'                => null,
            'parent_item_colon'          => null,
            'edit_item'                  => esc_html__( 'Edit Category', 'zocker' ),
            'update_item'                => esc_html__( 'Update Category', 'zocker' ),
            'add_new_item'               => esc_html__( 'Add New Category', 'zocker' ),
            'new_item_name'              => esc_html__( 'New Category Name', 'zocker' ),
            'separate_items_with_commas' => esc_html__( 'Separate Categorys with commas', 'zocker' ),
            'add_or_remove_items'        => esc_html__( 'Add or remove Categorys', 'zocker' ),
            'choose_from_most_used'      => esc_html__( 'Choose from the most used Categorys', 'zocker' ),
            'not_found'                  => esc_html__( 'No Categorys found.', 'zocker' ),
            'menu_name'                  => esc_html__( 'Categories', 'zocker' ),
        );

        $args = array(
            'hierarchical'          => true,
            'labels'                => $labels,
            'show_ui'               => true,
            'show_admin_column'     => true,
            'update_count_callback' => '_update_post_term_count',
            'query_var'             => true,
            'show_in_rest'          => true,
            'rewrite'               => array( 'slug' => 'team-category' ),
        );

        register_taxonomy( 'team_category', 'zocker_team', $args );

        // Add new taxonomy, NOT hierarchical (like tags)
        $labels = array(
            'name'                       => esc_html__( 'Tags', 'taxonomy general name', 'zocker' ),
            'singular_name'              => esc_html__( 'Tag', 'taxonomy singular name', 'zocker' ),
            'search_items'               => esc_html__( 'Search Tags', 'zocker' ),
            'popular_items'              => esc_html__( 'Popular Tags', 'zocker' ),
            'all_items'                  => esc_html__( 'All Tags', 'zocker' ),
            'parent_item'                => null,
            'parent_item_colon'          => null,
            'edit_item'                  => esc_html__( 'Edit Tag', 'zocker' ),
            'update_item'                => esc_html__( 'Update Tag', 'zocker' ),
            'add_new_item'               => esc_html__( 'Add New Tag', 'zocker' ),
            'new_item_name'              => esc_html__( 'New Tag Name', 'zocker' ),
            'separate_items_with_commas' => esc_html__( 'Separate Tags with commas', 'zocker' ),
            'add_or_remove_items'        => esc_html__( 'Add or remove Tags', 'zocker' ),
            'choose_from_most_used'      => esc_html__( 'Choose from the most used Tags', 'zocker' ),
            'not_found'                  => esc_html__( 'No Tags found.', 'zocker' ),
            'menu_name'                  => esc_html__( 'Tags', 'zocker' ),
        );

        $args = array(
            'hierarchical'          => false,
            'labels'                => $labels,
            'show_ui'               => true,
            'show_admin_column'     => true,
            'update_count_callback' => '_update_post_term_count',
            'query_var'             => true,
            'show_in_rest'          => true,
            'rewrite'               => array( 'slug' => 'team-tag' ),
        );

        register_taxonomy( 'team_tag', 'zocker_team', $args );
    }

    if( ! function_exists( 'zocker_players_category' ) ){
        function zocker_players_category(){
            $cat_array = array();
            $cat_array[] = esc_html__( 'Select a category','zocker' );
            $terms = get_terms( array(
                'taxonomy'      => 'player_category',
                'hide_empty'    => true
            ) );
            if( is_array( $terms ) && $terms ){
                foreach( $terms as $term ){
                    $cat_array[$term->slug] = $term->name;
                }
            }
            return $cat_array;
        }
    }
    
    if( ! function_exists( 'zocker_teams_category' ) ){
        function zocker_teams_category(){
            $cat_array = array();
            $cat_array[] = esc_html__( 'Select a category','zocker' );
            $terms = get_terms( array(
                'taxonomy'      => 'team_category',
                'hide_empty'    => true
            ) );
            if( is_array( $terms ) && $terms ){
                foreach( $terms as $term ){
                    $cat_array[$term->slug] = $term->name;
                }
            }
            return $cat_array;
        }
    }

    /**
     * Single Template
     */
    add_filter( 'single_template', 'zocker_core_template_redirect' );

    if( ! function_exists( 'zocker_core_template_redirect' ) ){
        function zocker_core_template_redirect( $single_template ){

            global $post;

            // Player Single Page
            if( $post ){
                if( $post->post_type == 'zocker_player' ){
                    $single_template = ZOCKER_CORE_PLUGIN_TEMP . 'single-zocker_player.php';
                }
                if( $post->post_type == 'zocker_team' ){
                    $single_template = ZOCKER_CORE_PLUGIN_TEMP . 'single-zocker_team.php';
                }
            }

            return $single_template;
        }
    }

    /**
     * Archive Template
     */
    add_filter( 'archive_template', 'zocker_core_template_archive' );

    if( ! function_exists( 'zocker_core_template_archive' ) ){
        function zocker_core_template_archive( $archive_template ){

            global $post;

            // Player Archive Template
            if( $post ){
                if( $post->post_type == 'zocker_player' ){
                    $archive_template = ZOCKER_CORE_PLUGIN_TEMP . 'archive-zocker_player.php';
                }
                if( $post->post_type == 'zocker_team' ){
                    $archive_template = ZOCKER_CORE_PLUGIN_TEMP . 'archive-zocker_team.php';
                }
            }

            return $archive_template;
        }
    }
