<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
/**
 *
 * Gallery Image Widget .
 *
 */
class Playrex_Gallery_Image extends Widget_Base {

	public function get_name() {
		return 'playrexgalleryimage';
	}

	public function get_title() {
		return __( 'Gallery Image', 'playrex' );
	}


	public function get_icon() {
		return 'eicon-code';
    }


	public function get_categories() {
		return [ 'playrex' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'gallery_image_section',
			[
				'label' 	=> __( 'Gallery Image', 'playrex' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'section_title',
            [
				'label'         => __( 'Section Title', 'playrex' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Gallery Posts' , 'playrex' ),
				'label_block'   => true,

			]
		);

        $repeater = new Repeater();

		$repeater->add_control(
			'gallery_image',
			[
				'label' 	=> __( 'Gallery Image', 'playrex' ),
				'type' 		=> Controls_Manager::MEDIA,
				'default' => [
					'url' 	=> Utils::get_placeholder_image_src(),
				],
			]
		);

		$repeater->add_control(
			'image_link',
			[
				'label' 		=> __( 'Link', 'playrex' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'playrex' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
			]
		);


		$this->add_control(
			'gallery',
			[
				'label' 		=> __( 'Gallery Images', 'playrex' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'gallery_image' => Utils::get_placeholder_image_src(),
					],
					[
						'gallery_image' => Utils::get_placeholder_image_src(),
					],
					[
						'gallery_image' => Utils::get_placeholder_image_src(),
					],
					[
						'gallery_image' => Utils::get_placeholder_image_src(),
					],
					[
						'gallery_image' => Utils::get_placeholder_image_src(),
					],
				]
			]
		);

        $this->end_controls_section();

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		echo '<div class="widget footer-widget">';
			if( ! empty( $settings['section_title'] ) ){
				echo '<h4 class="widget_title">'.esc_html( $settings['section_title'] ).'</h4>';
			}
			if( ! empty( $settings['gallery'] ) ){
				echo '<div class="footer-gallery">';
					foreach( $settings['gallery'] as $singlelogo ) {
						$target 	= $singlelogo['image_link']['is_external'] ? ' target="_blank"' : '';
						$nofollow 	= $singlelogo['image_link']['nofollow'] ? ' rel="nofollow"' : '';
						echo '<div class="gal-item">';
							echo '<a '.wp_kses_post( $nofollow.$target ).' href="'.esc_url( $singlelogo['image_link']['url'] ).'">';
								echo '<img class="w-100" src="'.esc_url( $singlelogo['gallery_image']['url'] ).'" alt="'.esc_attr( playrex_image_alt( $singlelogo['gallery_image']['url']) ).'">';
							echo '</a>';
						echo '</div>';
					}
				echo '</div>';
			}
		echo '</div>';
	}
}