<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Border;
/**
 *
 * Header Widget .
 *
 */
class Playrex_Headertop extends Widget_Base {

	public function get_name() {
		return 'playrexheadertop';
	}

	public function get_title() {
		return __( 'Header Top', 'playrex' );
	}

	public function get_icon() {
		return 'eicon-code playrex';
    }

	public function get_categories() {
		return [ 'playrex_header_elements' ];
	}

    public function get_keywords() {
		return [ 'header', 'top', 'topbar'];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'header_top',
			[
				'label' 	=> __( 'Header Top', 'playrex' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'header_top_left',
			[
				'label' 	=> __( 'Smpall Text', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( 'Welcome to our Esports Games and Team Players', 'playrex' ),
                'label_block'   => true,
			]
        );

        /*  --------------- Phone Contnt ---------------*/
        $this->add_control(
			'phone_icon',
			[
				'label' => __( 'Phone Icon', 'playrex' ),
				'type' => Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'solid',
				],
			]
		);
        $this->add_control(
			'phone_name',
			[
				'label' 	=> __( 'Name', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( 'Phone', 'playrex' ),
                'label_block'   => true,
			]
        );
        $this->add_control(
			'number_text',
			[
				'label' 	=> __( 'Number', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( '020 7388 5619', 'playrex' ),
                'label_block'   => true,
			]
        );
        $this->add_control(
			'number_url',
			[
				'label' 	=> __( 'Url', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( 'tel:020 7388 5619', 'playrex' ),
                'label_block'   => true,
			]
        );
        /*  --------------- End Phone Contnt ---------------*/

        /*  --------------- Email Contnt ---------------*/
        $this->add_control(
			'email_icon',
			[
				'label' => __( 'email Icon', 'playrex' ),
				'type' => Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'solid',
				],
			]
		);
        $this->add_control(
			'email_name',
			[
				'label' 	=> __( 'Name', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( 'Email', 'playrex' ),
                'label_block'   => true,
			]
        );
        $this->add_control(
			'email_text',
			[
				'label' 	=> __( 'Number', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( 'contact@example.com', 'playrex' ),
                'label_block'   => true,
			]
        );
        $this->add_control(
			'email_url',
			[
				'label' 	=> __( 'Url', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( 'mailto:contact@example.com', 'playrex' ),
                'label_block'   => true,
			]
        );
        /*  --------------- End Email Contnt ---------------*/
        $this->end_controls_section();

        /*  --------------- Style  ---------------*/
        $this->start_controls_section(
			'header_top_style',
			[
				'label'		 	=> __( 'Header Top', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'header_top_bg',
            [
                'label'     => __('Wraper Bg', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .header-top' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'sample_text',
            [
                'label'     => __('Sampll Text', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .header-top-text' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'info_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .header-top-text',
			]
		);

        $this->add_control(
			'header_top_contact_info_heading',
			[
				'label' => esc_html__( 'Contact Info', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
				'separator' => 'after',
			]
		);

        // phone
        $this->add_control(
            '',
            [
                'label'     => __('Text Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .header-links a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'c_inco_typo',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .header-links a',
			]
		);
        $this->end_controls_section();

        // Icon 
        $this->start_controls_section(
			'Icon_top_style',
			[
				'label'		 	=> __( 'Icon', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'icon_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .header-links.style2 i' => 'color: {{VALUE}}',
                ],
            ]
        );

        
        $this->add_control(
            'icon_bg_color',
            [
                'label'     => __('Icon Bg Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .header-links.style2 i' => 'color: {{VALUE}}',
                ],
            ]
        );

        // Hover 
        $this->add_control(
            'icon_hover_color',
            [
                'label'     => __('Hover Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .header-links.style2 i:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'icon_bg_hover_color',
            [
                'label'     => __('Hover Bg Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .header-links.style2 i:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
			'icon_size',
			[
				'label' => __( 'Font Size', 'mas-addons' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .header-links.style2 i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'icon_box_size',
			[
				'label' => __( 'Box Size', 'mas-addons' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .header-links.style2 i' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'icon_box_margin',
			[
				'label' => __( 'Margin Right', 'mas-addons' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .header-links.style2 i' => 'margin-right: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        $header_top_left = $settings['header_top_left'];
        $phone_icon = $settings['phone_icon'];
        $phone_name = $settings['phone_name'];
        $number_text = $settings['number_text'];
        $number_url = $settings['number_url'];
        $mail_icon = $settings['email_icon'];
        $email_name = $settings['email_name'];
        $email_text = $settings['email_text'];
        $email_url = $settings['email_url'];
        $this->add_render_attribute( 'wrapper', 'class', 'header-top' );
       ?>
        <div class="header-layout2">
            <div <?php echo $this->get_render_attribute_string('wrapper') ?>>
                <div class="container">
                    <div class="row align-items-center text-center text-lg-start">
                        <div class="col d-none d-lg-block">
                            <p class="header-top-text">
                                <?php echo esc_html($header_top_left ); ?>
                            </p>
                        </div>
                        <div class="col-lg-auto">
                            <div class="header-links style2">
                                <ul>
                                    <?php if(!empty($number_text)): ?>
                                        <li>
                                            <a href="<?php echo esc_url($number_url); ?>"><?php \Elementor\Icons_Manager::render_icon( $phone_icon, [ 'aria-hidden' => 'true' ] ) ?></a>
                                            <?php echo esc_html($phone_name); ?>
                                            <a href="<?php echo esc_url($number_url); ?>">
                                                <?php echo esc_html($number_text); ?>
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                    
                                    <?php if(!empty($email_text)): ?>
                                        <li>
                                            <a href="<?php echo esc_url($email_text); ?>"><?php \Elementor\Icons_Manager::render_icon( $mail_icon, [ 'aria-hidden' => 'true' ] ) ?></a>
                                            <?php echo esc_html($email_name); ?>
                                            <a href="<?php echo esc_url($email_url); ?>">
                                                <?php echo esc_html( $email_text); ?>
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
       <?php 
	}

}