<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Border;
/**
 *
 * Mobilemenu Widget .
 *
 */
class Playrex_Offcanvas extends Widget_Base {

	public function get_name() {
		return 'playrexoffcanvas';
	}

	public function get_title() {
		return __( 'Offcanvas', 'playrex' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'playrex_header_elements' ];
	}

	protected function register_controls() {


		
		$this->start_controls_section(
			'offcanvas_section',
			[
				'label' 	=> __( 'Offcanvas', 'playrex' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'playrex_Offcanvas_builder',
			[
				'label'     => __( 'Select Offcanvas', 'playrex' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => $this->playrex_offcanvas_one(),
				'default'	=> ''
			]
		);

		$this->add_control(
			'icon_color',
			[
				'label' 		=> __( 'Icon Color', 'playrex' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .sideMenuToggler' => 'color: {{VALUE}}',
                ],
			]
        );

		$this->add_control(
			'icon_hover_color',
			[
				'label' 		=> __( 'Icon Hover Color', 'playrex' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .sideMenuToggler:hover' => 'color: {{VALUE}}',
                ],
			]
        );

		$this->add_control(
			'icon_bg_color',
			[
				'label' 		=> __( 'Close Background Color', 'playrex' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .closeButton' => 'background-color: {{VALUE}}',
                ],
			]
        );

		$this->add_control(
			'icon_bg_hover_color',
			[
				'label' 		=> __( 'Icon Background Hover Color', 'playrex' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .closeButton:hover' => 'background-color: {{VALUE}}',
                ],
			]
        );

		$this->add_control(
			'offcanvas_bg_color',
			[
				'label' 		=> __( 'Offcanvas Background Color', 'playrex' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .sidemenu-content' => 'background-color: {{VALUE}}',
                ],
			]
        );


		$this->add_responsive_control(
			'offcanvas_padding',
			[
				'label' 		=> __( 'Padding', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .sideMenuToggler' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->end_controls_section();

    }


	public function playrex_offcanvas_one(){

		$playrex_post_query = new WP_Query( array(
			'post_type'				=> 'playrex_off_build',
			'posts_per_page'	    => -1,
		) );

		$playrex_tab_builder_title_title = array();
		$playrex_tab_builder_title_title[''] = __( 'Select a Title','Playrex');

		while( $playrex_post_query->have_posts() ) {
			$playrex_post_query->the_post();
			$playrex_tab_builder_title_title[ get_the_ID() ] =  get_the_title();
		}
		wp_reset_postdata();
		return $playrex_tab_builder_title_title;
	}

	protected function render() {

        $settings = $this->get_settings_for_display();
		?>

		<div class="sidemenu-wrapper d-none d-lg-block">
				<div class="sidemenu-content">
					<button class="closeButton sideMenuCls"><i class="far fa-times"></i></button>
					<?php
						$elementor = \Elementor\Plugin::instance();
						echo $elementor->frontend->get_builder_content_for_display($settings['playrex_Offcanvas_builder']);
					?>
				</div>
			</div>
			<!-- MENU BAR -->
			<div class="header-icons style2">
				<button class="sideMenuToggler"><i class="fal fa-bars"></i></button>
			</div>
		<?php

	}
}