<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Border;
/**
 *
 * Header Widget .
 *
 */
class Playrex_Search extends Widget_Base {

	public function get_name() {
		return 'playrexsearch';
	}

	public function get_title() {
		return __( 'Search Form', 'playrex' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'playrex_header_elements' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'header_search',
			[
				'label' 	=> __( 'Header Search', 'playrex' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
		$this->add_control(
			'placeholder_text',
			[
				'label' 		=> __( 'Playrex Placeholder Text', 'playrex' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default'		=> __( 'Search Here...', 'playrex' ),
			]
		);

        $this->end_controls_section();

		$this->start_controls_section(
			'search_style',
			[
				'label' 	=> __( 'Style', 'playrex' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'search_background_color',
			[
				'label' 		=> __( 'Search Background Color', 'playrex' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .header-search button' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();


    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        echo '<form action="'.esc_url( home_url() ).'" class="header-search">';
            echo '<input name="s" type="text" placeholder="'.esc_attr( $settings['placeholder_text'] ).'">';
            echo '<button type="submit" aria-label="search-button"><i class="far fa-search"></i></button>';
        echo '</form>';

	}

}